/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.views.outline.AbstractGraphicsTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.DiagramTreeEditPart;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class FlowElementTreeEditPart
extends AbstractGraphicsTreeEditPart {
    public FlowElementTreeEditPart(DiagramTreeEditPart dep, FlowElement flowElement) {
        super(dep, flowElement);
    }

    public FlowElement getFlowElement() {
        return (FlowElement)this.getModel();
    }

    protected void createEditPolicies() {
    }

    protected List<Object> getModelChildren() {
        Definitions definitions;
        ArrayList<Object> retList = new ArrayList<Object>();
        FlowElement elem = this.getFlowElement();
        if (elem instanceof FlowElementsContainer) {
            FlowElementsContainer container = (FlowElementsContainer)elem;
            return FlowElementTreeEditPart.getFlowElementsContainerChildren(container);
        }
        if (elem instanceof ChoreographyActivity) {
            ChoreographyActivity ca = (ChoreographyActivity)elem;
            retList.addAll(ca.getParticipantRefs());
        } else if (elem instanceof CallActivity) {
            CallableElement target = ((CallActivity)elem).getCalledElementRef();
            if (target != null) {
                retList.add(target);
            }
        } else if (elem instanceof CatchEvent) {
            retList.addAll(((CatchEvent)elem).getEventDefinitions());
            retList.addAll(((CatchEvent)elem).getDataOutputAssociation());
        } else if (elem instanceof ThrowEvent) {
            retList.addAll(((ThrowEvent)elem).getEventDefinitions());
            retList.addAll(((ThrowEvent)elem).getDataInputAssociation());
        }
        if (elem instanceof Activity && (definitions = ModelUtil.getDefinitions((EObject)elem)) != null) {
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                if (!(o instanceof BoundaryEvent) || ((BoundaryEvent)o).getAttachedToRef() != elem) continue;
                retList.add(o);
            }
            retList.addAll(((Activity)elem).getDataInputAssociations());
            retList.addAll(((Activity)elem).getDataOutputAssociations());
        }
        return retList;
    }

    public static List<Object> getFlowElementsContainerChildren(FlowElementsContainer container) {
        ArrayList<Object> retList = new ArrayList<Object>();
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        for (FlowElement fe : container.getFlowElements()) {
            if (fe instanceof BoundaryEvent) continue;
            flowElements.add(fe);
        }
        if (container.getLaneSets().size() == 0) {
            retList.addAll(flowElements);
        } else {
            for (LaneSet ls : container.getLaneSets()) {
                retList.addAll(ls.getLanes());
            }
            ArrayList<FlowElement> laneElements = new ArrayList<FlowElement>();
            for (FlowElement fe : flowElements) {
                boolean inLane = false;
                for (LaneSet ls : container.getLaneSets()) {
                    if (!FlowElementTreeEditPart.isInLane(fe, ls)) continue;
                    inLane = true;
                    break;
                }
                if (inLane) {
                    laneElements.add(fe);
                    continue;
                }
                retList.add(fe);
            }
            ArrayList<SequenceFlow> flows = new ArrayList<SequenceFlow>();
            for (Object e : laneElements) {
                if (!(e instanceof FlowNode)) continue;
                for (SequenceFlow sf : ((FlowNode)e).getIncoming()) {
                    if (!laneElements.contains(sf.getSourceRef()) || !laneElements.contains(sf.getTargetRef()) || flows.contains(sf)) continue;
                    flows.add(sf);
                }
                for (SequenceFlow sf : ((FlowNode)e).getOutgoing()) {
                    if (!laneElements.contains(sf.getSourceRef()) || !laneElements.contains(sf.getTargetRef()) || flows.contains(sf)) continue;
                    flows.add(sf);
                }
            }
            retList.removeAll(flows);
        }
        if (container instanceof Process) {
            retList.addAll(((Process)container).getArtifacts());
        } else if (container instanceof SubProcess) {
            retList.addAll(((SubProcess)container).getArtifacts());
        }
        if (container instanceof SubChoreography) {
            retList.addAll(((SubChoreography)container).getArtifacts());
        }
        return retList;
    }

    public static boolean isInLane(FlowElement fe, LaneSet ls) {
        if (ls == null || ls.getLanes().size() == 0) {
            return false;
        }
        for (Lane ln : ls.getLanes()) {
            if (ln.getFlowNodeRefs().contains(fe)) {
                return true;
            }
            if (!FlowElementTreeEditPart.isInLane(fe, ln.getChildLaneSet())) continue;
            return true;
        }
        return false;
    }
}

