/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.views.outline.AbstractGraphicsTreeEditPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.Adaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class BPMN2EditorOutlineTreeViewer
extends TreeViewer
implements Adaptable {
    protected DiagramEditor diagramEditor;

    public BPMN2EditorOutlineTreeViewer(DiagramEditor diagramEditor) {
        this.diagramEditor = diagramEditor;
    }

    public EditPart convert(EditPart part) {
        Object model = part.getModel();
        if (model instanceof PictogramElement) {
            PictogramElement pe = (PictogramElement)model;
            BaseElement bpmnModel = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe);
            if (bpmnModel == null) {
                bpmnModel = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)pe);
            }
            if (bpmnModel instanceof BPMNDiagram) {
                BPMNDiagram bpmnDiagram = (BPMNDiagram)bpmnModel;
                bpmnModel = bpmnDiagram.getPlane().getBpmnElement();
            }
            return (EditPart)this.getEditPartRegistry().get(bpmnModel);
        }
        return part;
    }

    public static EditPart convert(GraphicalViewer viewer, AbstractGraphicsTreeEditPart part) {
        Object pe = part.getAdapter(PictogramElement.class);
        return (EditPart)viewer.getEditPartRegistry().get(pe);
    }

    public void setSelection(ISelection newSelection) {
        StructuredSelection ss;
        if (newSelection instanceof StructuredSelection && (ss = (StructuredSelection)newSelection).getFirstElement() instanceof AbstractGraphicsTreeEditPart) {
            AbstractGraphicsTreeEditPart editPart = (AbstractGraphicsTreeEditPart)((Object)ss.getFirstElement());
            Diagram diagram = this.diagramEditor.getDiagramTypeProvider().getDiagram();
            EditPart editPartParent = editPart.getParent();
            while (editPartParent != null) {
                Object model = editPartParent.getModel();
                if (model instanceof EObject) {
                    for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(diagram, (EObject)model)) {
                        String value = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "is-expanded-key");
                        if (value == null || Boolean.parseBoolean(value)) continue;
                        super.setSelection((ISelection)new StructuredSelection((Object)editPartParent));
                        return;
                    }
                }
                editPartParent = editPartParent.getParent();
            }
        }
        super.setSelection(newSelection);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == BPMN2Editor.class) {
            return this.diagramEditor;
        }
        return null;
    }
}

