/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views;

import java.io.IOException;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.views.ViewContentProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

class BpmnModelViewerSelectionListener
implements ISelectionListener {
    private final ViewContentProvider contentProvider;
    private BPMN2Editor editor;
    private final TreeViewer viewer;

    public BpmnModelViewerSelectionListener(TreeViewer viewer) {
        this.viewer = viewer;
        this.contentProvider = (ViewContentProvider)viewer.getContentProvider();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object[] selected;
        Object bpmn2Editor = part.getAdapter(BPMN2Editor.class);
        if (bpmn2Editor instanceof BPMN2Editor) {
            this.editor = (BPMN2Editor)((Object)bpmn2Editor);
            try {
                ModelHandler modelHandler = ModelHandlerLocator.getModelHandler((Resource)this.editor.getDiagramTypeProvider().getDiagram().eResource());
                this.contentProvider.updateModel(modelHandler);
                this.viewer.refresh(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((selected = this.contentProvider.getSelected(selection)) != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(selected), true);
        }
    }
}

