/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.tasks;

import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.property.tasks.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;

public class IoParameterMappingColumn
extends TableColumn {
    protected DataAssociation association = null;

    public IoParameterMappingColumn(EObject o, EStructuralFeature f) {
        super(o, f);
    }

    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        return ModelUtil.getLabel((EObject)Bpmn2Package.eINSTANCE.getDataAssociation(), (EStructuralFeature)(this.feature.getName().startsWith("dataInput") ? Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef() : Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef()));
    }

    public String getText(Object element) {
        String text = null;
        ItemAwareElement source = (ItemAwareElement)element;
        DataAssociation da = this.getDataAssociation(source);
        if (da != null) {
            ItemAwareElement target = this.getTargetElement(da);
            if (target != null) {
                text = ModelUtil.getDisplayName((Object)target);
            } else {
                if (da.getTransformation() != null) {
                    text = String.valueOf(Messages.IoParameterMappingColumn_Transform_Prefix) + ModelUtil.getDisplayName((Object)da.getTransformation());
                }
                if (!da.getAssignment().isEmpty()) {
                    String text2 = null;
                    for (Assignment assign : da.getAssignment()) {
                        FormalExpression expr = this.getTargetExpression(da, assign);
                        String body = ModelUtil.getDisplayName((Object)expr);
                        text2 = text2 == null ? "\"" + body + "\"" : String.valueOf(text2) + ",\n" + body;
                    }
                    text = text == null ? text2 : String.valueOf(text) + " + " + text2;
                }
            }
        }
        return text == null ? "" : text;
    }

    private FormalExpression getTargetExpression(DataAssociation da, Assignment assign) {
        return (FormalExpression)(da instanceof DataInputAssociation ? assign.getFrom() : assign.getTo());
    }

    public Object getValue(Object element, String property) {
        Integer value = new Integer(-1);
        ItemAwareElement source = (ItemAwareElement)element;
        DataAssociation da = this.getDataAssociation(source);
        if (da != null) {
            ItemAwareElement target = this.getTargetElement(da);
            this.association = da;
            EStructuralFeature f = this.getTargetFeature(source);
            CellEditor ce = this.getCellEditor();
            if (ce instanceof TableColumn.CustomComboBoxCellEditor) {
                ((TableColumn.CustomComboBoxCellEditor)ce).setValue((EObject)da, f, (Object)target);
                value = (Integer)this.getCellEditor().getValue();
            }
        }
        return value;
    }

    public CellEditor createCellEditor(Composite parent) {
        return new TableColumn.CustomComboBoxCellEditor(this, parent, this.feature){

            public void activate(ColumnViewerEditorActivationEvent activationEvent) {
                ItemAwareElement source;
                DataAssociation da;
                Object element;
                Object activationSource = activationEvent.getSource();
                if (activationSource instanceof ViewerCell && (element = ((ViewerCell)activationSource).getElement()) instanceof ItemAwareElement && (da = IoParameterMappingColumn.this.getDataAssociation(source = (ItemAwareElement)element)) != null) {
                    ItemAwareElement target = IoParameterMappingColumn.this.getTargetElement(da);
                    IoParameterMappingColumn.this.association = da;
                    EStructuralFeature f = IoParameterMappingColumn.this.getTargetFeature(source);
                    this.setValue((EObject)da, f, target);
                }
            }
        };
    }

    public boolean canModify(Object element, String property) {
        DataAssociation da;
        if (super.canModify(element, property) && (da = this.getDataAssociation((ItemAwareElement)element)) != null) {
            return this.getTargetElement(da) != null || da.getAssignment().isEmpty() && da.getTransformation() == null;
        }
        return false;
    }

    public void modify(Object element, String property, Object value) {
        EStructuralFeature f = this.getTargetFeature((ItemAwareElement)element);
        super.modify((EObject)this.association, f, value);
        this.tableViewer.refresh(element);
    }

    protected List<DataAssociation> getDataAssociations(ItemAwareElement element) {
        if (element instanceof DataInput) {
            return this.getDataInputAssociations();
        }
        if (element instanceof DataOutput) {
            return this.getDataOutputAssociations();
        }
        return null;
    }

    public List getDataInputAssociations() {
        if (this.object instanceof Activity) {
            return ((Activity)this.object).getDataInputAssociations();
        }
        if (this.object instanceof ThrowEvent) {
            return ((ThrowEvent)this.object).getDataInputAssociation();
        }
        return null;
    }

    public List getDataOutputAssociations() {
        if (this.object instanceof Activity) {
            return ((Activity)this.object).getDataOutputAssociations();
        }
        if (this.object instanceof CatchEvent) {
            return ((CatchEvent)this.object).getDataOutputAssociation();
        }
        return null;
    }

    protected DataAssociation getDataAssociation(ItemAwareElement element) {
        for (DataAssociation da : this.getDataAssociations(element)) {
            if (element != this.getSourceElement(da)) continue;
            return da;
        }
        return null;
    }

    protected ItemAwareElement getSourceElement(DataAssociation da) {
        if (da instanceof DataOutputAssociation) {
            if (da.getSourceRef().size() == 1) {
                return (ItemAwareElement)da.getSourceRef().get(0);
            }
        } else if (da instanceof DataInputAssociation) {
            return da.getTargetRef();
        }
        return null;
    }

    protected ItemAwareElement getTargetElement(DataAssociation da) {
        if (da instanceof DataInputAssociation) {
            if (da.getSourceRef().size() == 1) {
                return (ItemAwareElement)da.getSourceRef().get(0);
            }
        } else if (da instanceof DataOutputAssociation) {
            return da.getTargetRef();
        }
        return null;
    }

    protected EStructuralFeature getTargetFeature(ItemAwareElement element) {
        return element instanceof DataInput ? Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef() : Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef();
    }
}

