/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDAttributeDeclarationTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDElementDeclarationTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDTypeDefinitionTreeNode;
import org.eclipse.bpmn2.modeler.ui.util.XSDUtils;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class XSDTreeNode
extends TreeNode {
    public XSDTreeNode(Object modelObject, boolean isCondensed) {
        super(modelObject, isCondensed);
    }

    public static List getInheritedXSDElementsAndAttributes(XSDComplexTypeDefinition complexType) {
        ArrayList<XSDFeature> result = new ArrayList<XSDFeature>();
        XSDTypeDefinition parent = complexType.getBaseTypeDefinition();
        if (parent instanceof XSDComplexTypeDefinition && complexType.isSetDerivationMethod()) {
            result.addAll(XSDTreeNode.getInheritedXSDElementsAndAttributes((XSDComplexTypeDefinition)parent));
            result.addAll(XSDUtils.getXSDElementsAndAttributes((XSDComplexTypeDefinition)parent));
        }
        return result;
    }

    protected void addComplexTypeContent(XSDComplexTypeDefinition complexType, Vector<TreeNode> v) {
        List attrs = XSDTreeNode.getInheritedXSDElementsAndAttributes(complexType);
        attrs.addAll(XSDUtils.getXSDElementsAndAttributes(complexType));
        for (Object attr : attrs) {
            if (attr instanceof XSDAttributeDeclaration) {
                v.add(new XSDAttributeDeclarationTreeNode((XSDAttributeDeclaration)attr, this.isCondensed));
                continue;
            }
            if (attr instanceof XSDElementDeclaration) {
                v.add(new XSDElementDeclarationTreeNode((XSDElementDeclaration)attr, this.isCondensed));
                continue;
            }
            if (!(attr instanceof XSDComplexTypeDefinition)) continue;
            v.add(new XSDTypeDefinitionTreeNode((XSDTypeDefinition)((XSDComplexTypeDefinition)attr), this.isCondensed));
        }
    }

    protected boolean complexTypeHasChildren(XSDComplexTypeDefinition complexType) {
        if (!XSDUtils.getXSDElementsAndAttributes(complexType).isEmpty()) {
            return true;
        }
        return !XSDTreeNode.getInheritedXSDElementsAndAttributes(complexType).isEmpty();
    }

    protected void addNodes(List<TreeNode> dstList, List srcList) {
        for (Object obj : srcList) {
            if (obj instanceof XSDAttributeDeclaration) {
                dstList.add(new XSDAttributeDeclarationTreeNode((XSDAttributeDeclaration)obj, this.isCondensed));
                continue;
            }
            if (obj instanceof XSDElementDeclaration) {
                dstList.add(new XSDElementDeclarationTreeNode((XSDElementDeclaration)obj, this.isCondensed));
                continue;
            }
            if (!(obj instanceof XSDTypeDefinition)) continue;
            dstList.add(new XSDTypeDefinitionTreeNode((XSDTypeDefinition)obj, this.isCondensed));
        }
    }
}

