/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2TabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.property.AdvancedPropertySection;
import org.eclipse.bpmn2.modeler.ui.property.TabDescriptorList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;

public class PropertyTabDescriptorProvider
implements ITabDescriptorProvider {
    Hashtable<EObject, TabDescriptorList> tabDescriptorListMap = new Hashtable();

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        TabDescriptorList tabDescriptorList = null;
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForSelection((ISelection)selection);
        if (businessObject != null && (tabDescriptorList = this.tabDescriptorListMap.get(businessObject)) != null) {
            return tabDescriptorList.toArray();
        }
        TargetRuntime rt = TargetRuntime.getDefaultRuntime();
        Object bpmn2Editor = part.getAdapter(BPMN2Editor.class);
        if (bpmn2Editor instanceof BPMN2Editor) {
            rt = ((BPMN2Editor)((Object)bpmn2Editor)).getTargetRuntime(this);
        }
        ArrayList desc = null;
        if (rt != TargetRuntime.getDefaultRuntime()) {
            desc = TargetRuntime.getDefaultRuntime().getTabDescriptors();
            desc.addAll(rt.getTabDescriptors());
        } else {
            desc = rt.getTabDescriptors();
        }
        ArrayList<Bpmn2TabDescriptor> replaced = new ArrayList<Bpmn2TabDescriptor>();
        for (Bpmn2TabDescriptor d : desc) {
            String[] replacements;
            String replacedId = d.getReplaceTab();
            if (replacedId == null) continue;
            String[] stringArray = replacements = replacedId.split(" ");
            int n = replacements.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                for (Bpmn2SectionDescriptor s : d.getSectionDescriptors()) {
                    Bpmn2TabDescriptor replacedTab;
                    if (!s.doReplaceTab(id, part, selection) || (replacedTab = TargetRuntime.findTabDescriptor((String)id)) == null) continue;
                    replaced.add(replacedTab);
                    int i = desc.indexOf(replacedTab);
                    if (i < 0) continue;
                    desc.set(i, d);
                }
                ++n2;
            }
        }
        if (replaced.size() > 0) {
            desc.removeAll(replaced);
        }
        int i = desc.size() - 1;
        while (i >= 0) {
            Bpmn2TabDescriptor d = (Bpmn2TabDescriptor)desc.get(i);
            int j = i - 1;
            while (j >= 0) {
                if (desc.get(j) == d) {
                    desc.remove(i);
                    break;
                }
                --j;
            }
            --i;
        }
        ArrayList<Bpmn2TabDescriptor> emptyTabs = new ArrayList<Bpmn2TabDescriptor>();
        Bpmn2TabDescriptor advancedPropertyTab = null;
        for (Bpmn2TabDescriptor d : desc) {
            boolean empty = true;
            for (Bpmn2SectionDescriptor s : d.getSectionDescriptors()) {
                if (s.appliesTo(part, selection)) {
                    empty = false;
                }
                if (!(s.getSectionClass() instanceof AdvancedPropertySection)) continue;
                advancedPropertyTab = d;
            }
            if (!empty) continue;
            emptyTabs.add(d);
        }
        if (emptyTabs.size() > 0) {
            desc.removeAll(emptyTabs);
        }
        if (advancedPropertyTab != null && desc.remove(advancedPropertyTab)) {
            desc.add(advancedPropertyTab);
        }
        replaced.clear();
        for (Bpmn2TabDescriptor td : desc) {
            replaced.add(td.copy());
        }
        if (businessObject != null) {
            tabDescriptorList = new TabDescriptorList();
            tabDescriptorList.addAll(replaced);
            this.tabDescriptorListMap.put(businessObject, tabDescriptorList);
            return tabDescriptorList.toArray();
        }
        return replaced.toArray(new ITabDescriptor[replaced.size()]);
    }

    public void disposeTabDescriptors(Resource resource) {
        if (resource != null) {
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                this.tabDescriptorListMap.remove(object);
            }
        }
    }
}

