/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablementTreeEntry;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.preferences.ToolProfilesPreferencesHelper;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.FeatureMap;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.preferences.Bpmn2EditorBehaviorPreferencePage;
import org.eclipse.bpmn2.modeler.ui.preferences.Bpmn2HomePreferencePage;
import org.eclipse.bpmn2.modeler.ui.preferences.Messages;
import org.eclipse.bpmn2.modeler.ui.preferences.ModelEnablementTreeViewer;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ToolProfilesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String PAGE_ID = "org.eclipse.bpmn2.modeler.Profiles";
    private Bpmn2Preferences preferences;
    private TargetRuntime currentRuntime;
    private ModelUtil.Bpmn2DiagramType currentDiagramType;
    private String currentProfile;
    private final List<ModelEnablementTreeEntry> bpmnEntries = new ArrayList<ModelEnablementTreeEntry>();
    private final List<ModelEnablementTreeEntry> extensionEntries = new ArrayList<ModelEnablementTreeEntry>();
    private Combo cboRuntimes;
    private Combo cboDiagramTypes;
    private Combo cboProfiles;
    private Button btnUseAsDefaultProfile;
    private Button btnCreateProfile;
    private Button btnDeleteProfile;
    private TabFolder folder;
    private Button btnShowIds;
    private ModelEnablementTreeViewer bpmnTreeViewer;
    private Tree bpmnTree;
    private ModelEnablementTreeViewer extensionTreeViewer;
    private Tree extensionTree;
    private TreeViewer paletteTreeViewer;
    private Tree paletteTree;
    private Button btnAddDrawer;
    private Button btnDeleteDrawer;
    private Button btnAddTool;
    private Button btnDeleteTool;
    private Button btnEditTool;
    private static ToolPaletteDescriptor defaultToolPalette = null;
    private Hashtable<TargetRuntime, Hashtable<ModelUtil.Bpmn2DiagramType, Hashtable<String, ToolProfilesPreferencesHelper>>> helpers = new Hashtable();

    public ToolProfilesPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        this.preferences = Bpmn2Preferences.getInstance();
        ToolProfilesPreferencesHelper.setEnableIdAttribute((boolean)this.preferences.getShowIdAttribute());
    }

    private ToolProfilesPreferencesHelper getHelper(TargetRuntime rt, ModelUtil.Bpmn2DiagramType diagramType, String profile) {
        ToolProfilesPreferencesHelper helper;
        Hashtable<String, Object> map2;
        Hashtable<Object, Hashtable<String, Object>> map1 = this.helpers.get(rt);
        if (map1 == null) {
            map1 = new Hashtable();
            this.helpers.put(rt, map1);
        }
        if ((map2 = map1.get(diagramType)) == null) {
            map2 = new Hashtable();
            map1.put(diagramType, map2);
        }
        if ((helper = map2.get(profile)) == null) {
            helper = new ToolProfilesPreferencesHelper(rt, diagramType, profile);
            ModelEnablements me = this.preferences.getModelEnablements(rt, diagramType, profile);
            helper.setModelEnablements(me);
            map2.put(profile, helper);
        } else {
            ToolProfilesPreferencesHelper.setEnableIdAttribute((boolean)this.btnShowIds.getSelection());
            ModelEnablements me = helper.getModelEnablements();
            if (me == null) {
                me = this.preferences.getModelEnablements(rt, diagramType, profile);
            }
            helper.setModelEnablements(me);
        }
        return helper;
    }

    private boolean hasHelper(TargetRuntime rt, ModelUtil.Bpmn2DiagramType diagramType, String profile) {
        ToolProfilesPreferencesHelper helper;
        Hashtable<String, Object> map2;
        Hashtable<Object, Hashtable<String, Object>> map1 = this.helpers.get(rt);
        if (map1 == null) {
            map1 = new Hashtable();
            this.helpers.put(rt, map1);
        }
        if ((map2 = map1.get(diagramType)) == null) {
            map2 = new Hashtable();
            map1.put(diagramType, map2);
        }
        return (helper = map2.get(profile)) != null;
    }

    public Control createContents(final Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        this.currentRuntime = TargetRuntime.getCurrentRuntime();
        this.currentDiagramType = BPMN2Editor.getActiveEditor() != null ? ModelUtil.getDiagramType((BPMNDiagram)BPMN2Editor.getActiveEditor().getBpmnDiagram()) : ModelUtil.Bpmn2DiagramType.PROCESS;
        this.currentProfile = "";
        Label lblRuntime = new Label(container, 0);
        lblRuntime.setText(Messages.ToolProfilesPreferencePage_TargetRuntime_Label);
        lblRuntime.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.cboRuntimes = new Combo(container, 8);
        this.cboRuntimes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cboRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = ToolProfilesPreferencePage.this.cboRuntimes.getText();
                ToolProfilesPreferencePage.this.currentRuntime = (TargetRuntime)ToolProfilesPreferencePage.this.cboRuntimes.getData(s);
                ToolProfilesPreferencePage.this.fillProfilesCombo();
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        this.fillRuntimesCombo();
        Label lblDiagramType = new Label(container, 0);
        lblDiagramType.setText(Messages.ToolProfilesPreferencePage_DiagramType_Label);
        lblDiagramType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        this.cboDiagramTypes = new Combo(container, 8);
        this.cboDiagramTypes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cboDiagramTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = ToolProfilesPreferencePage.this.cboDiagramTypes.getText();
                ToolProfilesPreferencePage.this.currentDiagramType = (ModelUtil.Bpmn2DiagramType)ToolProfilesPreferencePage.this.cboDiagramTypes.getData(s);
                ToolProfilesPreferencePage.this.fillProfilesCombo();
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        this.fillDiagramTypesCombo();
        Label lblProfile = new Label(container, 0);
        lblProfile.setText(Messages.ToolProfilesPreferencePage_ToolProfile_Label);
        lblProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 3, 1));
        this.cboProfiles = new Combo(container, 8);
        this.cboProfiles.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cboProfiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolProfilesPreferencePage.this.currentProfile = ToolProfilesPreferencePage.this.cboProfiles.getText();
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)new GridLayout(4, false));
        buttonContainer.setLayoutData((Object)new GridData(4, 16384, true, false, 4, 1));
        this.btnUseAsDefaultProfile = new Button(buttonContainer, 32);
        this.btnUseAsDefaultProfile.setText(Messages.ToolProfilesPreferencePage_SetDefaultProfile_Button);
        this.btnUseAsDefaultProfile.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Label lblFiller = new Label(buttonContainer, 0);
        lblFiller.setText("");
        lblFiller.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCreateProfile = new Button(buttonContainer, 8);
        this.btnCreateProfile.setText(Messages.ToolProfilesPreferencePage_NewProfile_Button);
        this.btnCreateProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnCreateProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog dlg = new CreateProfileDialog(parent.getShell());
                if (dlg.open() == 0) {
                    ToolProfilesPreferencePage.this.currentProfile = dlg.getValue();
                    ToolProfilesPreferencePage.this.preferences.createToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                    ToolProfilesPreferencePage.this.preferences.setDefaultToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                    if (dlg.getCopyProfile() != null) {
                        ModelUtil.Bpmn2DiagramType saveDiagramType = ToolProfilesPreferencePage.this.currentDiagramType;
                        ToolProfilesPreferencePage.this.currentDiagramType = dlg.getCopyDiagramType();
                        ToolProfilesPreferencePage.this.currentProfile = dlg.getCopyProfile();
                        ToolProfilesPreferencesHelper helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                        ModelEnablements copyMe = helper.getModelEnablements();
                        ToolProfilesPreferencePage.this.currentProfile = dlg.getValue();
                        ToolProfilesPreferencePage.this.currentDiagramType = saveDiagramType;
                        helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                        helper.copyModelEnablements(copyMe);
                        ToolProfilesPreferencePage.this.preferences.setModelEnablements(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile, helper.getModelEnablements());
                    }
                    ToolProfilesPreferencePage.this.currentProfile = dlg.getValue();
                    ToolProfilesPreferencePage.this.fillProfilesCombo();
                    ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                    ToolProfilesPreferencePage.this.fillPaletteTree();
                }
            }
        });
        this.btnDeleteProfile = new Button(buttonContainer, 8);
        this.btnDeleteProfile.setText(Messages.ToolProfilesPreferencePage_DeleteProfile_Button);
        this.btnDeleteProfile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnDeleteProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)ToolProfilesPreferencePage.this.getShell(), (String)Messages.ToolProfilesPreferencePage_DeleteProfile_Title, (String)Messages.ToolProfilesPreferencePage_DeleteProfile_Message)) {
                    ToolProfilesPreferencePage.this.preferences.deleteToolProfile(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                    ToolProfilesPreferencePage.this.fillProfilesCombo();
                    ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                    ToolProfilesPreferencePage.this.fillPaletteTree();
                }
            }
        });
        this.fillProfilesCombo();
        this.folder = new TabFolder(container, 0);
        this.folder.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.folder.setLayout((Layout)layout);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        TabItem elementsTab = new TabItem(this.folder, 0);
        elementsTab.setText(Messages.ToolProfilesPreferencePage_EnabledElements_Tab);
        TabItem paletteTab = new TabItem(this.folder, 0);
        paletteTab.setText(Messages.ToolProfilesPreferencePage_ToolPalette_Tab);
        Composite elementsContainer = new Composite((Composite)this.folder, 0);
        elementsContainer.setLayout((Layout)new GridLayout(2, false));
        elementsContainer.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.btnShowIds = new Button(elementsContainer, 32);
        this.btnShowIds.setText(Messages.ToolProfilesPreferencePage_ShowID_Button);
        this.btnShowIds.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowIds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolProfilesPreferencesHelper.setEnableIdAttribute((boolean)ToolProfilesPreferencePage.this.btnShowIds.getSelection());
                ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                ToolProfilesPreferencePage.this.fillPaletteTree();
            }
        });
        this.btnShowIds.setSelection(this.preferences.getShowIdAttribute());
        ICheckStateListener checkStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Object element = event.getElement();
                if (element instanceof ModelEnablementTreeEntry) {
                    ModelEnablementTreeEntry entry = (ModelEnablementTreeEntry)element;
                    ToolProfilesPreferencesHelper helper = ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile);
                    helper.setEnabled(entry, checked);
                }
            }
        };
        this.bpmnTreeViewer = new ModelEnablementTreeViewer(elementsContainer, Messages.ToolProfilePreferencePage_Standard_Elements_Label);
        this.bpmnTree = this.bpmnTreeViewer.getTree();
        this.bpmnTreeViewer.addCheckStateListener(checkStateListener);
        this.extensionTreeViewer = new ModelEnablementTreeViewer(elementsContainer, Messages.ToolProfilePreferencePage_Extension_Elements_Label);
        this.extensionTree = this.extensionTreeViewer.getTree();
        this.extensionTreeViewer.addCheckStateListener(checkStateListener);
        Composite paletteContainer = new Composite((Composite)this.folder, 0);
        paletteContainer.setLayout((Layout)new GridLayout(2, false));
        paletteContainer.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.paletteTreeViewer = new TreeViewer(paletteContainer, 2048);
        this.paletteTree = this.paletteTreeViewer.getTree();
        this.paletteTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite paletteButtonsContainer = new Composite(paletteContainer, 0);
        paletteButtonsContainer.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(131072, 128, false, false, 1, 1);
        data.exclude = true;
        paletteButtonsContainer.setLayoutData((Object)data);
        paletteButtonsContainer.setVisible(false);
        this.btnAddDrawer = new Button(paletteButtonsContainer, 8);
        this.btnAddDrawer.setText(Messages.ToolProfilesPreferencePage_AddDrawer_Button);
        this.btnAddDrawer.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAddDrawer.setEnabled(false);
        this.btnDeleteDrawer = new Button(paletteButtonsContainer, 8);
        this.btnDeleteDrawer.setText(Messages.ToolProfilesPreferencePage_DeleteDrawer_Button);
        this.btnDeleteDrawer.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnDeleteDrawer.setEnabled(false);
        this.btnAddTool = new Button(paletteButtonsContainer, 8);
        this.btnAddTool.setText(Messages.ToolProfilesPreferencePage_AddTool_Button);
        this.btnAddTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnAddTool.setEnabled(false);
        this.btnDeleteTool = new Button(paletteButtonsContainer, 8);
        this.btnDeleteTool.setText(Messages.ToolProfilesPreferencePage_DeleteTool_Button);
        this.btnDeleteTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnDeleteTool.setEnabled(false);
        this.btnEditTool = new Button(paletteButtonsContainer, 8);
        this.btnEditTool.setText(Messages.ToolProfilesPreferencePage_EditTool_Button);
        this.btnEditTool.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnEditTool.setEnabled(false);
        elementsTab.setControl((Control)elementsContainer);
        elementsContainer.setBackground(parent.getBackground());
        paletteTab.setControl((Control)paletteContainer);
        paletteContainer.setBackground(parent.getBackground());
        Composite importExportButtons = new Composite(container, 0);
        importExportButtons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 4, 1));
        importExportButtons.setLayout((Layout)new FillLayout());
        Button btnImportProfile = new Button(importExportButtons, 0);
        btnImportProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    try {
                        ToolProfilesPreferencePage.this.bpmnEntries.clear();
                        ToolProfilesPreferencePage.this.extensionEntries.clear();
                        ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile).importProfile(path);
                        ToolProfilesPreferencePage.this.fillModelEnablementTrees();
                        ToolProfilesPreferencePage.this.fillPaletteTree();
                    }
                    catch (Exception e1) {
                        Activator.showErrorWithLogging(e1);
                    }
                }
            }
        });
        btnImportProfile.setText(Messages.ToolProfilePreferencePage_Import);
        Button btnExportProfile = new Button(importExportButtons, 0);
        btnExportProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 8192);
                String path = dialog.open();
                if (path != null) {
                    try {
                        ToolProfilesPreferencePage.this.getHelper(ToolProfilesPreferencePage.this.currentRuntime, ToolProfilesPreferencePage.this.currentDiagramType, ToolProfilesPreferencePage.this.currentProfile).exportProfile(path);
                    }
                    catch (Exception e1) {
                        Activator.showErrorWithLogging(e1);
                    }
                }
            }
        });
        btnExportProfile.setText(Messages.ToolProfilePreferencePage_Export);
        this.fillModelEnablementTrees();
        this.fillPaletteTree();
        this.bpmnTree.setEnabled(true);
        this.extensionTree.setEnabled(true);
        return container;
    }

    private void fillRuntimesCombo() {
        int i = 0;
        TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
        int n = targetRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetRuntime r = targetRuntimeArray[n2];
            this.cboRuntimes.add(r.getName());
            this.cboRuntimes.setData(r.getName(), (Object)r);
            if (r == this.currentRuntime) {
                this.cboRuntimes.select(i);
            }
            ++i;
            ++n2;
        }
    }

    private void fillDiagramTypesCombo() {
        int i = 0;
        ModelUtil.Bpmn2DiagramType[] bpmn2DiagramTypeArray = ModelUtil.Bpmn2DiagramType.values();
        int n = bpmn2DiagramTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelUtil.Bpmn2DiagramType t = bpmn2DiagramTypeArray[n2];
            this.cboDiagramTypes.add(t.toString());
            this.cboDiagramTypes.setData(t.toString(), (Object)t);
            if (t == this.currentDiagramType) {
                this.cboDiagramTypes.select(i);
            }
            ++i;
            ++n2;
        }
    }

    private void fillProfilesCombo() {
        if (this.cboProfiles != null) {
            int i = 0;
            int iSelected = -1;
            this.currentProfile = this.preferences.getDefaultToolProfile(this.currentRuntime, this.currentDiagramType);
            this.cboProfiles.removeAll();
            String[] stringArray = this.preferences.getAllToolProfiles(this.currentRuntime, this.currentDiagramType);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String profile = stringArray[n2];
                String text = profile;
                if (text == null || text.isEmpty()) {
                    text = String.valueOf(Messages.ToolProfilePreferencePage_Unnamed) + (i + 1);
                }
                this.cboProfiles.add(text);
                if (iSelected < 0 && this.currentProfile != null && this.currentProfile.equals(profile)) {
                    iSelected = i;
                    this.cboProfiles.select(iSelected);
                }
                ++i;
                ++n2;
            }
            if (this.btnDeleteProfile != null) {
                this.btnDeleteProfile.setEnabled(this.cboProfiles.getItemCount() > 0);
            }
        }
    }

    private void fillModelEnablementTrees() {
        this.loadModelEnablements();
        this.bpmnTreeViewer.setInput(this.bpmnEntries);
        this.extensionTreeViewer.setInput(this.extensionEntries);
        if ("org.eclipse.bpmn2.modeler.runtime.none".equals(this.currentRuntime.getId())) {
            this.extensionTreeViewer.setVisible(false);
        } else {
            this.extensionTreeViewer.setVisible(true);
        }
    }

    private boolean isEnabled(ToolPaletteDescriptor.ToolDescriptor td) {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentDiagramType, this.currentProfile);
        for (ToolPaletteDescriptor.ToolPart tp : td.getToolParts()) {
            if (this.isEnabled(helper, tp)) continue;
            return false;
        }
        return true;
    }

    private boolean isEnabled(ToolPaletteDescriptor.ToolPart tp) {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentDiagramType, this.currentProfile);
        return this.isEnabled(helper, tp);
    }

    private boolean isEnabled(ToolProfilesPreferencesHelper helper, ToolPaletteDescriptor.ToolPart tp) {
        String name = tp.getName();
        if (name != null && !name.isEmpty() && !helper.isEnabled(name)) {
            return false;
        }
        for (ToolPaletteDescriptor.ToolPart child : tp.getChildren()) {
            if (this.isEnabled(helper, child)) continue;
            return false;
        }
        return true;
    }

    private void fillPaletteTree() {
        if (this.paletteTreeViewer == null) {
            return;
        }
        this.loadPalette();
        ToolPaletteDescriptor toolPaletteDescriptor = this.currentRuntime.getToolPalette(this.currentDiagramType, this.currentProfile);
        if (toolPaletteDescriptor == null) {
            toolPaletteDescriptor = defaultToolPalette;
        }
        if (this.paletteTreeViewer.getContentProvider() == null) {
            this.paletteTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element) != null;
                }

                public Object getParent(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        return null;
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        return ((ToolPaletteDescriptor.CategoryDescriptor)element).getParent();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        return ((ToolPaletteDescriptor.ToolDescriptor)element).getParent();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolPart) {
                        return ((ToolPaletteDescriptor.ToolPart)element).getParent();
                    }
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public Object[] getChildren(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        ArrayList<ToolPaletteDescriptor.CategoryDescriptor> kids = new ArrayList<ToolPaletteDescriptor.CategoryDescriptor>();
                        for (ToolPaletteDescriptor.CategoryDescriptor cd : ((ToolPaletteDescriptor)element).getCategories()) {
                            if (cd.getName() == null && "org.bpmn2.modeler.toolpalette.default.categories".equals(cd.getId())) {
                                kids.addAll(defaultToolPalette.getCategories());
                                continue;
                            }
                            if (cd.getFromPalette() != null) {
                                TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
                                int n = targetRuntimeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TargetRuntime rt = targetRuntimeArray[n2];
                                    block2: for (ToolPaletteDescriptor td : rt.getToolPalettes()) {
                                        if (!cd.getFromPalette().equals(td.getId())) continue;
                                        for (ToolPaletteDescriptor.CategoryDescriptor cd2 : td.getCategories()) {
                                            if (!cd.getId().equals(cd2.getId())) continue;
                                            kids.add(cd2);
                                            continue block2;
                                        }
                                    }
                                    ++n2;
                                }
                                continue;
                            }
                            kids.add(cd);
                        }
                        return kids.toArray();
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        return ((ToolPaletteDescriptor.CategoryDescriptor)element).getTools().toArray();
                    }
                    return null;
                }
            });
            this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public Image getImage(Object element) {
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        ToolPaletteDescriptor.CategoryDescriptor cd = (ToolPaletteDescriptor.CategoryDescriptor)element;
                        int enabled = 0;
                        for (ToolPaletteDescriptor.ToolDescriptor td : cd.getTools()) {
                            if (!ToolProfilesPreferencePage.this.isEnabled(td)) continue;
                            ++enabled;
                        }
                        if (enabled == 0) {
                            return Activator.getDefault().getImage("16/folder_disabled.png");
                        }
                        return Activator.getDefault().getImage("16/folder.png");
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        ToolPaletteDescriptor.ToolDescriptor td = (ToolPaletteDescriptor.ToolDescriptor)element;
                        if (!ToolProfilesPreferencePage.this.isEnabled(td)) {
                            return Activator.getDefault().getImage("16/disabled.png");
                        }
                        List tps = td.getToolParts();
                        if (!tps.isEmpty()) {
                            if (tps.size() > 2) {
                                return Activator.getDefault().getImage("16/Process.png");
                            }
                            ToolPaletteDescriptor.ToolPart tp = (ToolPaletteDescriptor.ToolPart)tps.get(0);
                            String name = "16/" + tp.getName() + ".png";
                            if (!tp.getChildren().isEmpty()) {
                                name = "16/" + ((ToolPaletteDescriptor.ToolPart)tp.getChildren().get(0)).getName() + ".png";
                            }
                            return Activator.getDefault().getImage(name);
                        }
                    } else {
                        boolean cfr_ignored_0 = element instanceof ToolPaletteDescriptor.ToolPart;
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof ToolPaletteDescriptor) {
                        return (String)((ToolPaletteDescriptor)element).getProfiles().get(0);
                    }
                    if (element instanceof ToolPaletteDescriptor.CategoryDescriptor) {
                        ToolPaletteDescriptor.CategoryDescriptor cd = (ToolPaletteDescriptor.CategoryDescriptor)element;
                        if (cd.getFromPalette() != null) {
                            return cd.getFromPalette();
                        }
                        if (cd.getName() == null) {
                            return cd.getId();
                        }
                        return cd.getName();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolDescriptor) {
                        return ((ToolPaletteDescriptor.ToolDescriptor)element).getName();
                    }
                    if (element instanceof ToolPaletteDescriptor.ToolPart) {
                        ToolPaletteDescriptor.ToolPart tp = (ToolPaletteDescriptor.ToolPart)element;
                        String props = "";
                        for (Map.Entry entry : tp.getProperties().entrySet()) {
                            props = props.isEmpty() ? String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() : String.valueOf(props) + "," + (String)entry.getKey() + "=" + (String)entry.getValue();
                        }
                        return String.valueOf(tp.getName()) + "[" + props + "]";
                    }
                    return "";
                }
            });
        }
        this.paletteTreeViewer.setInput((Object)toolPaletteDescriptor);
    }

    protected void performDefaults() {
        super.performDefaults();
        String path = Bpmn2Preferences.getToolProfilePath((TargetRuntime)this.currentRuntime, (ModelUtil.Bpmn2DiagramType)this.currentDiagramType);
        this.preferences.setToDefault(path);
        path = Bpmn2Preferences.getModelEnablementsPath((TargetRuntime)this.currentRuntime, (ModelUtil.Bpmn2DiagramType)this.currentDiagramType, (String)this.currentProfile);
        this.preferences.setToDefault(path);
        this.fillProfilesCombo();
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentDiagramType, this.currentProfile);
        helper.setModelEnablements(null);
        this.fillModelEnablementTrees();
        this.fillPaletteTree();
    }

    private void loadModelEnablements() {
        ToolProfilesPreferencesHelper helper = this.getHelper(this.currentRuntime, this.currentDiagramType, this.currentProfile);
        this.loadModelEnablements(helper, this.bpmnEntries, null, null);
        ModelEnablementDescriptor med = this.currentRuntime.getModelEnablements(this.currentDiagramType, this.currentProfile);
        if (med != null) {
            this.loadModelEnablements(helper, this.extensionEntries, this.bpmnEntries, med);
        }
    }

    private Object[] loadModelEnablements(ToolProfilesPreferencesHelper helper, List<ModelEnablementTreeEntry> entries, List<ModelEnablementTreeEntry> bpmnEntries, ModelEnablementDescriptor med) {
        entries.clear();
        if (med != null) {
            entries.addAll(helper.getAllExtensionElements(med, bpmnEntries));
        } else {
            entries.addAll(helper.getAllElements());
        }
        ArrayList<ModelEnablementTreeEntry> enabled = new ArrayList<ModelEnablementTreeEntry>();
        for (ModelEnablementTreeEntry entry : entries) {
            if (entry.getEnabled().booleanValue()) {
                enabled.add(entry);
            }
            ArrayList children = entry.getChildren();
            for (ModelEnablementTreeEntry t : children) {
                if (!t.getEnabled().booleanValue()) continue;
                enabled.add(t);
            }
        }
        return enabled.toArray();
    }

    private void loadPalette() {
        if (defaultToolPalette == null) {
            defaultToolPalette = new ToolPaletteDescriptor();
            ToolPaletteDescriptor.CategoryDescriptor cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_Connectors_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.CONNECTORS) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_Tasks_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.TASKS) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_Gateways_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.GATEWAYS) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_Events_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.EVENTS) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_EventDefinitions_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.EVENT_DEFINITIONS) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_DataItems_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.DATA) {
                this.loadCategory(cd, c);
            }
            cd = new ToolPaletteDescriptor.CategoryDescriptor(defaultToolPalette, null, Messages.ToolProfilesPreferencePage_Other_Category, null, null);
            defaultToolPalette.getCategories().add(cd);
            for (Class c : FeatureMap.OTHER) {
                this.loadCategory(cd, c);
            }
        }
    }

    private void loadCategory(ToolPaletteDescriptor.CategoryDescriptor cd, Class c) {
        ToolPaletteDescriptor.ToolDescriptor td = new ToolPaletteDescriptor.ToolDescriptor(cd, null, ModelUtil.toDisplayName((String)c.getSimpleName()), null, null);
        cd.getTools().add(td);
        ToolPaletteDescriptor.ToolPart tp = new ToolPaletteDescriptor.ToolPart(td, c.getSimpleName());
        td.getToolParts().add(tp);
    }

    public boolean performOk() {
        this.setErrorMessage(null);
        try {
            TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
            int n = targetRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetRuntime rt = targetRuntimeArray[n2];
                ModelUtil.Bpmn2DiagramType[] bpmn2DiagramTypeArray = ModelUtil.Bpmn2DiagramType.values();
                int n3 = bpmn2DiagramTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ModelUtil.Bpmn2DiagramType diagramType = bpmn2DiagramTypeArray[n4];
                    String[] stringArray = this.preferences.getAllToolProfiles(rt, diagramType);
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String profile = stringArray[n6];
                        if (this.hasHelper(rt, diagramType, profile)) {
                            ToolProfilesPreferencesHelper helper = this.getHelper(rt, diagramType, profile);
                            this.preferences.setModelEnablements(rt, diagramType, profile, helper.getModelEnablements());
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            this.preferences.setShowIdAttribute(this.btnShowIds.getSelection());
            if (this.btnUseAsDefaultProfile.getSelection()) {
                this.preferences.setDefaultToolProfile(this.currentRuntime, this.currentDiagramType, this.currentProfile);
            }
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Activator.showErrorWithLogging((Exception)((Object)e));
        }
        return true;
    }

    public boolean getShowIdAttribute() {
        if (this.btnShowIds != null) {
            return this.btnShowIds.getSelection();
        }
        return this.preferences.getShowIdAttribute();
    }

    public void setVisible(boolean visible) {
        Bpmn2EditorBehaviorPreferencePage page;
        super.setVisible(visible);
        if (visible && this.btnShowIds != null && (page = (Bpmn2EditorBehaviorPreferencePage)Bpmn2HomePreferencePage.getPage(this.getContainer(), Bpmn2EditorBehaviorPreferencePage.PAGE_ID)) != null) {
            this.btnShowIds.setSelection(page.getShowIdAttribute());
        }
    }

    private class CreateProfileDialog
    extends InputDialog {
        private String copySelection;

        public CreateProfileDialog(Shell parentShell) {
            super(parentShell, Messages.ToolProfilesPreferencePage_CreateProfile_Title, NLS.bind((String)Messages.ToolProfilesPreferencePage_CreateProfile_Message, (Object)ToolProfilesPreferencePage.this.currentRuntime.getName()), "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.ToolProfilesPreferencePage_Profile_Empty;
                    }
                    String[] stringArray = ToolProfilesPreferencePage.this.cboProfiles.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        if (newText.equals(p)) {
                            return NLS.bind((String)Messages.ToolProfilesPreferencePage_Profile_Duplicate, (Object)p);
                        }
                        ++n2;
                    }
                    return null;
                }
            });
            this.copySelection = null;
        }

        public String getCopyProfile() {
            if (this.copySelection != null && this.copySelection.contains("/")) {
                int i = this.copySelection.indexOf("/");
                return this.copySelection.substring(i + 1);
            }
            return null;
        }

        public ModelUtil.Bpmn2DiagramType getCopyDiagramType() {
            if (this.copySelection != null && this.copySelection.contains("/")) {
                int i = this.copySelection.indexOf("/");
                String s = this.copySelection.substring(0, i);
                return ModelUtil.Bpmn2DiagramType.fromString((String)s);
            }
            return null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(composite, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            final Button btnCopy = new Button(container, 32);
            btnCopy.setText(Messages.ToolProfilesPreferencePage_CopyProfile_Button);
            btnCopy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            final Combo cboCopy = new Combo(container, 8);
            cboCopy.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            cboCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreateProfileDialog.this.copySelection = cboCopy.getText();
                }
            });
            ModelUtil.Bpmn2DiagramType[] bpmn2DiagramTypeArray = ModelUtil.Bpmn2DiagramType.values();
            int n = bpmn2DiagramTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelUtil.Bpmn2DiagramType diagramType = bpmn2DiagramTypeArray[n2];
                String[] stringArray = ToolProfilesPreferencePage.this.preferences.getAllToolProfiles(ToolProfilesPreferencePage.this.currentRuntime, diagramType);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String profile = stringArray[n4];
                    String key = diagramType + "/" + profile;
                    cboCopy.add(key);
                    ++n4;
                }
                ++n2;
            }
            cboCopy.setEnabled(false);
            btnCopy.setEnabled(cboCopy.getItemCount() > 0);
            btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    cboCopy.setEnabled(btnCopy.getSelection());
                    if (!btnCopy.getSelection()) {
                        CreateProfileDialog.this.copySelection = null;
                    }
                }
            });
            return composite;
        }
    }
}

