/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.ui.FeatureMap;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class Bpmn2EditorAppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Bpmn2Preferences preferences;
    TreeViewer elementsTreeViewer;
    List<Class> allElements;
    Composite styleEditors;
    Composite container;
    ShapeStyleList allShapeStyles;
    ShapeStyleCategoryList categories;
    Class currentSelection;
    ColorControl shapeBackground;
    ColorControl shapePrimarySelectedColor;
    ColorControl shapeSecondarySelectedColor;
    ColorControl shapeForeground;
    Button defaultSize;
    FontControl textFont;
    ColorControl textColor;
    Label routingStyleLabel;
    Combo routingStyle;

    public Bpmn2EditorAppearancePreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.preferences = Bpmn2Preferences.getInstance();
    }

    public void init(IWorkbench workbench) {
        this.allElements = new ArrayList<Class>();
        this.allElements.addAll(FeatureMap.CONNECTORS);
        this.allElements.addAll(FeatureMap.EVENTS);
        this.allElements.addAll(FeatureMap.GATEWAYS);
        this.allElements.addAll(FeatureMap.TASKS);
        this.allElements.addAll(FeatureMap.DATA);
        this.allElements.addAll(FeatureMap.OTHER);
        Collections.sort(this.allElements, new Comparator<Class>(){

            @Override
            public int compare(Class arg0, Class arg1) {
                return arg0.getSimpleName().compareTo(arg1.getSimpleName());
            }
        });
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(2, false));
        final Group elementsGroup = new Group(this.container, 0);
        elementsGroup.setText(Messages.Bpmn2EditorAppearancePreferencePage_GraphicalElements_Group);
        GridData data = new GridData(4, 128, true, true, 1, 1);
        data.heightHint = 50;
        elementsGroup.setLayoutData((Object)data);
        elementsGroup.setLayout((Layout)new GridLayout(1, false));
        this.elementsTreeViewer = new TreeViewer((Composite)elementsGroup, 2816);
        Tree elementsTree = this.elementsTreeViewer.getTree();
        data = new GridData(4, 128, true, true, 1, 1);
        data.heightHint = 50;
        elementsTree.setLayoutData((Object)data);
        this.elementsTreeViewer.setContentProvider((IContentProvider)new BEListContentProvider());
        this.elementsTreeViewer.setLabelProvider((IBaseLabelProvider)new BEListLabelProvider());
        this.elementsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new BEListSelectionChangedListener());
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData gd = (GridData)elementsGroup.getLayoutData();
                gd.heightHint = 1000;
                gd = (GridData)Bpmn2EditorAppearancePreferencePage.this.elementsTreeViewer.getTree().getLayoutData();
                gd.heightHint = 1000;
                Bpmn2EditorAppearancePreferencePage.this.container.layout();
            }
        });
        Group styleGroup = new Group(this.container, 0);
        styleGroup.setText(Messages.Bpmn2EditorAppearancePreferencePage_Colors_Group);
        styleGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        styleGroup.setLayout((Layout)new GridLayout(1, false));
        this.styleEditors = new Composite((Composite)styleGroup, 0);
        this.styleEditors.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        this.styleEditors.setLayout((Layout)layout);
        this.styleEditors.setFont(parent.getFont());
        this.styleEditors.setVisible(false);
        this.shapeBackground = new ColorControl(Messages.Bpmn2EditorPreferencePage_Fill_Color_Label, this.styleEditors);
        this.shapeBackground.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShapeStyle ss = (ShapeStyle)Bpmn2EditorAppearancePreferencePage.this.allShapeStyles.get(Bpmn2EditorAppearancePreferencePage.this.currentSelection);
                IColorConstant c = Bpmn2EditorAppearancePreferencePage.this.shapeBackground.getSelectedColor();
                if (!ShapeStyle.compare((IColorConstant)ss.getShapeBackground(), (IColorConstant)c)) {
                    ss.setDefaultColors(c);
                    Bpmn2EditorAppearancePreferencePage.this.shapePrimarySelectedColor.setSelectedColor(ss.getShapePrimarySelectedColor());
                    Bpmn2EditorAppearancePreferencePage.this.shapeSecondarySelectedColor.setSelectedColor(ss.getShapeSecondarySelectedColor());
                    Bpmn2EditorAppearancePreferencePage.this.shapeForeground.setSelectedColor(ss.getShapeForeground());
                    Bpmn2EditorAppearancePreferencePage.this.textColor.setSelectedColor(ss.getTextColor());
                }
            }
        });
        this.shapeForeground = new ColorControl(Messages.Bpmn2EditorPreferencePage_Foreground_Color_Label, this.styleEditors);
        this.shapePrimarySelectedColor = new ColorControl(Messages.Bpmn2EditorPreferencePage_Selected_Color_Label, this.styleEditors);
        this.shapeSecondarySelectedColor = new ColorControl(Messages.Bpmn2EditorPreferencePage_MultiSelected_Color_Label, this.styleEditors);
        this.textColor = new ColorControl(Messages.Bpmn2EditorPreferencePage_Label_Color_Label, this.styleEditors);
        this.textFont = new FontControl(Messages.Bpmn2EditorPreferencePage_Label_Font_Label, this.styleEditors);
        this.defaultSize = new Button(this.styleEditors, 32);
        this.defaultSize.setText(Messages.Bpmn2EditorPreferencePage_Override_Size_Label);
        GridData gd = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd.horizontalIndent = 5;
        gd.verticalIndent = 10;
        this.defaultSize.setLayoutData((Object)gd);
        Composite routingStyleComposite = new Composite(this.styleEditors, 0);
        routingStyleComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        layout = new GridLayout(2, false);
        routingStyleComposite.setLayout((Layout)layout);
        this.routingStyleLabel = new Label(routingStyleComposite, 16384);
        this.routingStyleLabel.setText(Messages.Bpmn2EditorPreferencePage_Routing_Style_Label);
        this.routingStyleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.routingStyle = new Combo(routingStyleComposite, 8);
        this.routingStyle.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.loadStyleEditors();
        return this.container;
    }

    private void saveStyleEditors() {
        if (this.currentSelection != null) {
            ShapeStyle ss = (ShapeStyle)this.allShapeStyles.get(this.currentSelection);
            ss.setShapeBackground(this.shapeBackground.getSelectedColor());
            ss.setShapePrimarySelectedColor(this.shapePrimarySelectedColor.getSelectedColor());
            ss.setShapeSecondarySelectedColor(this.shapeSecondarySelectedColor.getSelectedColor());
            ss.setShapeForeground(this.shapeForeground.getSelectedColor());
            ss.setDefaultSize(this.defaultSize.getSelection());
            ss.setTextFont(this.textFont.getSelectedFont());
            ss.setTextColor(this.textColor.getSelectedColor());
            ShapeStyle.RoutingStyle rs = ss.getRoutingStyle();
            int i = this.routingStyle.getSelectionIndex();
            if (i >= 0) {
                rs = ShapeStyle.RoutingStyle.values()[i];
            }
            ss.setRoutingStyle(rs);
        }
    }

    private void loadStyleEditors() {
        if (this.allShapeStyles == null) {
            this.categories = new ShapeStyleCategoryList();
            ShapeStyleList connectorShapeStyles = new ShapeStyleList();
            ShapeStyleList eventShapeStyles = new ShapeStyleList();
            ShapeStyleList gatewayShapeStyles = new ShapeStyleList();
            ShapeStyleList taskShapeStyles = new ShapeStyleList();
            ShapeStyleList dataShapeStyles = new ShapeStyleList();
            ShapeStyleList otherShapeStyles = new ShapeStyleList();
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Connections, connectorShapeStyles);
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Events, eventShapeStyles);
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Gateways, gatewayShapeStyles);
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Activities, taskShapeStyles);
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Data_Elements, dataShapeStyles);
            this.categories.put(Messages.Bpmn2EditorPreferencePage_Containers, otherShapeStyles);
            this.allShapeStyles = new ShapeStyleList();
            for (Class c : this.allElements) {
                ShapeStyle ss = this.preferences.getShapeStyle(c);
                this.allShapeStyles.put(c, ss);
                if (FeatureMap.CONNECTORS.contains(c)) {
                    connectorShapeStyles.put(c, ss);
                }
                if (FeatureMap.EVENTS.contains(c)) {
                    eventShapeStyles.put(c, ss);
                }
                if (FeatureMap.GATEWAYS.contains(c)) {
                    gatewayShapeStyles.put(c, ss);
                }
                if (FeatureMap.TASKS.contains(c)) {
                    taskShapeStyles.put(c, ss);
                }
                if (FeatureMap.DATA.contains(c)) {
                    dataShapeStyles.put(c, ss);
                }
                if (FeatureMap.OTHER.contains(c)) {
                    otherShapeStyles.put(c, ss);
                }
                if (!Activator.getDefault().isDebugging()) continue;
                IColorConstant foreground = ss.getShapeForeground();
                IColorConstant background = ss.getShapeBackground();
                IColorConstant textColor = ss.getTextColor();
                Font font = ss.getTextFont();
                System.out.println("\t\t<style object=\"" + c.getSimpleName() + "\"" + " foreground=\"" + ShapeStyle.colorToString((IColorConstant)foreground) + "\"" + " background=\"" + ShapeStyle.colorToString((IColorConstant)background) + "\"" + " textColor=\"" + ShapeStyle.colorToString((IColorConstant)textColor) + "\"" + " font=\"" + ShapeStyle.fontToString((Font)font) + "\"/>");
            }
            this.currentSelection = null;
            this.elementsTreeViewer.setInput((Object)this.categories);
            this.elementsTreeViewer.setSelection(null);
        }
        if (this.currentSelection instanceof Class) {
            Class c = this.currentSelection;
            ShapeStyle ss = (ShapeStyle)this.allShapeStyles.get(c);
            this.shapeBackground.setSelectedColor(ss.getShapeBackground());
            this.shapePrimarySelectedColor.setSelectedColor(ss.getShapePrimarySelectedColor());
            this.shapeSecondarySelectedColor.setSelectedColor(ss.getShapeSecondarySelectedColor());
            this.shapeForeground.setSelectedColor(ss.getShapeForeground());
            this.defaultSize.setSelection(ss.isDefaultSize());
            this.textFont.setSelectedFont(ss.getTextFont());
            this.textColor.setSelectedColor(ss.getTextColor());
            boolean isShape = true;
            if (FeatureMap.CONNECTORS.contains(c)) {
                isShape = false;
            }
            this.shapeBackground.setVisible(isShape);
            ((GridData)this.shapeBackground.getLayoutData()).exclude = !isShape;
            this.shapePrimarySelectedColor.setVisible(isShape);
            ((GridData)this.shapePrimarySelectedColor.getLayoutData()).exclude = !isShape;
            this.shapeSecondarySelectedColor.setVisible(isShape);
            ((GridData)this.shapeSecondarySelectedColor.getLayoutData()).exclude = !isShape;
            this.defaultSize.setVisible(isShape);
            ((GridData)this.defaultSize.getLayoutData()).exclude = !isShape;
            this.routingStyle.setVisible(!isShape);
            ((GridData)this.routingStyle.getLayoutData()).exclude = isShape;
            this.routingStyleLabel.setVisible(!isShape);
            ((GridData)this.routingStyleLabel.getLayoutData()).exclude = isShape;
            if (!isShape) {
                this.routingStyle.removeAll();
                int i = 0;
                ShapeStyle.RoutingStyle[] routingStyleArray = ShapeStyle.RoutingStyle.values();
                int n = routingStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ShapeStyle.RoutingStyle rs = routingStyleArray[n2];
                    this.routingStyle.add(rs.name());
                    if (ss.getRoutingStyle() == rs) {
                        this.routingStyle.select(i);
                    }
                    ++i;
                    ++n2;
                }
            }
            this.container.layout();
        }
    }

    protected void performDefaults() {
        try {
            this.preferences.setToDefault("shape.style");
            this.allShapeStyles = null;
            this.loadStyleEditors();
            this.preferences.flush();
        }
        catch (Exception exception) {}
        super.performDefaults();
    }

    public boolean performOk() {
        this.saveStyleEditors();
        for (Map.Entry entry : this.allShapeStyles.entrySet()) {
            this.preferences.setShapeStyle((Class)entry.getKey(), (ShapeStyle)entry.getValue());
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return super.performOk();
    }

    public class BEListContentProvider
    implements ITreeContentProvider {
        ShapeStyleCategoryList categories;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ShapeStyleCategoryList) {
                this.categories = (ShapeStyleCategoryList)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)inputElement;
                boolean cfr_ignored_0 = entry.getKey() instanceof String;
            }
            if (inputElement instanceof ShapeStyleCategoryList) {
                ShapeStyleCategoryList categories = (ShapeStyleCategoryList)inputElement;
                return categories.entrySet().toArray();
            }
            if (inputElement instanceof ShapeStyleList) {
                ShapeStyleList shapeStyles = (ShapeStyleList)inputElement;
                return shapeStyles.keySet().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            Map.Entry entry;
            if (parentElement instanceof Map.Entry && (entry = (Map.Entry)parentElement).getKey() instanceof String) {
                String key = (String)entry.getKey();
                return ((ShapeStyleList)this.categories.get(key)).entrySet().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Map.Entry entry;
            return element instanceof Map.Entry && (entry = (Map.Entry)element).getKey() instanceof String;
        }
    }

    public class BEListLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (entry.getKey() instanceof String) {
                    return (String)entry.getKey();
                }
                if (entry.getKey() instanceof Class) {
                    return ((Class)entry.getKey()).getSimpleName();
                }
            }
            return element.toString();
        }
    }

    public class BEListSelectionChangedListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)Bpmn2EditorAppearancePreferencePage.this.elementsTreeViewer.getSelection();
            if (Bpmn2EditorAppearancePreferencePage.this.currentSelection != null) {
                Bpmn2EditorAppearancePreferencePage.this.saveStyleEditors();
            }
            Object element = sel.getFirstElement();
            if (sel != null && element != null) {
                if (element instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)element;
                    if ((element = entry.getKey()) instanceof String) {
                        Bpmn2EditorAppearancePreferencePage.this.styleEditors.setVisible(false);
                        Bpmn2EditorAppearancePreferencePage.this.currentSelection = null;
                    } else if (element instanceof Class) {
                        Bpmn2EditorAppearancePreferencePage.this.styleEditors.setVisible(true);
                        Bpmn2EditorAppearancePreferencePage.this.currentSelection = (Class)element;
                    }
                }
            } else {
                Bpmn2EditorAppearancePreferencePage.this.styleEditors.setVisible(false);
            }
            Bpmn2EditorAppearancePreferencePage.this.loadStyleEditors();
        }
    }

    public class ColorControl
    extends Composite {
        private ColorSelector colorSelector;
        private Label selectorLabel;
        private List<SelectionListener> listeners;

        public ColorControl(String labelText, Composite parent) {
            super(parent, 0);
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(2, false));
            this.selectorLabel = new Label((Composite)this, 16384);
            this.selectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.selectorLabel.setFont(parent.getFont());
            this.selectorLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorControl.this.selectorLabel = null;
                }
            });
            this.selectorLabel.setText(labelText);
            this.colorSelector = new ColorSelector((Composite)this);
            this.colorSelector.getButton().setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
            this.colorSelector.getButton().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ColorControl.this.listeners != null) {
                        for (SelectionListener listener : ColorControl.this.listeners) {
                            listener.widgetSelected(e);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void addSelectionListener(SelectionListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SelectionListener>();
            }
            this.listeners.add(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }

        public IColorConstant getSelectedColor() {
            return ShapeStyle.RGBToColor((RGB)this.colorSelector.getColorValue());
        }

        public void setSelectedColor(IColorConstant c) {
            RGB rgb = ShapeStyle.colorToRGB((IColorConstant)c);
            this.colorSelector.setColorValue(rgb);
        }
    }

    public class FontControl
    extends Composite {
        private Button changeFontButton;
        private FontData[] selectedFont;
        private Label previewLabel;
        private Label selectorLabel;

        public FontControl(String labelText, Composite parent) {
            super(parent, 0);
            this.changeFontButton = null;
            this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
            this.setLayout((Layout)new GridLayout(3, false));
            this.selectorLabel = new Label((Composite)this, 16384);
            this.selectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.selectorLabel.setFont(parent.getFont());
            this.selectorLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontControl.this.selectorLabel = null;
                }
            });
            this.selectorLabel.setText(labelText);
            this.previewLabel = new Label((Composite)this, 16384);
            this.previewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.previewLabel.setFont(parent.getFont());
            this.previewLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontControl.this.previewLabel = null;
                }
            });
            this.changeFontButton = new Button((Composite)this, 8);
            this.changeFontButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.changeFontButton.setText(Messages.Bpmn2EditorPreferencePage_Change_Button);
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(FontControl.this.changeFontButton.getShell());
                    if (FontControl.this.selectedFont != null) {
                        fontDialog.setFontList(FontControl.this.selectedFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = FontControl.this.selectedFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        FontControl.this.setSelectedFont(font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontControl.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(parent.getFont());
        }

        public Font getSelectedFont() {
            if (this.selectedFont != null && this.selectedFont.length > 0) {
                return ShapeStyle.fontDataToFont((FontData)this.selectedFont[0]);
            }
            return null;
        }

        public void setSelectedFont(Font f) {
            this.setSelectedFont(ShapeStyle.fontToFontData((Font)f));
        }

        public void setSelectedFont(FontData fd) {
            FontData[] bestFont = JFaceResources.getFontRegistry().filterData(new FontData[]{fd}, this.previewLabel.getDisplay());
            if (bestFont == null) {
                bestFont = this.getDefaultFontData();
            }
            this.selectedFont = bestFont;
            if (this.previewLabel != null) {
                this.previewLabel.setText(StringConverter.asString((FontData)this.selectedFont[0]));
            }
        }

        private FontData[] getDefaultFontData() {
            return this.previewLabel.getDisplay().getSystemFont().getFontData();
        }
    }

    class ShapeStyleCategoryList
    extends LinkedHashMap<String, ShapeStyleList> {
        ShapeStyleCategoryList() {
        }
    }

    class ShapeStyleList
    extends LinkedHashMap<Class, ShapeStyle> {
        ShapeStyleList() {
        }
    }
}

