/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.participant;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;

public class DeleteParticipantFeature
extends DefaultDeleteBPMNShapeFeature {
    public DeleteParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void delete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof Participant) {
            bo = ((Participant)bo).getProcessRef();
        }
        if (bo instanceof FlowElementsContainer) {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)((BaseElement)bo));
            if (bpmnDiagram != null) {
                DIUtils.deleteDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
            }
            EcoreUtil.delete((EObject)((EObject)bo), (boolean)true);
        }
        super.delete(context);
    }

    public boolean canDelete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (ChoreographyUtil.isChoreographyParticipantBand(pe)) {
            int referenceCount = 0;
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Participant.class);
            Definitions definitions = ModelUtil.getDefinitions((EObject)participant);
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                for (EReference reference : o.eClass().getEAllReferences()) {
                    if (reference.isContainment() || o instanceof DiagramElement) continue;
                    if (reference.isMany()) {
                        List list = (List)o.eGet((EStructuralFeature)reference);
                        for (Object referencedObject : list) {
                            if (referencedObject != participant) continue;
                            ++referenceCount;
                        }
                        continue;
                    }
                    Object referencedObject = o.eGet((EStructuralFeature)reference);
                    if (referencedObject != participant) continue;
                    ++referenceCount;
                }
            }
            return referenceCount <= 1;
        }
        return true;
    }
}

