/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.lane;

import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DeleteLaneFeature
extends AbstractDefaultDeleteFeature {
    public DeleteLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void delete(IDeleteContext context) {
        ContainerShape laneContainerShape = (ContainerShape)context.getPictogramElement();
        ContainerShape parentContainerShape = laneContainerShape.getContainer();
        if (parentContainerShape != null) {
            boolean before = false;
            ContainerShape neighborContainerShape = FeatureSupport.getLaneAfter((ContainerShape)laneContainerShape);
            if (neighborContainerShape == null) {
                neighborContainerShape = FeatureSupport.getLaneBefore((ContainerShape)laneContainerShape);
                if (neighborContainerShape == null) {
                    super.delete(context);
                    return;
                }
                before = true;
            }
            boolean isHorizontal = FeatureSupport.isHorizontal((ContainerShape)laneContainerShape);
            GraphicsAlgorithm ga = laneContainerShape.getGraphicsAlgorithm();
            GraphicsAlgorithm neighborGA = neighborContainerShape.getGraphicsAlgorithm();
            ResizeShapeContext newContext = new ResizeShapeContext((Shape)neighborContainerShape);
            if (!before) {
                Graphiti.getGaService().setLocation(neighborGA, ga.getX(), ga.getY());
            }
            newContext.setLocation(neighborGA.getX(), neighborGA.getY());
            if (isHorizontal) {
                newContext.setHeight(neighborGA.getHeight() + ga.getHeight());
                newContext.setWidth(neighborGA.getWidth());
            } else {
                newContext.setHeight(neighborGA.getHeight());
                newContext.setWidth(neighborGA.getWidth() + ga.getWidth());
            }
            IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
            if (resizeFeature.canResizeShape((IResizeShapeContext)newContext)) {
                super.delete(context);
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
                return;
            }
        }
        super.delete(context);
    }
}

