/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.gateway;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventBasedGatewayType;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.gateway.AbstractCreateGatewayFeature;
import org.eclipse.bpmn2.modeler.core.features.gateway.AddGatewayFeature;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.gateway.AbstractGatewayFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.gateway.Messages;
import org.eclipse.bpmn2.modeler.ui.features.gateway.UpdateEventBasedGatewayFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class EventBasedGatewayFeatureContainer
extends AbstractGatewayFeatureContainer {
    static final String INSTANTIATE_PROPERTY = "instantiate";
    static final String EVENT_GATEWAY_TYPE_PROPERTY = "eventGatewayType";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof EventBasedGateway;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateEventBasedGatewayFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddEventBasedGatewayFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addUpdateFeature(super.getUpdateFeature(fp));
        multiUpdate.addUpdateFeature((IUpdateFeature)new UpdateEventBasedGatewayFeature(fp));
        return multiUpdate;
    }

    public class AddEventBasedGatewayFeature
    extends AddGatewayFeature<EventBasedGateway> {
        public AddEventBasedGatewayFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected void decorateShape(IAddContext context, ContainerShape containerShape, EventBasedGateway businessObject) {
            Ellipse outer = GraphicsUtil.createGatewayOuterCircle((ContainerShape)containerShape);
            GraphicsUtil.createGatewayInnerCircle((Ellipse)outer);
            Polygon pentagon = GraphicsUtil.createGatewayPentagon((ContainerShape)containerShape);
            pentagon.setFilled(Boolean.valueOf(false));
        }

        public PictogramElement add(IAddContext context) {
            PictogramElement element = super.add(context);
            IPeService service = Graphiti.getPeService();
            EventBasedGateway gateway = (EventBasedGateway)this.getBusinessObject(context);
            service.setPropertyValue((PropertyContainer)element, EventBasedGatewayFeatureContainer.INSTANTIATE_PROPERTY, Boolean.toString(gateway.isInstantiate()));
            service.setPropertyValue((PropertyContainer)element, EventBasedGatewayFeatureContainer.EVENT_GATEWAY_TYPE_PROPERTY, EventBasedGatewayType.EXCLUSIVE.getName());
            return element;
        }
    }

    public static class CreateEventBasedGatewayFeature
    extends AbstractCreateGatewayFeature<EventBasedGateway> {
        public CreateEventBasedGatewayFeature(IFeatureProvider fp) {
            super(fp, Messages.EventBasedGatewayFeatureContainer_Name, Messages.EventBasedGatewayFeatureContainer_Description);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_EVENT_BASED_GATEWAY;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getEventBasedGateway();
        }
    }
}

