/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import java.io.IOException;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.event.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateBoundaryEventFeature
extends AbstractBpmn2CreateFeature<BoundaryEvent> {
    public CreateBoundaryEventFeature(IFeatureProvider fp) {
        super(fp, Messages.CreateBoundaryEventFeature_0, String.valueOf(Messages.CreateBoundaryEventFeature_1) + Messages.CreateBoundaryEventFeature_2);
    }

    public boolean canCreate(ICreateContext context) {
        Object o = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (o == null || !(o instanceof Activity)) {
            return false;
        }
        GraphicsAlgorithm ga = context.getTargetContainer().getGraphicsAlgorithm();
        return BoundaryEventPositionHelper.canCreateEventAt((ICreateContext)context, (GraphicsAlgorithm)ga, (int)10);
    }

    public Object[] create(ICreateContext context) {
        BoundaryEvent event = this.createBusinessObject(context);
        PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, event);
        return new Object[]{event, pe};
    }

    public BoundaryEvent createBusinessObject(ICreateContext context) {
        BoundaryEvent event = null;
        try {
            Activity activity = (Activity)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            event = (BoundaryEvent)super.createBusinessObject(context);
            event.setAttachedToRef(activity);
            event.setName("");
            event.setCancelActivity(true);
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            if (bo instanceof FlowNode && !((FlowNode)bo).getLanes().isEmpty()) {
                ((Lane)((FlowNode)bo).getLanes().get(0)).getFlowNodeRefs().add(event);
            }
            if (bo instanceof SubProcess) {
                bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer().eContainer());
            }
            handler.addFlowElement(bo, (FlowElement)event);
            ModelUtil.setID((EObject)event);
        }
        catch (IOException e) {
            Activator.logError((Exception)e);
        }
        return event;
    }

    public String getCreateImageId() {
        return ImageProvider.IMG_16_BOUNDARY_EVENT;
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    public EClass getBusinessObjectClass() {
        return Bpmn2Package.eINSTANCE.getBoundaryEvent();
    }
}

