/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateDataObjectFeature
extends AbstractUpdateFeature {
    public UpdateDataObjectFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object o = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return o instanceof DataObject || o instanceof DataObjectReference;
    }

    public IReason updateNeeded(IUpdateContext context) {
        IPeService peService = Graphiti.getPeService();
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
        DataObject data = null;
        if (bo instanceof DataObject) {
            data = (DataObject)bo;
        } else if (bo instanceof DataObjectReference) {
            data = ((DataObjectReference)bo).getDataObjectRef();
        }
        boolean isCollection = Boolean.parseBoolean(peService.getPropertyValue((PropertyContainer)container, "isCollection"));
        return data.isIsCollection() != isCollection ? Reason.createTrueReason() : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService peService = Graphiti.getPeService();
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)container);
        DataObject data = null;
        if (bo instanceof DataObject) {
            data = (DataObject)bo;
        } else if (bo instanceof DataObjectReference) {
            data = ((DataObjectReference)bo).getDataObjectRef();
        }
        boolean drawCollectionMarker = data.isIsCollection();
        for (Shape shape : peService.getAllContainedShapes(container)) {
            String prop = peService.getPropertyValue((PropertyContainer)shape, "hideable");
            if (prop == null || !new Boolean(prop).booleanValue()) continue;
            Polyline line = (Polyline)shape.getGraphicsAlgorithm();
            line.setLineVisible(Boolean.valueOf(drawCollectionMarker));
        }
        peService.setPropertyValue((PropertyContainer)container, "isCollection", Boolean.toString(data.isIsCollection()));
        if (bo instanceof DataObject) {
            Definitions definitions = ModelUtil.getDefinitions((EObject)data);
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                if (!(o instanceof DataObjectReference)) continue;
                for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(this.getDiagram(), o)) {
                    if (!(pe instanceof ContainerShape)) continue;
                    UpdateContext newContext = new UpdateContext(pe);
                    IUpdateFeature f = this.getFeatureProvider().getUpdateFeature((IUpdateContext)newContext);
                    f.update((IUpdateContext)newContext);
                }
            }
        }
        return true;
    }
}

