/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.data.AbstractCreateRootElementFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.LayoutBaseElementTextFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.ui.features.data.Messages;
import org.eclipse.bpmn2.modeler.ui.features.flow.MessageFlowFeatureContainer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.ITargetConnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MessageFeatureContainer
extends BaseElementFeatureContainer {
    public static final int ENVELOPE_WIDTH = 30;
    public static final int ENVELOPE_HEIGHT = 20;
    public static final String IS_REFERENCE = "is.reference";

    public Object getApplyObject(IContext context) {
        Object object = super.getApplyObject(context);
        if (object instanceof Message && !MessageFeatureContainer.isChoreographyMessage(context) && !MessageFeatureContainer.isMessageFlowMessage(context)) {
            return object;
        }
        return null;
    }

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Message;
    }

    public static boolean isMessageFlowMessage(IContext context) {
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            MessageFlow mf = MessageFlowFeatureContainer.getMessageFlow(pe);
            return mf != null;
        }
        return false;
    }

    public static boolean isChoreographyMessage(IContext context) {
        PictogramElement pe;
        return context instanceof IPictogramElementContext && ChoreographyUtil.isChoreographyMessage(pe = ((IPictogramElementContext)context).getPictogramElement());
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateMessageFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddMessageFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteMessageFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateLabelFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutBaseElementTextFeature(fp){

            @Override
            public int getMinimumWidth() {
                return 30;
            }
        };
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new MoveMessageFeature(fp);
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeShapeFeature(fp){

            public boolean canResizeShape(IResizeShapeContext context) {
                return false;
            }
        };
    }

    public class AddMessageFeature
    extends AbstractBpmn2AddElementFeature<Message> {
        public AddMessageFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext context) {
            return true;
        }

        public PictogramElement add(IAddContext context) {
            IGaService gaService = Graphiti.getGaService();
            IPeService peService = Graphiti.getPeService();
            Message businessObject = (Message)this.getBusinessObject(context);
            ContainerShape containerShape = this.addMessageFlowMessage((ITargetConnectionContext)context);
            if (containerShape != null) {
                return containerShape;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            containerShape = peService.createContainerShape(context.getTargetContainer(), true);
            Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
            gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, context.getX(), context.getY(), width, height);
            GraphicsUtil.Envelope envelope = GraphicsUtil.createEnvelope((GraphicsAlgorithmContainer)invisibleRect, (int)0, (int)0, (int)width, (int)height);
            envelope.rect.setFilled(Boolean.valueOf(true));
            StyleUtil.applyStyle((GraphicsAlgorithm)envelope.rect, (BaseElement)businessObject);
            envelope.line.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
            if (context.getProperty((Object)MessageFeatureContainer.IS_REFERENCE) == null) {
                boolean isImport = context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null;
                this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
            } else {
                this.link((PictogramElement)containerShape, businessObject);
            }
            ((AddContext)context).setWidth(width);
            ((AddContext)context).setHeight(height);
            this.decorateShape(context, containerShape, (BaseElement)businessObject);
            peService.createChopboxAnchor((AnchorContainer)containerShape);
            AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)invisibleRect);
            this.layoutPictogramElement((PictogramElement)containerShape);
            this.prepareAddContext(context, (PictogramElement)containerShape, width, height);
            this.getFeatureProvider().getAddFeature(context).add(context);
            return containerShape;
        }

        private ContainerShape addMessageFlowMessage(ITargetConnectionContext context) {
            Shape messageShape = null;
            Message message = null;
            if (context instanceof IPictogramElementContext) {
                messageShape = (Shape)((IPictogramElementContext)context).getPictogramElement();
                message = (Message)BusinessObjectUtil.getFirstElementOfType((PictogramElement)messageShape, Message.class);
            } else if (context instanceof IAddContext) {
                message = (Message)((IAddContext)context).getNewObject();
            }
            Connection connection = context.getTargetConnection();
            MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
            if (messageFlow != null && messageFlow.getMessageRef() != message) {
                messageFlow.setMessageRef(message);
                UpdateContext uc = new UpdateContext((PictogramElement)connection);
                uc.putProperty((Object)"message.ref", (Object)messageShape);
                IUpdateFeature uf = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uc);
                uf.update((IUpdateContext)uc);
                return MessageFlowFeatureContainer.findMessageShape(connection);
            }
            return null;
        }

        public int getHeight() {
            return 20;
        }

        public int getWidth() {
            return 30;
        }
    }

    public static class CreateMessageFeature
    extends AbstractCreateRootElementFeature<Message> {
        private static ILabelProvider labelProvider = new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (((Message)element).getId() == null) {
                    return ((Message)element).getName();
                }
                return NLS.bind((String)Messages.MessageFeatureContainer_Default_Name, (Object)((Message)element).getName());
            }

            public Image getImage(Object element) {
                return null;
            }
        };

        public CreateMessageFeature(IFeatureProvider fp) {
            super(fp, Messages.MessageFeatureContainer_Name, Messages.MessageFeatureContainer_Description);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_MESSAGE;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getMessage();
        }

        public Message createBusinessObject(ICreateContext context) {
            this.changesDone = true;
            Message message = null;
            message = (Message)Bpmn2ModelerFactory.create(Message.class);
            String oldName = message.getName();
            message.setName(Messages.MessageFeatureContainer_New);
            message.setId(null);
            EObject targetBusinessObject = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            Definitions definitions = ModelUtil.getDefinitions((EObject)targetBusinessObject);
            ArrayList<Message> messageList = new ArrayList<Message>();
            messageList.add(message);
            messageList.addAll(ModelUtil.getAllRootElements((Definitions)definitions, Message.class));
            Message result = message;
            if (messageList.size() > 1) {
                PopupMenu popupMenu = new PopupMenu(messageList, labelProvider);
                this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
                if (this.changesDone) {
                    result = (Message)popupMenu.getResult();
                } else {
                    EcoreUtil.delete((EObject)message);
                    message = null;
                }
            }
            if (this.changesDone) {
                if (result == message) {
                    definitions.getRootElements().add(message);
                    message.setId(null);
                    ModelUtil.setID((EObject)message);
                    message.setName(oldName);
                } else {
                    message = result;
                }
                this.putBusinessObject(context, (BaseElement)message);
            }
            return message;
        }
    }

    public static class DeleteMessageFeature
    extends DefaultDeleteBPMNShapeFeature {
        public DeleteMessageFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected void deleteBusinessObject(Object bo) {
            if (bo instanceof Message) {
                Message message = (Message)bo;
                List list = FeatureSupport.findMessageReferences((Diagram)this.getDiagram(), (Message)message);
                if (list.size() > 0) {
                    return;
                }
            }
            super.deleteBusinessObject(bo);
        }
    }

    public static class MoveMessageFeature
    extends DefaultMoveBPMNShapeFeature {
        public MoveMessageFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected void postMoveShape(IMoveShapeContext context) {
            super.postMoveShape(context);
            Shape messageShape = context.getShape();
            Message message = (Message)BusinessObjectUtil.getFirstElementOfType((PictogramElement)messageShape, Message.class);
            Connection messageFlowConnection = context.getTargetConnection();
            MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)messageFlowConnection, MessageFlow.class);
            if (messageFlow != null && messageFlow.getMessageRef() != message) {
                messageFlow.setMessageRef(message);
                UpdateContext uc = new UpdateContext((PictogramElement)messageFlowConnection);
                uc.putProperty((Object)"message.ref", (Object)messageShape);
                IUpdateFeature uf = this.getFeatureProvider().getUpdateFeature((IUpdateContext)uc);
                uf.update((IUpdateContext)uc);
            }
        }
    }
}

