/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateChoreographyParticipantRefsFeature
extends AbstractUpdateFeature {
    private final IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyParticipantRefsFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
    }

    public IReason updateNeeded(IUpdateContext context) {
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
        if (!ChoreographyUtil.getParticipantRefIds(choreography).equals(this.getParticipantRefIds(context))) {
            return Reason.createTrueReason();
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        List participants = choreography.getParticipantRefs();
        List<ContainerShape> bandContainerShapes = ChoreographyUtil.getParticipantBandContainerShapes((ContainerShape)context.getPictogramElement());
        ChoreographyUtil.updateParticipantReferences(containerShape, bandContainerShapes, participants, this.getFeatureProvider(), this.isShowNames());
        this.peService.setPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.participant.ref.ids", ChoreographyUtil.getParticipantRefIds(choreography));
        ChoreographyUtil.drawMessageLinks(this.getFeatureProvider(), (ContainerShape)context.getPictogramElement());
        return true;
    }

    private String getParticipantRefIds(IUpdateContext context) {
        String property = this.peService.getPropertyValue((PropertyContainer)context.getPictogramElement(), "choreography.activity.participant.ref.ids");
        if (property == null) {
            return new String();
        }
        return property;
    }

    protected boolean isShowNames() {
        return true;
    }
}

