/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeService;

public class UpdateChoreographyMessageFlowFeature
extends AbstractUpdateFeature {
    private final IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyMessageFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyTask.class);
    }

    public IReason updateNeeded(IUpdateContext context) {
        String choreoIds;
        PictogramElement pe = context.getPictogramElement();
        if (this.isLinkedMessage(pe)) {
            Message message = (Message)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Message.class);
            TreeIterator iter = message.eContainer().eAllContents();
            while (iter.hasNext()) {
                EObject eo = (EObject)iter.next();
                if (!(eo instanceof ChoreographyTask)) continue;
                ChoreographyTask choreographyTask = (ChoreographyTask)eo;
                for (MessageFlow mf : choreographyTask.getMessageFlowRef()) {
                    String newLabel;
                    if (mf.getMessageRef() != message) continue;
                    String oldLabel = this.peService.getPropertyValue((PropertyContainer)pe, "choreography.messageName");
                    if (oldLabel == null || oldLabel.isEmpty()) {
                        oldLabel = "";
                    }
                    if ((newLabel = ChoreographyUtil.getMessageFlowName(mf)) == null || newLabel.isEmpty()) {
                        newLabel = "";
                    }
                    if (newLabel.equals(oldLabel)) continue;
                    return Reason.createTrueReason();
                }
            }
            return Reason.createFalseReason();
        }
        if (!BusinessObjectUtil.containsElementOfType((PictogramElement)pe, ChoreographyTask.class)) {
            return Reason.createFalseReason();
        }
        ChoreographyTask choreography = (ChoreographyTask)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, ChoreographyTask.class);
        String ids = this.peService.getPropertyValue((PropertyContainer)pe, "choreography.message.ref.ids");
        if (ids.equals(choreoIds = ChoreographyUtil.getMessageRefIds(choreography))) {
            return Reason.createFalseReason();
        }
        return Reason.createTrueReason();
    }

    private boolean isLinkedMessage(PictogramElement pe) {
        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
        return be instanceof Message && Boolean.parseBoolean(this.peService.getPropertyValue((PropertyContainer)pe, "choreography.messageLink"));
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
        if (be instanceof ChoreographyTask) {
            return this.update((ContainerShape)pe, (ChoreographyTask)be);
        }
        if (this.isLinkedMessage(pe)) {
            ILinkService linkService = Graphiti.getLinkService();
            int result = 0;
            TreeIterator iter = be.eContainer().eAllContents();
            while (iter.hasNext()) {
                EObject eo = (EObject)iter.next();
                if (!(eo instanceof ChoreographyTask)) continue;
                ChoreographyTask choreographyTask = (ChoreographyTask)eo;
                for (MessageFlow mf : choreographyTask.getMessageFlowRef()) {
                    if (mf.getMessageRef() != be) continue;
                    for (PictogramElement cs : linkService.getPictogramElements(diagram, (EObject)choreographyTask)) {
                        if (!(cs instanceof ContainerShape) || !this.update((ContainerShape)cs, choreographyTask)) continue;
                        ++result;
                    }
                }
            }
            return result > 0;
        }
        return false;
    }

    public boolean update(ContainerShape choreographyContainer, ChoreographyTask choreographyTask) {
        ArrayList<InteractionNode> sources = new ArrayList<InteractionNode>();
        for (MessageFlow message : choreographyTask.getMessageFlowRef()) {
            sources.add(message.getSourceRef());
        }
        for (ContainerShape band : ChoreographyUtil.getParticipantBandContainerShapes(choreographyContainer)) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!sources.contains(participant) && bpmnShape.isIsMessageVisible()) {
                bpmnShape.setIsMessageVisible(false);
                this.peService.setPropertyValue((PropertyContainer)choreographyContainer, "choreography.activity.band.message.visible", Boolean.toString(false));
                continue;
            }
            if (!sources.contains(participant) || bpmnShape.isIsMessageVisible()) continue;
            bpmnShape.setIsMessageVisible(true);
            this.peService.setPropertyValue((PropertyContainer)choreographyContainer, "choreography.activity.band.message.visible", Boolean.toString(true));
        }
        ChoreographyUtil.drawMessageLinks(this.getFeatureProvider(), choreographyContainer);
        String choreoIds = ChoreographyUtil.getMessageRefIds(choreographyTask);
        this.peService.setPropertyValue((PropertyContainer)choreographyContainer, "choreography.message.ref.ids", choreoIds);
        return false;
    }
}

