/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateChoreographyMarkerFeature
extends AbstractUpdateFeature {
    private final IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyMarkerFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return BusinessObjectUtil.containsElementOfType((PictogramElement)context.getPictogramElement(), ChoreographyActivity.class);
    }

    public IReason updateNeeded(IUpdateContext context) {
        String property;
        ContainerShape choreographyContainer = (ContainerShape)context.getPictogramElement();
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, ChoreographyActivity.class);
        String loopType = choreography.getLoopType() == null ? "null" : choreography.getLoopType().getName();
        if (!loopType.equals(property = this.peService.getPropertyValue((PropertyContainer)choreographyContainer, "choreography.marker"))) {
            return Reason.createTrueReason();
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        ContainerShape choreographyContainer = (ContainerShape)context.getPictogramElement();
        ChoreographyActivity choreography = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyContainer, ChoreographyActivity.class);
        for (Shape s : this.peService.getAllContainedShapes(choreographyContainer)) {
            String property = this.peService.getPropertyValue((PropertyContainer)s, "choreography.marker.shape");
            if (property == null || !new Boolean(property).booleanValue()) continue;
            ChoreographyUtil.drawChoreographyLoopType((ContainerShape)s, choreography.getLoopType());
        }
        String loopType = choreography.getLoopType() == null ? "null" : choreography.getLoopType().getName();
        this.peService.setPropertyValue((PropertyContainer)choreographyContainer, "choreography.marker", loopType);
        return true;
    }
}

