/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractCreateExpandableFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.LayoutChoreographyFeature;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AbstractChoreographyFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.choreography.AddSubChoreographyFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public class SubChoreographyFeatureContainer
extends AbstractChoreographyFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof SubChoreography;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateSubChoreographyFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddSubChoreographyFeature(fp);
    }

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutChoreographyFeature(fp){

            protected void setTextLocation(ContainerShape choreographyContainer, AbstractText text, int w, int h) {
                List<ContainerShape> bandContainers = ChoreographyUtil.getParticipantBandContainerShapes(choreographyContainer);
                Tuple<List<ContainerShape>, List<ContainerShape>> topAndBottomBands = ChoreographyUtil.getTopAndBottomBands(bandContainers);
                List topBands = (List)topAndBottomBands.getFirst();
                int y = 3;
                if (!topBands.isEmpty()) {
                    ContainerShape containerShape = (ContainerShape)topBands.get(topBands.size() - 1);
                    GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                    y = ga.getY() + ga.getHeight() + 3;
                }
                this.gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, y, w, h);
            }
        };
    }

    public static class CreateSubChoreographyFeature
    extends AbstractCreateExpandableFlowNodeFeature<SubChoreography> {
        public CreateSubChoreographyFeature(IFeatureProvider fp) {
            super(fp, Messages.SubChoreographyFeatureContainer_Name, Messages.SubChoreographyFeatureContainer_Description);
        }

        public String getStencilImageId() {
            return ImageProvider.IMG_16_CHOREOGRAPHY_TASK;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getSubChoreography();
        }
    }
}

