/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MultiPageEditor;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class ShowDiagramPageFeature
extends AbstractCustomFeature {
    public ShowDiagramPageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.ShowDiagramPageFeature_Name;
    }

    public String getDescription() {
        return Messages.ShowDiagramPageFeature_Description;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            if (ChoreographyUtil.isChoreographyParticipantBand(pe)) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            Process baseElement = null;
            if (bo instanceof Participant) {
                Participant participant = (Participant)bo;
                baseElement = participant.getProcessRef();
            } else if (bo instanceof CallActivity) {
                CallActivity callActivity = (CallActivity)bo;
                baseElement = callActivity.getCalledElementRef();
            } else if (bo instanceof BaseElement) {
                baseElement = (BaseElement)bo;
            }
            if (DIUtils.findBPMNDiagram((BaseElement)baseElement) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            Process baseElement = null;
            if (bo instanceof Participant) {
                Participant participant = (Participant)bo;
                baseElement = participant.getProcessRef();
            } else if (bo instanceof CallActivity) {
                CallActivity callActivity = (CallActivity)bo;
                baseElement = callActivity.getCalledElementRef();
            } else if (bo instanceof BaseElement) {
                baseElement = (BaseElement)bo;
            }
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)baseElement);
            if (bpmnDiagram != null) {
                if (bpmnDiagram.eResource() == ((EObject)bo).eResource()) {
                    BPMN2MultiPageEditor mpe = ((BPMN2Editor)this.getDiagramEditor()).getMultipageEditor();
                    mpe.showDesignPage(bpmnDiagram);
                } else {
                    BPMN2Editor.openEditor(bpmnDiagram.eResource().getURI());
                }
            }
        }
    }

    public String getImageId() {
        return ImageProvider.IMG_16_EXPAND;
    }

    public boolean hasDoneChanges() {
        return false;
    }
}

