/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;

public class ResizeChoreographyFeature
extends DefaultResizeBPMNShapeFeature {
    public ResizeChoreographyFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canResizeShape(IResizeShapeContext context) {
        try {
            List<BPMNShape> bands = ChoreographyUtil.getParicipantBandBpmnShapes((ContainerShape)context.getPictogramElement());
            int h = 15;
            for (BPMNShape shape : bands) {
                h = (int)((float)h + shape.getBounds().getHeight());
            }
            return context.getHeight() > 0 ? context.getHeight() > h : true;
        }
        catch (Exception e) {
            Activator.logError((Exception)e);
            return true;
        }
    }

    public void resizeShape(IResizeShapeContext context) {
        try {
            List<ContainerShape> bands = ChoreographyUtil.getParticipantBandContainerShapes((ContainerShape)context.getPictogramElement());
            Tuple<List<ContainerShape>, List<ContainerShape>> topAndBottom = ChoreographyUtil.getTopAndBottomBands(bands);
            ChoreographyUtil.resizePartipantBandContainerShapes(context.getWidth(), context.getHeight(), (List)topAndBottom.getFirst(), (List)topAndBottom.getSecond(), this.getDiagram());
        }
        catch (Exception e) {
            Activator.logError((Exception)e);
        }
        ChoreographyUtil.updateChoreographyMessageLinks((IPictogramElementContext)context);
        super.resizeShape(context);
    }
}

