/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class RemoveChoreographyMessageFeature
extends AbstractCustomFeature {
    public RemoveChoreographyMessageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.RemoveChoreographyMessageFeature_Name;
    }

    public String getDescription() {
        return Messages.RemoveChoreographyMessageFeature_Description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_REMOVE_MESSAGE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof Participant) {
                Participant participant = (Participant)bo;
                Object parent = this.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)pe).getContainer());
                if (parent instanceof ChoreographyTask) {
                    ChoreographyTask ct = (ChoreographyTask)parent;
                    boolean canRemove = false;
                    for (MessageFlow mf : ct.getMessageFlowRef()) {
                        if (!participant.equals(mf.getSourceRef())) continue;
                        canRemove = true;
                        break;
                    }
                    return canRemove;
                }
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof Participant) {
                ContainerShape containerShape = (ContainerShape)pe;
                Participant participant = (Participant)bo;
                Object parent = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                if (parent instanceof ChoreographyTask) {
                    ChoreographyTask ct = (ChoreographyTask)parent;
                    Diagram diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
                    for (MessageFlow mf : ct.getMessageFlowRef()) {
                        if (!participant.equals(mf.getSourceRef())) continue;
                        Connection connection = (Connection)Graphiti.getLinkService().getPictogramElements(diagram, (EObject)mf).get(0);
                        if (!ChoreographyUtil.removeChoreographyMessageLink((PictogramElement)connection)) break;
                        ct.getMessageFlowRef().remove(mf);
                        EcoreUtil.delete((EObject)mf);
                        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, BPMNShape.class);
                        bpmnShape.setIsMessageVisible(false);
                        break;
                    }
                }
            }
        }
    }
}

