/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.task;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.impl.TaskImpl;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.IFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.activity.task.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.diagram.BPMNFeatureProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.task.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class CustomElementFeatureContainer
implements ICustomElementFeatureContainer {
    protected String id;
    protected CustomTaskDescriptor customTaskDescriptor;
    protected IFeatureContainer featureContainerDelegate = null;
    protected BPMNFeatureProvider fp;

    public String getDescription() {
        if (this.customTaskDescriptor != null) {
            return this.customTaskDescriptor.getDescription();
        }
        return Messages.CustomElementFeatureContainer_Description;
    }

    protected IFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        EClass eClass = (EClass)ModelUtil.getEClassifierFromString((EPackage)this.customTaskDescriptor.getRuntime().getModelDescriptor().getEPackage(), (String)this.customTaskDescriptor.getType());
        return ((BPMNFeatureProvider)fp).getFeatureContainer(eClass.getInstanceClass());
    }

    protected IFeatureContainer getFeatureContainer(IFeatureProvider fp) {
        if (this.featureContainerDelegate == null) {
            this.featureContainerDelegate = this.createFeatureContainer(fp);
        }
        return this.featureContainerDelegate;
    }

    public Object getApplyObject(IContext context) {
        String id = CustomElementFeatureContainer.getId(context);
        if (id == null || !this.id.equals(id)) {
            return null;
        }
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            return BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)pe);
        }
        return null;
    }

    public boolean canApplyTo(Object o) {
        boolean b1 = o instanceof TaskImpl;
        boolean b2 = o.getClass().isAssignableFrom(TaskImpl.class);
        return b1 || b2;
    }

    public boolean isAvailable(IFeatureProvider fp) {
        return true;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static void setId(IContext context, String id) {
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "custom.element.id", id);
        } else {
            context.putProperty((Object)"custom.element.id", (Object)id);
        }
    }

    public static String getId(IContext context) {
        Object id = null;
        if (context instanceof IAddContext && ((IAddContext)context).getNewObject() instanceof EObject) {
            EObject object = (EObject)((IAddContext)context).getNewObject();
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            for (CustomTaskDescriptor ct : rt.getCustomTasks()) {
                id = ct.getFeatureContainer().getId(object);
                if (id == null) continue;
                context.putProperty((Object)"custom.element.id", id);
                return (String)id;
            }
        }
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            id = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, "custom.element.id");
        } else {
            id = context.getProperty((Object)"custom.element.id");
        }
        return (String)id;
    }

    public String getId(EObject object) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setCustomTaskDescriptor(CustomTaskDescriptor customTaskDescriptor) {
        this.customTaskDescriptor = customTaskDescriptor;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddCustomElementFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getUpdateFeature(fp);
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDirectEditingFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getLayoutFeature(fp);
    }

    public IRemoveFeature getRemoveFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getRemoveFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDeleteFeature(fp);
    }

    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getCustomFeatures(fp);
    }

    public class AddCustomElementFeature
    extends AbstractBpmn2AddFeature<BaseElement> {
        protected AbstractBpmn2AddFeature<BaseElement> addFeatureDelegate;

        public AddCustomElementFeature(IFeatureProvider fp) {
            super(fp);
            this.addFeatureDelegate = (AbstractBpmn2AddFeature)CustomElementFeatureContainer.this.getFeatureContainer(fp).getAddFeature(fp);
            Assert.isNotNull(this.addFeatureDelegate);
        }

        public PictogramElement add(IAddContext context) {
            String icon;
            PictogramElement pe = this.addFeatureDelegate.add(context);
            if (pe != null) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "custom.element.id", CustomElementFeatureContainer.this.getId());
            }
            if ((icon = CustomElementFeatureContainer.this.customTaskDescriptor.getIcon()) != null && pe instanceof ContainerShape) {
                boolean addImage = true;
                ContainerShape containerShape = (ContainerShape)pe;
                GraphicsAlgorithm ga = (GraphicsAlgorithm)AbstractBpmn2AddFeature.getGraphicsAlgorithm((ContainerShape)containerShape);
                for (PictogramElement child : containerShape.getChildren()) {
                    if (!(child.getGraphicsAlgorithm() instanceof Image)) continue;
                    addImage = false;
                    break;
                }
                if (ga != null) {
                    for (GraphicsAlgorithm g : ga.getGraphicsAlgorithmChildren()) {
                        if (!(g instanceof Image)) continue;
                        addImage = false;
                        break;
                    }
                } else {
                    addImage = false;
                }
                if (addImage) {
                    Image img = CustomTaskImageProvider.createImage((CustomTaskDescriptor)CustomElementFeatureContainer.this.customTaskDescriptor, (GraphicsAlgorithmContainer)ga, (String)icon, (int)24, (int)24);
                    Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)img, 2, 2, 24, 24);
                }
            }
            return pe;
        }

        public BaseElement getBusinessObject(IAddContext context) {
            return (BaseElement)this.addFeatureDelegate.getBusinessObject(context);
        }

        public void putBusinessObject(IAddContext context, BaseElement businessObject) {
            this.addFeatureDelegate.putBusinessObject(context, (EObject)businessObject);
        }

        public void postExecute(IExecutionInfo executionInfo) {
            this.addFeatureDelegate.postExecute(executionInfo);
        }

        public boolean canAdd(IAddContext context) {
            return this.addFeatureDelegate.canAdd(context);
        }
    }
}

