/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Transaction;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractCreateExpandableFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractExpandableActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AddExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.LayoutExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.UpdateExpandableActivityFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class TransactionFeatureContainer
extends AbstractExpandableActivityFeatureContainer {
    private static final int offset = 3;

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Transaction;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateTransactionFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddExpandableActivityFeature<Transaction>(fp){

            @Override
            protected void decorateShape(IAddContext context, ContainerShape containerShape, Transaction businessObject) {
                super.decorateShape(context, containerShape, businessObject);
                RoundedRectangle rect = (RoundedRectangle)1.getGraphicsAlgorithm((ContainerShape)containerShape);
                IGaService gaService = Graphiti.getGaService();
                RoundedRectangle innerRect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)rect, 5, 5);
                innerRect.setFilled(Boolean.valueOf(false));
                innerRect.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
                gaService.setLocationAndSize((GraphicsAlgorithm)innerRect, 3, 3, rect.getWidth() - 6, rect.getHeight() - 6);
            }

            protected int getMarkerContainerOffset() {
                return 3;
            }
        };
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        IUpdateFeature updateFeature = super.getUpdateFeature(fp);
        MultiUpdateFeature multiUpdate = updateFeature instanceof MultiUpdateFeature ? (MultiUpdateFeature)updateFeature : new MultiUpdateFeature(fp);
        UpdateExpandableActivityFeature ueaf = new UpdateExpandableActivityFeature(fp);
        multiUpdate.addUpdateFeature((IUpdateFeature)ueaf);
        return multiUpdate;
    }

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutExpandableActivityFeature(fp){

            protected void layoutInRectangle(RoundedRectangle rect) {
                IGaService gaService = Graphiti.getGaService();
                RoundedRectangle innerRect = (RoundedRectangle)rect.getGraphicsAlgorithmChildren().get(0);
                gaService.setSize((GraphicsAlgorithm)innerRect, rect.getWidth() - 6, rect.getHeight() - 6);
            }

            protected int getMarkerContainerOffset() {
                return 3;
            }
        };
    }

    public static class CreateTransactionFeature
    extends AbstractCreateExpandableFlowNodeFeature<Transaction> {
        public CreateTransactionFeature(IFeatureProvider fp) {
            super(fp, Messages.TransactionFeatureContainer_Name, Messages.TransactionFeatureContainer_Description);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_TRANSACTION;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getTransaction();
        }
    }
}

