/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractExpandableActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ResizeExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ShowDiagramPageFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ExpandFlowNodeFeature
extends ShowDiagramPageFeature {
    private static final String NAME = Messages.ExpandFlowNodeFeature_Name;
    private static final String DESCRIPTION = Messages.ExpandFlowNodeFeature_Description;
    private String name = NAME;
    private String description = DESCRIPTION;

    public ExpandFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getImageId() {
        return ImageProvider.IMG_16_EXPAND;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return true;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        if (super.canExecute(context)) {
            this.name = super.getName();
            this.description = super.getDescription();
            return true;
        }
        this.name = NAME;
        this.description = DESCRIPTION;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
            return !AbstractExpandableActivityFeatureContainer.isElementExpanded(bo);
        }
        return ret;
    }

    @Override
    public void execute(ICustomContext context) {
        if (super.canExecute(context)) {
            super.execute(context);
            return;
        }
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe0 = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe0);
            if (pe0 instanceof ContainerShape && bo instanceof FlowNode) {
                ContainerShape containerShape = (ContainerShape)pe0;
                FlowNode flowNode = (FlowNode)bo;
                try {
                    BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)flowNode);
                    if (!bpmnShape.isIsExpanded()) {
                        bpmnShape.setIsExpanded(true);
                        GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                        ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                        IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                        int oldWidth = ga.getWidth();
                        int oldHeight = ga.getHeight();
                        ResizeExpandableActivityFeature.SizeCalculator newSize = new ResizeExpandableActivityFeature.SizeCalculator(containerShape);
                        int newWidth = newSize.getWidth();
                        int newHeight = newSize.getHeight();
                        resizeContext.setX(ga.getX() + oldWidth / 2 - newWidth / 2);
                        resizeContext.setY(ga.getY() + oldHeight / 2 - newHeight / 2);
                        resizeContext.setWidth(newWidth);
                        resizeContext.setHeight(newHeight);
                        resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                        UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
                        IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                        if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                            updateFeature.update((IUpdateContext)updateContext);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

