/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractExpandableActivityFeatureContainer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class CollapseFlowNodeFeature
extends AbstractCustomFeature {
    public CollapseFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Collapse";
    }

    public String getDescription() {
        return "Collapse the Activity and hide contents";
    }

    public String getImageId() {
        return ImageProvider.IMG_16_COLLAPSE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
            return AbstractExpandableActivityFeatureContainer.isElementExpanded(bo);
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe0 = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe0);
            if (pe0 instanceof ContainerShape && bo instanceof FlowNode) {
                ContainerShape containerShape = (ContainerShape)pe0;
                FlowNode flowNode = (FlowNode)bo;
                try {
                    BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)flowNode);
                    if (bpmnShape.isIsExpanded()) {
                        bpmnShape.setIsExpanded(false);
                        GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                        ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                        IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                        int oldWidth = ga.getWidth();
                        int oldHeight = ga.getHeight();
                        int newWidth = GraphicsUtil.getActivitySize((Diagram)this.getDiagram()).getWidth();
                        int newHeight = GraphicsUtil.getActivitySize((Diagram)this.getDiagram()).getHeight();
                        resizeContext.setX(ga.getX() + oldWidth / 2 - newWidth / 2);
                        resizeContext.setY(ga.getY() + oldHeight / 2 - newHeight / 2);
                        resizeContext.setWidth(newWidth);
                        resizeContext.setHeight(newHeight);
                        resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                        UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
                        IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                        if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                            updateFeature.update((IUpdateContext)updateContext);
                        }
                        this.getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

