/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractAddActivityFeature;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class AddExpandableActivityFeature<T extends Activity>
extends AbstractAddActivityFeature<T> {
    public AddExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected void decorateShape(IAddContext context, ContainerShape containerShape, T businessObject) {
        boolean isTriggeredByEvent = false;
        boolean isExpanded = true;
        if (businessObject instanceof SubProcess) {
            SubProcess subprocess = (SubProcess)businessObject;
            isTriggeredByEvent = subprocess.isTriggeredByEvent();
            BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)subprocess);
            if (bpmnShape != null) {
                isExpanded = bpmnShape.isIsExpanded();
            }
        }
        this.peService.setPropertyValue((PropertyContainer)containerShape, "triggered-by-event-key", Boolean.toString(isTriggeredByEvent));
        this.peService.setPropertyValue((PropertyContainer)containerShape, "is-expanded-key", Boolean.toString(isExpanded));
        Shape textShape = this.peService.createShape(containerShape, false);
        MultiText text = this.gaService.createDefaultMultiText(this.getDiagram(), (GraphicsAlgorithmContainer)textShape, businessObject.getName());
        this.gaService.setLocationAndSize((GraphicsAlgorithm)text, 5, 5, context.getWidth() - 10, 15);
        StyleUtil.applyStyle((GraphicsAlgorithm)text, businessObject);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        this.link((PictogramElement)textShape, businessObject);
        if (!isExpanded) {
            GraphicsUtil.showActivityMarker((ContainerShape)containerShape, (String)"activity.marker.expand");
        } else {
            GraphicsUtil.hideActivityMarker((ContainerShape)containerShape, (String)"activity.marker.expand");
        }
    }

    public int getWidth() {
        if (this.preferences.isExpandedDefault()) {
            return 300;
        }
        return 110;
    }

    public int getHeight() {
        if (this.preferences.isExpandedDefault()) {
            return 300;
        }
        return 50;
    }
}

