/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.task.DirectEditTaskFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.AbstractActivityFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.CollapseFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.DeleteExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ExpandFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.LayoutExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PullupFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.PushdownFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ResizeExpandableActivityFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;

public abstract class AbstractExpandableActivityFeatureContainer
extends AbstractActivityFeatureContainer {
    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditTaskFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutExpandableActivityFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        IUpdateFeature updateFeature = super.getUpdateFeature(fp);
        MultiUpdateFeature multiUpdate = updateFeature instanceof MultiUpdateFeature ? (MultiUpdateFeature)updateFeature : new MultiUpdateFeature(fp);
        AbstractUpdateBaseElementFeature nameUpdateFeature = new AbstractUpdateBaseElementFeature(fp){

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                return bo != null && bo instanceof BaseElement && AbstractExpandableActivityFeatureContainer.this.canApplyTo((BaseElement)bo);
            }
        };
        multiUpdate.addUpdateFeature((IUpdateFeature)nameUpdateFeature);
        return multiUpdate;
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new ResizeExpandableActivityFeature(fp);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteExpandableActivityFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        ICustomFeature[] superFeatures = super.getCustomFeatures(fp);
        ICustomFeature[] thisFeatures = new ICustomFeature[4 + superFeatures.length];
        thisFeatures[0] = new ExpandFlowNodeFeature(fp);
        thisFeatures[1] = new CollapseFlowNodeFeature(fp);
        thisFeatures[2] = new PushdownFeature(fp);
        thisFeatures[3] = new PullupFeature(fp);
        int i = 0;
        while (i < superFeatures.length) {
            thisFeatures[4 + i] = superFeatures[i];
            ++i;
        }
        return thisFeatures;
    }

    public static boolean isExpandableElement(Object object) {
        return object instanceof FlowElementsContainer || object instanceof CallActivity || object instanceof CallChoreography;
    }

    public static boolean isElementExpanded(Object object) {
        if (AbstractExpandableActivityFeatureContainer.isExpandableElement(object)) {
            BaseElement be = (BaseElement)object;
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)be);
            BPMNShape bpmnShape = DIUtils.findBPMNShape((BaseElement)be);
            if (bpmnShape != null && bpmnShape.isIsExpanded() && bpmnDiagram == null) {
                return true;
            }
        }
        return false;
    }
}

