/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MultiPageEditor;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class DesignEditor
extends BPMN2Editor {
    protected ResourceSetListener resourceSetListener = null;
    private BPMNDiagram bpmnDiagramDeleted = null;
    protected Composite container;
    protected CTabFolder tabFolder;
    private int defaultTabHeight;
    private boolean inSelectionChanged = false;

    public DesignEditor(BPMN2MultiPageEditor bpmn2MultiPageEditor, BPMN2MultiPageEditor mpe) {
        super(mpe);
    }

    public void deleteBpmnDiagram(BPMNDiagram bpmnDiagram) {
        this.bpmnDiagramDeleted = bpmnDiagram;
    }

    @Override
    public void dispose() {
        if (this.bpmnDiagramDeleted == null) {
            this.getEditingDomain().removeResourceSetListener(this.resourceSetListener);
            this.resourceSetListener = null;
            super.dispose();
        } else {
            this.bpmnDiagramDeleted = null;
        }
    }

    @Override
    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.resourceSetListener == null) {
            this.resourceSetListener = new AddRemoveDiagramListener();
            this.getEditingDomain().addResourceSetListener(this.resourceSetListener);
        }
    }

    protected void setPartName(String partName) {
        super.setPartName(URI.decode((String)partName));
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
        if (!this.inSelectionChanged) {
            try {
                try {
                    this.inSelectionChanged = true;
                    EObject object = BusinessObjectUtil.getBusinessObjectForSelection((ISelection)selection);
                    if (object != null && object.eResource() == this.bpmnResource) {
                        BPMNDiagram newBpmnDiagram = null;
                        boolean showSelection = true;
                        if (object instanceof BaseElement) {
                            if (part instanceof ContentOutline) {
                                newBpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)((BaseElement)object), (boolean)true);
                                BPMNDiagram o = DIUtils.findBPMNDiagram((BaseElement)((BaseElement)object), (boolean)false);
                                if (o == newBpmnDiagram) {
                                    showSelection = false;
                                }
                            }
                        } else if (object instanceof BPMNDiagram) {
                            newBpmnDiagram = (BPMNDiagram)object;
                            showSelection = false;
                        }
                        if (newBpmnDiagram != null && this.getBpmnDiagram() != newBpmnDiagram) {
                            this.multipageEditor.showDesignPage(newBpmnDiagram);
                            final BPMNDiagram d = newBpmnDiagram;
                            if (showSelection) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        DesignEditor.this.showDesignPage(d);
                                        PictogramElement sel = BusinessObjectUtil.getPictogramElementForSelection((ISelection)selection);
                                        if (sel instanceof PictogramElement) {
                                            DesignEditor.super.selectPictogramElements(new PictogramElement[]{sel});
                                        }
                                    }
                                });
                            }
                        }
                    }
                    DesignEditor.super.selectionChanged(part, selection);
                }
                catch (Exception exception) {
                    this.inSelectionChanged = false;
                }
            }
            finally {
                this.inSelectionChanged = false;
            }
        }
    }

    public void pageChange(BPMNDiagram bpmnDiagram) {
        this.setBpmnDiagram(bpmnDiagram);
        this.reloadTabs();
        this.tabFolder.setSelection(0);
        this.tabFolder.getItem(0).getControl().setVisible(true);
        this.tabFolder.getItem(0).setData((Object)bpmnDiagram);
        this.updatePalette();
    }

    public void selectBpmnDiagram(BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
        if (diagram != null) {
            this.selectPictogramElements(new PictogramElement[]{diagram});
            this.getDiagramBehavior().refreshContent();
        }
    }

    public void showDesignPage(BPMNDiagram bpmnDiagram) {
        CTabItem current = this.tabFolder.getSelection();
        if (current != null && current.getData() == bpmnDiagram) {
            current.getControl().setVisible(true);
            return;
        }
        this.showDesignPageInternal(bpmnDiagram);
    }

    private void showDesignPageInternal(BPMNDiagram bpmnDiagram) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == bpmnDiagram) {
                this.setBpmnDiagram(bpmnDiagram);
                this.tabFolder.setSelection(item);
                item.getControl().setVisible(true);
            }
            ++n2;
        }
    }

    protected void addDesignPage(BPMNDiagram bpmnDiagram) {
        this.setBpmnDiagram((BPMNDiagram)this.tabFolder.getItem(0).getData());
        this.reloadTabs();
        this.showDesignPage(bpmnDiagram);
    }

    protected void removeDesignPage(BPMNDiagram bpmnDiagram) {
        CTabItem currentItem = this.tabFolder.getSelection();
        BPMNDiagram currentBpmnDiagram = (BPMNDiagram)currentItem.getData();
        this.setBpmnDiagram((BPMNDiagram)this.tabFolder.getItem(0).getData());
        this.reloadTabs();
        this.showDesignPage(currentBpmnDiagram);
    }

    private void reloadTabs() {
        ArrayList<BPMNDiagram> bpmnDiagrams = new ArrayList<BPMNDiagram>();
        BaseElement bpmnElement = this.bpmnDiagram.getPlane().getBpmnElement();
        this.getSubDiagrams(bpmnElement, bpmnDiagrams);
        this.tabFolder.setLayoutDeferred(true);
        int i = this.tabFolder.getItemCount() - 1;
        while (i > 0) {
            this.tabFolder.getItem(i).setControl(null);
            this.tabFolder.getItem(i).dispose();
            --i;
        }
        if (bpmnDiagrams.size() > 0) {
            for (BPMNDiagram bd : bpmnDiagrams) {
                CTabItem item = new CTabItem(this.tabFolder, 0);
                item.setControl((Control)this.container);
                BaseElement be = bd.getPlane().getBpmnElement();
                item.setText(ModelUtil.getDisplayName((Object)be));
                item.setData((Object)bd);
            }
        }
        this.tabFolder.setLayoutDeferred(false);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DesignEditor.this.updateTabs();
            }
        });
    }

    private void getSubDiagrams(BaseElement bpmnElement, List<BPMNDiagram> bpmnDiagrams) {
        List flowElements = null;
        if (bpmnElement instanceof FlowElementsContainer) {
            flowElements = ((FlowElementsContainer)bpmnElement).getFlowElements();
        } else if (bpmnElement instanceof Collaboration) {
            flowElements = new ArrayList();
            for (Participant p : ((Collaboration)bpmnElement).getParticipants()) {
                if (p.getProcessRef() == null) continue;
                flowElements.addAll(p.getProcessRef().getFlowElements());
            }
        } else if (bpmnElement instanceof Choreography) {
            flowElements = ((Choreography)bpmnElement).getFlowElements();
        }
        if (flowElements != null) {
            BPMNDiagram mainBpmnDiagram = (BPMNDiagram)ModelUtil.getDefinitions((Resource)this.bpmnResource).getDiagrams().get(0);
            BPMNDiagram activeBpmnDiagram = this.getBpmnDiagram();
            for (FlowElement fe : flowElements) {
                BPMNDiagram bd = DIUtils.findBPMNDiagram((BaseElement)fe);
                if (bd != null && !bpmnDiagrams.contains(bd) && bd != activeBpmnDiagram && bd != mainBpmnDiagram) {
                    bpmnDiagrams.add(bd);
                }
                this.getSubDiagrams((BaseElement)fe, bpmnDiagrams);
            }
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        if (this.getGraphicalViewer() == null) {
            this.tabFolder = new CTabFolder(parent, 1024);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int pageIndex = DesignEditor.this.tabFolder.indexOf((CTabItem)e.item);
                    CTabItem item = DesignEditor.this.tabFolder.getItem(pageIndex);
                    BPMNDiagram bpmnDiagram = (BPMNDiagram)item.getData();
                    DesignEditor.this.showDesignPageInternal(bpmnDiagram);
                    DesignEditor.this.selectBpmnDiagram(bpmnDiagram);
                }
            });
            this.tabFolder.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 256: 
                        case 512: {
                            int detail = e.detail;
                            e.doit = true;
                            e.detail = 0;
                            Composite control = DesignEditor.this.tabFolder.getParent();
                            control.traverse(detail, new Event());
                        }
                    }
                }
            });
            this.defaultTabHeight = this.tabFolder.getTabHeight();
            this.container = new Composite((Composite)this.tabFolder, 0);
            this.container.setLayout((Layout)new FillLayout());
            CTabItem item = new CTabItem(this.tabFolder, 0, 0);
            item.setText(Messages.DesignEditor_Diagram_Tab);
            item.setControl((Control)this.container);
            item.setData((Object)this.getBpmnDiagram());
            super.createPartControl(this.container);
            List bpmnDiagrams = this.getModelHandler().getAll(BPMNDiagram.class);
            int i = 1;
            while (i < bpmnDiagrams.size()) {
                BPMNDiagram bpmnDiagram = (BPMNDiagram)bpmnDiagrams.get(i);
                if (bpmnDiagram.getPlane().getBpmnElement() instanceof RootElement) {
                    this.multipageEditor.addDesignPage(bpmnDiagram);
                }
                ++i;
            }
        }
    }

    public void updateTabs() {
        if (this.tabFolder.getItemCount() == 1) {
            this.tabFolder.setTabHeight(0);
        } else {
            this.tabFolder.setTabHeight(this.defaultTabHeight);
        }
        this.tabFolder.layout();
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        WorkbenchPartAction action = new WorkbenchPartAction((IWorkbenchPart)this.multipageEditor.getDesignEditor()){

            protected void init() {
                super.init();
                this.setId("show.or.hide.source.view");
            }

            public String getText() {
                return DesignEditor.this.multipageEditor.getSourceViewer() == null ? Messages.DesignEditor_Show_Source_View_Action : Messages.DesignEditor_Hide_Source_View_Action;
            }

            protected boolean calculateEnabled() {
                return true;
            }

            public void run() {
                if (DesignEditor.this.multipageEditor.getSourceViewer() == null) {
                    DesignEditor.this.multipageEditor.createSourceViewer();
                } else {
                    DesignEditor.this.multipageEditor.removeSourceViewer();
                }
            }
        };
        registry.registerAction((IAction)action);
        action = new WorkbenchPartAction((IWorkbenchPart)this.multipageEditor.getDesignEditor()){

            protected void init() {
                super.init();
                this.setId("delete.page");
            }

            public String getText() {
                int pageIndex = DesignEditor.this.multipageEditor.getActivePage();
                return NLS.bind((String)Messages.DesignEditor_Delete_Diagram_Action, (Object)DesignEditor.this.multipageEditor.getTabItem(pageIndex).getText());
            }

            public boolean isEnabled() {
                return this.calculateEnabled();
            }

            protected boolean calculateEnabled() {
                BPMNDiagram bpmnDiagram = DesignEditor.this.getBpmnDiagram();
                BPMNPlane plane = bpmnDiagram.getPlane();
                BaseElement process = plane.getBpmnElement();
                List participants = DesignEditor.this.getModelHandler().getAll(Participant.class);
                for (Participant p : participants) {
                    if (p.getProcessRef() != process) continue;
                    return false;
                }
                return true;
            }

            public void run() {
                BPMNDiagram bpmnDiagram;
                TransactionalEditingDomain domain;
                int pageIndex = DesignEditor.this.multipageEditor.getActivePage();
                boolean result = MessageDialog.openQuestion((Shell)DesignEditor.this.getSite().getShell(), (String)Messages.DesignEditor_Delete_Page_Title, (String)NLS.bind((String)Messages.DesignEditor_DeletePage_Message, (Object)DesignEditor.this.multipageEditor.getTabItem(pageIndex).getText()));
                if (result && (domain = TransactionUtil.getEditingDomain((EObject)(bpmnDiagram = DesignEditor.this.getBpmnDiagram()))) != null) {
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            BPMNPlane plane = bpmnDiagram.getPlane();
                            BaseElement process = plane.getBpmnElement();
                            DIUtils.deleteDiagram((IDiagramBehavior)DesignEditor.this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
                            EcoreUtil.delete((EObject)process, (boolean)true);
                        }
                    });
                }
            }
        };
        registry.registerAction((IAction)action);
    }

    public class AddRemoveDiagramListener
    implements ResourceSetListener {
        public NotificationFilter getFilter() {
            return null;
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            boolean debug = Activator.getDefault().isDebugging();
            for (Notification n : event.getNotifications()) {
                String text;
                BaseElement bpmnElement;
                int et = n.getEventType();
                Object notifier = n.getNotifier();
                Object newValue = n.getNewValue();
                Object oldValue = n.getOldValue();
                Object feature = n.getFeature();
                if (debug && (et == 3 || et == 4 || et == 1)) {
                    System.out.print("event: " + et + "\t");
                    if (notifier instanceof EObject) {
                        System.out.print("notifier: $" + ((EObject)notifier).eClass().getName());
                    } else {
                        System.out.print("notifier: " + notifier);
                    }
                }
                if (et == 3) {
                    if (debug) {
                        if (newValue instanceof EObject) {
                            System.out.println("\t\tvalue:    " + ((EObject)newValue).eClass().getName());
                        } else {
                            System.out.println("\t\tvalue:    " + newValue);
                        }
                    }
                    if (!(notifier instanceof Definitions) || !(newValue instanceof BPMNDiagram) || feature != Bpmn2Package.eINSTANCE.getDefinitions_Diagrams()) continue;
                    BPMNDiagram bpmnDiagram = (BPMNDiagram)newValue;
                    bpmnElement = bpmnDiagram.getPlane().getBpmnElement();
                    if (bpmnElement instanceof RootElement) {
                        DesignEditor.this.multipageEditor.addDesignPage(bpmnDiagram);
                        continue;
                    }
                    DesignEditor.this.addDesignPage(bpmnDiagram);
                    continue;
                }
                if (et == 4) {
                    if (debug) {
                        if (oldValue instanceof EObject) {
                            System.out.println("\t\tvalue:    " + ((EObject)oldValue).eClass().getName());
                        } else {
                            System.out.println("\t\tvalue:    " + oldValue);
                        }
                    }
                    if (!(notifier instanceof Definitions) || !(oldValue instanceof BPMNDiagram) || feature != Bpmn2Package.eINSTANCE.getDefinitions_Diagrams()) continue;
                    BPMNDiagram bpmnDiagram = (BPMNDiagram)oldValue;
                    bpmnElement = bpmnDiagram.getPlane().getBpmnElement();
                    if (bpmnElement instanceof RootElement) {
                        DesignEditor.this.multipageEditor.removeDesignPage(bpmnDiagram);
                        continue;
                    }
                    DesignEditor.this.removeDesignPage(bpmnDiagram);
                    continue;
                }
                if (et != 1 || !(n.getFeature() instanceof EStructuralFeature) || !((EStructuralFeature)n.getFeature()).getName().equals("name")) continue;
                int i = 1;
                while (i < DesignEditor.this.tabFolder.getItemCount()) {
                    CTabItem item = DesignEditor.this.tabFolder.getItem(i);
                    BPMNDiagram bpmnDiagram = (BPMNDiagram)item.getData();
                    if (bpmnDiagram != null && (bpmnDiagram == notifier || bpmnDiagram.getPlane().getBpmnElement() == notifier)) {
                        text = n.getNewStringValue();
                        if (text == null || text.isEmpty()) {
                            text = "Unnamed";
                        }
                        item.setText(text);
                    }
                    ++i;
                }
                i = 0;
                while (i < DesignEditor.this.multipageEditor.getPageCount()) {
                    BPMNDiagram bpmnDiagram = DesignEditor.this.multipageEditor.getBpmnDiagram(i);
                    if (bpmnDiagram == notifier) {
                        CTabItem item = DesignEditor.this.multipageEditor.getTabItem(i);
                        text = n.getNewStringValue();
                        if (text == null || text.isEmpty()) {
                            text = "Unnamed";
                        }
                        item.setText(text);
                    }
                    ++i;
                }
            }
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }
}

