/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.editor.DesignEditor;
import org.eclipse.bpmn2.modeler.ui.editor.DesignEditorSite;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.bpmn2.modeler.ui.editor.SourceViewer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class BPMN2MultiPageEditor
extends MultiPageEditorPart
implements IGotoMarker {
    DesignEditor designEditor;
    SourceViewer sourceViewer;
    private CTabFolder tabFolder;
    private int defaultTabHeight;
    private List<BPMNDiagram> bpmnDiagrams = new ArrayList<BPMNDiagram>();

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor instanceof DesignEditor) {
            return new DesignEditorSite(this, editor);
        }
        return new MultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    public String getTitle() {
        if (this.designEditor != null) {
            return this.designEditor.getTitle();
        }
        return super.getTitle();
    }

    public String getPartName() {
        if (this.designEditor != null) {
            return this.designEditor.getPartName();
        }
        return super.getPartName();
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPMN2MultiPageEditor.this.setTitleToolTip(BPMN2MultiPageEditor.this.getTitleToolTip());
            }
        });
    }

    public void gotoMarker(IMarker marker) {
        if (this.getActivePage() < 0) {
            this.setActivePage(0);
        }
        IDE.gotoMarker((IEditorPart)this.getEditor(this.getActivePage()), (IMarker)marker);
    }

    protected void createPages() {
        this.tabFolder = (CTabFolder)this.getContainer();
        this.tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent event) {
                if (event.item.getData() == BPMN2MultiPageEditor.this.sourceViewer) {
                    BPMN2MultiPageEditor.this.removeSourceViewer();
                }
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void showList(CTabFolderEvent event) {
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pageIndex = BPMN2MultiPageEditor.this.tabFolder.getSelectionIndex();
                if (pageIndex >= 0 && pageIndex < BPMN2MultiPageEditor.this.bpmnDiagrams.size() && BPMN2MultiPageEditor.this.designEditor != null) {
                    BPMNDiagram bpmnDiagram = (BPMNDiagram)BPMN2MultiPageEditor.this.bpmnDiagrams.get(pageIndex);
                    BPMN2MultiPageEditor.this.designEditor.selectBpmnDiagram(bpmnDiagram);
                }
            }
        });
        this.tabFolder.setLayoutDeferred(true);
        this.createDesignEditor();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPMN2MultiPageEditor.this.setActivePage(0);
                BPMN2MultiPageEditor.this.designEditor.selectBpmnDiagram((BPMNDiagram)BPMN2MultiPageEditor.this.bpmnDiagrams.get(0));
                BPMN2MultiPageEditor.this.tabFolder.setLayoutDeferred(false);
                BPMN2MultiPageEditor.this.tabFolder.setTabPosition(128);
                BPMN2MultiPageEditor.this.updateTabs();
            }
        });
    }

    protected void createDesignEditor() {
        if (this.designEditor == null) {
            this.designEditor = new DesignEditor(this, this);
            try {
                int pageIndex = this.tabFolder.getItemCount();
                if (this.sourceViewer != null) {
                    --pageIndex;
                }
                this.addPage(pageIndex, (IEditorPart)this.designEditor, this.getEditorInput());
                this.defaultTabHeight = this.tabFolder.getTabHeight();
                this.setPageText(pageIndex, ModelUtil.getDisplayName((Object)this.designEditor.getBpmnDiagram()));
                this.defaultTabHeight = this.tabFolder.getTabHeight();
                this.updateTabs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public DesignEditor getDesignEditor() {
        return this.designEditor;
    }

    protected void addDesignPage(final BPMNDiagram bpmnDiagram) {
        this.createDesignEditor();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int pageIndex = BPMN2MultiPageEditor.this.tabFolder.getItemCount();
                    if (BPMN2MultiPageEditor.this.sourceViewer != null) {
                        --pageIndex;
                    }
                    Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)BPMN2MultiPageEditor.this.designEditor.getEditorInput();
                    input.setBpmnDiagram(bpmnDiagram);
                    BPMN2MultiPageEditor.this.addPage(pageIndex, (IEditorPart)BPMN2MultiPageEditor.this.designEditor, (IEditorInput)input);
                    CTabItem oldItem = BPMN2MultiPageEditor.this.tabFolder.getItem(pageIndex - 1);
                    CTabItem newItem = BPMN2MultiPageEditor.this.tabFolder.getItem(pageIndex);
                    newItem.setControl(oldItem.getControl());
                    BPMN2MultiPageEditor.this.setPageText(pageIndex, ModelUtil.getDisplayName((Object)bpmnDiagram));
                    BPMN2MultiPageEditor.this.setActivePage(pageIndex);
                    BPMN2MultiPageEditor.this.updateTabs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showDesignPage(BPMNDiagram bpmnDiagram) {
        int pageIndex = this.bpmnDiagrams.indexOf(bpmnDiagram);
        if (pageIndex >= 0) {
            if (this.getDesignEditor().getBpmnDiagram() != bpmnDiagram) {
                this.setActivePage(pageIndex);
            }
        } else {
            this.designEditor.showDesignPage(bpmnDiagram);
        }
    }

    protected void removeDesignPage(final BPMNDiagram bpmnDiagram) {
        final int pageIndex = this.bpmnDiagrams.indexOf(bpmnDiagram);
        if (pageIndex > 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BPMN2MultiPageEditor.this.setActivePage(0);
                    IEditorPart editor = BPMN2MultiPageEditor.this.getEditor(pageIndex);
                    if (editor instanceof DesignEditor) {
                        ((DesignEditor)editor).deleteBpmnDiagram(bpmnDiagram);
                    }
                    BPMN2MultiPageEditor.this.tabFolder.getItem(pageIndex).setControl(null);
                    BPMN2MultiPageEditor.this.removePage(pageIndex);
                    BPMN2MultiPageEditor.this.tabFolder.getSelection().getControl().setVisible(true);
                }
            });
        }
    }

    public int getDesignPageCount() {
        int count = this.getPageCount();
        if (this.sourceViewer != null) {
            --count;
        }
        return count;
    }

    protected void createSourceViewer() {
        block3: {
            if (this.sourceViewer == null) {
                this.sourceViewer = new SourceViewer(this);
                try {
                    int pageIndex = this.tabFolder.getItemCount();
                    FileEditorInput input = new FileEditorInput(this.designEditor.getModelFile());
                    this.addPage(pageIndex, (IEditorPart)this.sourceViewer, (IEditorInput)input);
                    this.tabFolder.getItem(pageIndex).setShowClose(true);
                    this.setPageText(pageIndex, Messages.BPMN2MultiPageEditor_Source_Tab);
                    this.setActivePage(pageIndex);
                    this.updateTabs();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.sourceViewer == null) break block3;
                    this.sourceViewer.dispose();
                }
            }
        }
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void removeSourceViewer() {
        int pageIndex;
        if (this.sourceViewer != null && (pageIndex = this.tabFolder.getItemCount() - 1) > 0) {
            this.removePage(pageIndex);
            this.sourceViewer = null;
        }
    }

    public void addPage(int pageIndex, IEditorPart editor, IEditorInput input) throws PartInitException {
        super.addPage(pageIndex, editor, input);
        if (editor instanceof DesignEditor) {
            this.bpmnDiagrams.add(pageIndex, ((DesignEditor)editor).getBpmnDiagram());
        }
    }

    public void removePage(int pageIndex) {
        Object page = this.tabFolder.getItem(pageIndex).getData();
        super.removePage(pageIndex);
        this.updateTabs();
        if (page instanceof DesignEditor) {
            this.bpmnDiagrams.remove(pageIndex);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IEditorPart editor = this.getEditor(newPageIndex);
        if (editor instanceof DesignEditor) {
            BPMNDiagram bpmnDiagram = this.bpmnDiagrams.get(newPageIndex);
            ((DesignEditor)editor).pageChange(bpmnDiagram);
        }
    }

    public int getPageCount() {
        return this.tabFolder.getItemCount();
    }

    public CTabItem getTabItem(int pageIndex) {
        return this.tabFolder.getItem(pageIndex);
    }

    public BPMNDiagram getBpmnDiagram(int i) {
        if (i >= 0 && i < this.bpmnDiagrams.size()) {
            return this.bpmnDiagrams.get(i);
        }
        return null;
    }

    private void updateTabs() {
        if (!this.tabFolder.getLayoutDeferred()) {
            if (this.tabFolder.getItemCount() == 1) {
                this.tabFolder.setTabHeight(0);
            } else {
                this.tabFolder.setTabHeight(this.defaultTabHeight);
            }
        }
        this.tabFolder.layout();
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void doSave(IProgressMonitor monitor) {
        this.designEditor.doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart activeEditor = this.getActiveEditor();
        activeEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            return activeEditor.isSaveAsAllowed();
        }
        return false;
    }

    public void dispose() {
        this.designEditor.dispose();
        if (this.sourceViewer != null) {
            this.sourceViewer.dispose();
        }
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }
}

