/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.bpmn2.modeler.core.Bpmn2TabbedPropertySheetPage;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ValidationStatusLoader;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class BPMN2MarkerChangeListener
implements IResourceChangeListener {
    BPMN2Editor editor;

    public BPMN2MarkerChangeListener(BPMN2Editor editor) {
        this.editor = editor;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.editor.getModelFile() == null) {
            return;
        }
        IResourceDelta modelFileDelta = event.getDelta().findMember(this.editor.getModelFile().getFullPath());
        if (modelFileDelta == null) {
            return;
        }
        IMarkerDelta[] markerDeltas = modelFileDelta.getMarkerDeltas();
        if (markerDeltas == null || markerDeltas.length == 0) {
            return;
        }
        ArrayList<IMarker> newMarkers = new ArrayList<IMarker>();
        HashSet<String> deletedMarkers = new HashSet<String>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
            switch (markerDelta.getKind()) {
                case 1: {
                    newMarkers.add(markerDelta.getMarker());
                    break;
                }
                case 4: {
                    newMarkers.add(markerDelta.getMarker());
                }
                case 2: {
                    String uri = markerDelta.getAttribute("uri", null);
                    if (uri == null) break;
                    deletedMarkers.add(uri);
                }
            }
            ++n2;
        }
        LinkedHashSet<EObject> updatedObjects = new LinkedHashSet<EObject>();
        for (String uri : deletedMarkers) {
            ValidationStatusAdapter adapter;
            EObject eobject = this.editor.getEditingDomain().getResourceSet().getEObject(URI.createURI((String)uri), false);
            if (eobject == null || (adapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)eobject, ValidationStatusAdapter.class)) == null) continue;
            adapter.clearValidationStatus();
            updatedObjects.add(eobject);
        }
        BPMN2ValidationStatusLoader vsl = new BPMN2ValidationStatusLoader((DiagramEditor)this.editor);
        updatedObjects.addAll(vsl.load(newMarkers));
        this.editor.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPMN2MarkerChangeListener.this.editor.refresh();
                IWorkbenchPage page = BPMN2MarkerChangeListener.this.editor.getEditorSite().getPage();
                String viewID = "org.eclipse.ui.views.PropertySheet";
                try {
                    IViewReference[] views;
                    IViewReference[] iViewReferenceArray = views = page.getViewReferences();
                    int n = views.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertySheet ps;
                        IPage pp;
                        IViewReference v = iViewReferenceArray[n2];
                        if (viewID.equals(v.getId()) && (pp = (ps = (PropertySheet)v.getView(true)).getCurrentPage()) instanceof Bpmn2TabbedPropertySheetPage) {
                            ((Bpmn2TabbedPropertySheetPage)pp).refresh();
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        });
    }
}

