/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Category;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GlobalBusinessRuleTask;
import org.eclipse.bpmn2.GlobalManualTask;
import org.eclipse.bpmn2.GlobalScriptTask;
import org.eclipse.bpmn2.GlobalTask;
import org.eclipse.bpmn2.GlobalUserTask;
import org.eclipse.bpmn2.HumanPerformer;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Performer;
import org.eclipse.bpmn2.PotentialOwner;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.ResourceAssignmentExpression;
import org.eclipse.bpmn2.ResourceParameterBinding;
import org.eclipse.bpmn2.ResourceRole;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StandardLoopCharacteristics;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.Bpmn2TabbedPropertySheetPage;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.ProxyURIConverterImplExtension;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDialogComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.DiagramEditorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ValidationStatusLoader;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.diagram.BPMNToolBehaviorProvider;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditingDomainListener;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditorDiagramBehavior;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MarkerChangeListener;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2MultiPageEditor;
import org.eclipse.bpmn2.modeler.ui.editor.ConnectionLayerClippingStrategy;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.bpmn2.modeler.ui.property.PropertyTabDescriptorProvider;
import org.eclipse.bpmn2.modeler.ui.property.artifact.CategoryDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.artifact.TextAnnotationDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.connectors.MessageFlowDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.connectors.SequenceFlowDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.DataAssignmentDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.DataObjectPropertySection;
import org.eclipse.bpmn2.modeler.ui.property.data.DataObjectReferencePropertySection;
import org.eclipse.bpmn2.modeler.ui.property.data.DataStorePropertySection;
import org.eclipse.bpmn2.modeler.ui.property.data.DataStoreReferencePropertySection;
import org.eclipse.bpmn2.modeler.ui.property.data.ExpressionDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.InterfaceDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.ItemAwareElementDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.MessageDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.MessageListComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.OperationDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.ResourceAssignmentExpressionDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.ResourceParameterBindingDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.data.ResourceRoleDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.DefinitionsPropertyComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.ItemDefinitionDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.ItemDefinitionListComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.ProcessDiagramDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.PropertyListComposite;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.ResourceRoleListComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.BoundaryEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.CatchEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.CommonEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.CommonEventPropertySection;
import org.eclipse.bpmn2.modeler.ui.property.events.ConditionalEventDefinitionDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.EndEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.StartEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.ThrowEventDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.events.TimerEventDefinitionDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.gateways.GatewayDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.ActivityDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.ActivityInputDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.ActivityOutputDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.DataAssociationDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.IoParametersDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.ManualTaskDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.MultiInstanceLoopCharacteristicsDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.ScriptTaskDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.StandardLoopCharacteristicsDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.TaskDetailComposite;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorOutlinePage;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorSelectionSynchronizer;
import org.eclipse.bpmn2.modeler.ui.wizards.BPMN2DiagramCreator;
import org.eclipse.bpmn2.modeler.ui.wizards.FileService;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.GFPaletteRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class BPMN2Editor
extends DiagramEditor
implements IEclipsePreferences.IPreferenceChangeListener,
IGotoMarker {
    public static final String EDITOR_ID = "org.eclipse.bpmn2.modeler.ui.bpmn2editor";
    public static final String CONTRIBUTOR_ID = "org.eclipse.bpmn2.modeler.ui.PropertyContributor";
    private ModelHandler modelHandler;
    private URI modelUri;
    private URI diagramUri;
    private boolean editable = true;
    protected BPMNDiagram bpmnDiagram;
    protected Bpmn2ResourceImpl bpmnResource;
    private IWorkbenchListener workbenchListener;
    private IPartListener2 selectionListener;
    private IResourceChangeListener markerChangeListener;
    private boolean workbenchShutdown = false;
    private static BPMN2Editor activeEditor;
    private IEditorInput currentInput;
    private static ITabDescriptorProvider tabDescriptorProvider;
    private BPMN2EditingDomainListener editingDomainListener;
    private Bpmn2Preferences preferences;
    private TargetRuntime targetRuntime;
    private ModelEnablements modelEnablements;
    private boolean importInProgress;
    private BPMN2EditorSelectionSynchronizer synchronizer;
    protected DiagramEditorAdapter editorAdapter;
    protected BPMN2MultiPageEditor multipageEditor;
    protected IPropertySheetPage propertySheetPage;
    protected IContentOutlinePage outlinePage;
    protected boolean saveInProgress = false;
    private static NotificationFilter filterNone;

    static {
        TargetRuntime.getAllRuntimes();
        PropertiesCompositeFactory.register(EObject.class, DefaultDetailComposite.class);
        PropertiesCompositeFactory.register(EObject.class, DefaultListComposite.class);
        PropertiesCompositeFactory.register(EObject.class, DefaultDialogComposite.class);
        PropertiesCompositeFactory.register(Message.class, MessageDetailComposite.class);
        PropertiesCompositeFactory.register(Message.class, MessageListComposite.class);
        PropertiesCompositeFactory.register(MessageFlow.class, MessageFlowDetailComposite.class);
        PropertiesCompositeFactory.register(Property.class, ItemAwareElementDetailComposite.class);
        PropertiesCompositeFactory.register(CallActivity.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(GlobalTask.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(GlobalBusinessRuleTask.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(GlobalManualTask.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(GlobalScriptTask.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(GlobalUserTask.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(Import.class, DefinitionsPropertyComposite.ImportDetailComposite.class);
        PropertiesCompositeFactory.register(Category.class, CategoryDetailComposite.class);
        PropertiesCompositeFactory.register(TextAnnotation.class, TextAnnotationDetailComposite.class);
        PropertiesCompositeFactory.register(SequenceFlow.class, SequenceFlowDetailComposite.class);
        PropertiesCompositeFactory.register(DataObject.class, DataObjectPropertySection.DataObjectDetailComposite.class);
        PropertiesCompositeFactory.register(DataObjectReference.class, DataObjectPropertySection.DataObjectDetailComposite.class);
        PropertiesCompositeFactory.register(Assignment.class, DataAssignmentDetailComposite.class);
        PropertiesCompositeFactory.register(Expression.class, ExpressionDetailComposite.class);
        PropertiesCompositeFactory.register(FormalExpression.class, ExpressionDetailComposite.class);
        PropertiesCompositeFactory.register(ResourceAssignmentExpression.class, ResourceAssignmentExpressionDetailComposite.class);
        PropertiesCompositeFactory.register(ResourceParameterBinding.class, ResourceParameterBindingDetailComposite.class);
        PropertiesCompositeFactory.register(PotentialOwner.class, ResourceRoleDetailComposite.class);
        PropertiesCompositeFactory.register(HumanPerformer.class, ResourceRoleDetailComposite.class);
        PropertiesCompositeFactory.register(Performer.class, ResourceRoleDetailComposite.class);
        PropertiesCompositeFactory.register(DataObjectReference.class, DataObjectReferencePropertySection.DataObjectReferenceDetailComposite.class);
        PropertiesCompositeFactory.register(DataStore.class, DataStorePropertySection.DataStoreDetailComposite.class);
        PropertiesCompositeFactory.register(DataStoreReference.class, DataStoreReferencePropertySection.DataStoreReferenceDetailComposite.class);
        PropertiesCompositeFactory.register(Interface.class, InterfaceDetailComposite.class);
        PropertiesCompositeFactory.register(Operation.class, OperationDetailComposite.class);
        PropertiesCompositeFactory.register(ItemDefinition.class, ItemDefinitionDetailComposite.class);
        PropertiesCompositeFactory.register(ItemDefinition.class, ItemDefinitionListComposite.class);
        PropertiesCompositeFactory.register(Property.class, PropertyListComposite.class);
        PropertiesCompositeFactory.register(ResourceRole.class, ResourceRoleListComposite.class);
        PropertiesCompositeFactory.register(Event.class, CommonEventDetailComposite.class);
        PropertiesCompositeFactory.register(StartEvent.class, StartEventDetailComposite.class);
        PropertiesCompositeFactory.register(EndEvent.class, EndEventDetailComposite.class);
        PropertiesCompositeFactory.register(CatchEvent.class, CatchEventDetailComposite.class);
        PropertiesCompositeFactory.register(ThrowEvent.class, ThrowEventDetailComposite.class);
        PropertiesCompositeFactory.register(BoundaryEvent.class, BoundaryEventDetailComposite.class);
        PropertiesCompositeFactory.register(TimerEventDefinition.class, TimerEventDefinitionDetailComposite.class);
        PropertiesCompositeFactory.register(ConditionalEventDefinition.class, ConditionalEventDefinitionDetailComposite.class);
        PropertiesCompositeFactory.register(CompensateEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(ConditionalEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(ErrorEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(EscalationEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(LinkEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(MessageEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(SignalEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(TimerEventDefinition.class, CommonEventPropertySection.EventDefinitionDialogComposite.class);
        PropertiesCompositeFactory.register(Process.class, ProcessDiagramDetailComposite.class);
        PropertiesCompositeFactory.register(EndEvent.class, EndEventDetailComposite.class);
        PropertiesCompositeFactory.register(StartEvent.class, StartEventDetailComposite.class);
        PropertiesCompositeFactory.register(ThrowEvent.class, ThrowEventDetailComposite.class);
        PropertiesCompositeFactory.register(StandardLoopCharacteristics.class, StandardLoopCharacteristicsDetailComposite.class);
        PropertiesCompositeFactory.register(MultiInstanceLoopCharacteristics.class, MultiInstanceLoopCharacteristicsDetailComposite.class);
        PropertiesCompositeFactory.register(Gateway.class, GatewayDetailComposite.class);
        PropertiesCompositeFactory.register(Activity.class, ActivityInputDetailComposite.class);
        PropertiesCompositeFactory.register(InputOutputSpecification.class, ActivityInputDetailComposite.class);
        PropertiesCompositeFactory.register(Activity.class, ActivityOutputDetailComposite.class);
        PropertiesCompositeFactory.register(CallChoreography.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(InputOutputSpecification.class, IoParametersDetailComposite.class);
        PropertiesCompositeFactory.register(DataInput.class, DataAssociationDetailComposite.class);
        PropertiesCompositeFactory.register(DataOutput.class, DataAssociationDetailComposite.class);
        PropertiesCompositeFactory.register(ManualTask.class, ManualTaskDetailComposite.class);
        PropertiesCompositeFactory.register(ScriptTask.class, ScriptTaskDetailComposite.class);
        PropertiesCompositeFactory.register(SubProcess.class, ActivityDetailComposite.class);
        PropertiesCompositeFactory.register(Task.class, TaskDetailComposite.class);
        filterNone = new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                return false;
            }
        };
    }

    public BPMN2Editor(BPMN2MultiPageEditor mpe) {
        this.multipageEditor = mpe;
    }

    public static BPMN2Editor getActiveEditor() {
        return activeEditor;
    }

    public IEditorInput getCurrentInput() {
        return this.currentInput;
    }

    private void setActiveEditor(BPMN2Editor editor) {
        activeEditor = editor;
        if (activeEditor != null) {
            Bpmn2Preferences.setActiveProject((IProject)activeEditor.getProject());
            TargetRuntime.setCurrentRuntime((TargetRuntime)activeEditor.getTargetRuntime());
        }
    }

    public BPMN2MultiPageEditor getMultipageEditor() {
        return this.multipageEditor;
    }

    protected DiagramEditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setActiveEditor(this);
        this.currentInput = input;
        if (this.getDiagramBehavior() == null) {
            super.init(site, input);
            this.addWorkbenchListener();
            this.addSelectionListener();
            this.addMarkerChangeListener();
        } else if (input instanceof Bpmn2DiagramEditorInput) {
            this.bpmnDiagram = ((Bpmn2DiagramEditorInput)input).getBpmnDiagram();
            if (this.bpmnDiagram != null) {
                this.setBpmnDiagram(this.bpmnDiagram);
            }
        }
    }

    private Bpmn2DiagramEditorInput createNewDiagramEditorInput(IEditorInput input, ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace) throws PartInitException {
        this.modelUri = FileService.getInputUri(input);
        if (this.modelUri == null) {
            throw new PartInitException(Messages.BPMN2Editor_Cannot_Create_Editor_Input);
        }
        input = BPMN2DiagramCreator.createDiagram(input, this.modelUri, diagramType, targetNamespace, this);
        this.diagramUri = ((Bpmn2DiagramEditorInput)((Object)input)).getUri();
        return (Bpmn2DiagramEditorInput)((Object)input);
    }

    private void saveModelFile() {
        try {
            this.bpmnResource.save(null);
            ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
            this.updateDirtyState();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setInput(IEditorInput input) {
        try {
            if (input instanceof Bpmn2DiagramEditorInput) {
                ModelUtil.Bpmn2DiagramType diagramType = ModelUtil.Bpmn2DiagramType.NONE;
                String targetNamespace = null;
                diagramType = ((Bpmn2DiagramEditorInput)((Object)input)).getInitialDiagramType();
                targetNamespace = ((Bpmn2DiagramEditorInput)((Object)input)).getTargetNamespace();
                input = this.createNewDiagramEditorInput((IEditorInput)input, diagramType, targetNamespace);
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        this.currentInput = input;
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)this, input);
        TargetRuntime targetRuntime = this.getTargetRuntime((IEditorInput)input);
        ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
        resourceSet.setURIConverter((URIConverter)new ProxyURIConverterImplExtension(this.modelUri));
        this.editorAdapter = new DiagramEditorAdapter((DiagramEditor)this);
        resourceSet.eAdapters().add((Object)this.editorAdapter);
        targetRuntime.setResourceSet(resourceSet);
        this.bpmnResource = otherEditor == null ? (Bpmn2ResourceImpl)resourceSet.createResource(this.modelUri, "org.eclipse.bpmn2.content-type.xml") : otherEditor.bpmnResource;
        super.setInput(input);
        this.getEditingDomainListener();
        this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)this.bpmnResource);
        ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
        this.setActiveEditor(this);
        this.getTargetRuntime().getRuntimeExtension().initialize((DiagramEditor)this);
        if (otherEditor == null) {
            BasicCommandStack commandStack = (BasicCommandStack)this.getEditingDomain().getCommandStack();
            commandStack.execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    BPMN2Editor.this.importDiagram();
                }
            });
            Definitions definitions = ModelUtil.getDefinitions((Resource)this.bpmnResource);
            if (definitions != null) {
                ((Bpmn2DiagramEditorInput)((Object)input)).setTargetNamespace(definitions.getTargetNamespace());
                ((Bpmn2DiagramEditorInput)((Object)input)).setInitialDiagramType(ModelUtil.getDiagramType((DiagramEditor)this));
            }
            commandStack.saveIsDone();
            commandStack.flush();
        }
        this.getTargetRuntime().setResource((Bpmn2Resource)this.bpmnResource);
        this.loadMarkers();
    }

    protected DiagramEditorInput convertToDiagramEditorInput(IEditorInput input) throws PartInitException {
        Bpmn2DiagramEditorInput newInput = this.createNewDiagramEditorInput(input, ModelUtil.Bpmn2DiagramType.NONE, "");
        if (newInput == null) {
            newInput = super.convertToDiagramEditorInput(input);
        }
        return newInput;
    }

    private void importDiagram() {
        try {
            this.importInProgress = true;
            Diagram diagram = this.getDiagramTypeProvider().getDiagram();
            IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
            diagram.setActive(true);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            ModelUtil.Bpmn2DiagramType diagramType = input.getInitialDiagramType();
            String targetNamespace = input.getTargetNamespace();
            if (diagramType != ModelUtil.Bpmn2DiagramType.NONE) {
                this.bpmnDiagram = this.modelHandler.createDiagramType(diagramType, targetNamespace);
                featureProvider.link((PictogramElement)diagram, (Object)this.bpmnDiagram);
                this.saveModelFile();
            }
            DIImport di = new DIImport((DiagramEditor)this);
            di.setModelHandler(this.modelHandler);
            di.generateFromDI();
        }
        finally {
            this.importInProgress = false;
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDirty() {
        if (!this.editable) {
            return false;
        }
        return super.isDirty();
    }

    protected DiagramBehavior createDiagramBehavior() {
        BPMN2EditorDiagramBehavior diagramBehavior = new BPMN2EditorDiagramBehavior(this);
        return diagramBehavior;
    }

    public Bpmn2Preferences getPreferences() {
        if (this.preferences == null) {
            this.loadPreferences(this.getProject());
        }
        return this.preferences;
    }

    private void loadPreferences(IProject project) {
        this.preferences = Bpmn2Preferences.getInstance((IProject)project);
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public String getContributorId() {
        return CONTRIBUTOR_ID;
    }

    public TargetRuntime getTargetRuntime(ITabDescriptorProvider tdp) {
        tabDescriptorProvider = tdp;
        return this.getTargetRuntime();
    }

    public TargetRuntime getTargetRuntime() {
        if (this.targetRuntime == null) {
            this.targetRuntime = this.getTargetRuntime(this.getEditorInput());
        }
        return this.targetRuntime;
    }

    public ModelEnablements getModelEnablements() {
        ModelUtil.Bpmn2DiagramType diagramType = ModelUtil.getDiagramType((BPMNDiagram)this.bpmnDiagram);
        String profile = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime(), diagramType);
        if (!(this.modelEnablements == null || this.modelEnablements.getProfile().equals(profile) && this.modelEnablements.getDiagramType().equals((Object)diagramType))) {
            this.modelEnablements = null;
        }
        if (this.modelEnablements == null) {
            this.modelEnablements = this.getPreferences().getModelEnablements(this.getTargetRuntime(), diagramType, profile);
            if (this.modelEnablements.size() == 0) {
                profile = this.getPreferences().getDefaultToolProfile(TargetRuntime.getDefaultRuntime(), diagramType);
                ModelEnablements defaultEnablements = this.getPreferences().getModelEnablements(TargetRuntime.getDefaultRuntime(), diagramType, profile);
                this.modelEnablements.copy(defaultEnablements);
            }
        }
        return this.modelEnablements;
    }

    protected TargetRuntime getTargetRuntime(IEditorInput input) {
        if (this.targetRuntime == null && input != null) {
            this.targetRuntime = this.getPreferences().getRuntime();
            if (this.targetRuntime == TargetRuntime.getDefaultRuntime()) {
                TargetRuntime[] targetRuntimeArray = TargetRuntime.getAllRuntimes();
                int n = targetRuntimeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TargetRuntime rt = targetRuntimeArray[n2];
                    if (rt.getRuntimeExtension().isContentForRuntime(input)) {
                        this.targetRuntime = rt;
                        break;
                    }
                    ++n2;
                }
            }
            if (this.targetRuntime == null) {
                this.targetRuntime = TargetRuntime.getDefaultRuntime();
            }
            TargetRuntime.setCurrentRuntime((TargetRuntime)this.targetRuntime);
        }
        return this.targetRuntime;
    }

    public void updatePalette() {
        GFPaletteRoot pr = (GFPaletteRoot)this.getPaletteRoot();
        if (pr != null) {
            this.modelEnablements = null;
            pr.updatePaletteEntries();
            BPMNToolBehaviorProvider toolBehaviorProvider = (BPMNToolBehaviorProvider)this.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            toolBehaviorProvider.createPaletteProfilesGroup(this, (PaletteRoot)pr);
        }
    }

    private void addWorkbenchListener() {
        if (this.workbenchListener == null) {
            this.workbenchListener = new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    BPMN2Editor.this.workbenchShutdown = true;
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            };
            PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
        }
    }

    public void gotoMarker(IMarker marker) {
        EObject target = this.getTargetObject(marker);
        if (target == null) {
            return;
        }
        PictogramElement pe = this.getDiagramTypeProvider().getFeatureProvider().getPictogramElementForBusinessObject((Object)target);
        if (pe == null) {
            return;
        }
        this.selectPictogramElements(new PictogramElement[]{pe});
    }

    private void loadMarkers() {
        if (this.getModelFile() != null) {
            BPMN2ValidationStatusLoader vsl = new BPMN2ValidationStatusLoader((DiagramEditor)this);
            try {
                vsl.load(Arrays.asList(this.getModelFile().findMarkers(null, true, 0)));
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
        }
    }

    private EObject getTargetObject(IMarker marker) {
        URI uri;
        String uriString = marker.getAttribute("uri", null);
        URI uRI = uri = uriString == null ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return null;
        }
        return this.getEditingDomain().getResourceSet().getEObject(uri, false);
    }

    private void removeWorkbenchListener() {
        if (this.workbenchListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            this.workbenchListener = null;
        }
    }

    private void addSelectionListener() {
        if (this.selectionListener == null) {
            IWorkbenchPage page = this.getSite().getPage();
            this.selectionListener = new IPartListener2(){

                public void partActivated(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof BPMN2MultiPageEditor) {
                        BPMN2MultiPageEditor mpe = (BPMN2MultiPageEditor)part;
                        BPMN2Editor.this.setActiveEditor((BPMN2Editor)mpe.getDesignEditor());
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }
            };
            page.addPartListener(this.selectionListener);
        }
    }

    private void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getSite().getPage().removePartListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    private void addMarkerChangeListener() {
        if (this.getModelFile() != null && this.markerChangeListener == null) {
            this.markerChangeListener = new BPMN2MarkerChangeListener(this);
            this.getModelFile().getWorkspace().addResourceChangeListener(this.markerChangeListener, 16);
        }
    }

    private void removeMarkerChangeListener() {
        if (this.markerChangeListener != null) {
            this.getModelFile().getWorkspace().removeResourceChangeListener(this.markerChangeListener);
            this.markerChangeListener = null;
        }
    }

    public void refreshTitle() {
        String name = this.getEditorInput().getName();
        this.setPartName(URI.decode((String)name));
    }

    public BPMN2EditingDomainListener getEditingDomainListener() {
        if (this.editingDomainListener == null) {
            TransactionalEditingDomainImpl editingDomain = (TransactionalEditingDomainImpl)this.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            this.editingDomainListener = new BPMN2EditingDomainListener(this);
            TransactionalEditingDomain.Lifecycle domainLifeCycle = (TransactionalEditingDomain.Lifecycle)editingDomain.getAdapter(TransactionalEditingDomain.Lifecycle.class);
            domainLifeCycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this.editingDomainListener);
        }
        return this.editingDomainListener;
    }

    public BasicDiagnostic getDiagnostics() {
        return this.getEditingDomainListener().getDiagnostics();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new BPMN2EditorSelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public Object getAdapter(Class required) {
        if (required == ITabDescriptorProvider.class) {
            if (tabDescriptorProvider == null) {
                IWorkbenchPage page = this.getEditorSite().getPage();
                String viewID = "org.eclipse.ui.views.PropertySheet";
                try {
                    page.showView(viewID, null, 3);
                    page.showView(viewID, null, 1);
                }
                catch (Exception exception) {}
            }
            return tabDescriptorProvider;
        }
        if (required == TargetRuntime.class) {
            return this.getTargetRuntime();
        }
        if (required == Bpmn2Preferences.class) {
            return this.getPreferences();
        }
        if (required == IPropertySheetPage.class) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new Bpmn2TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.propertySheetPage;
        }
        if (required == SelectionSynchronizer.class) {
            return this.getSelectionSynchronizer();
        }
        if (required == IContentOutlinePage.class && this.getDiagramTypeProvider() != null) {
            if (this.outlinePage == null) {
                this.outlinePage = new BPMN2EditorOutlinePage(this);
            }
            return this.outlinePage;
        }
        if (required == StructuredTextEditor.class && this.multipageEditor.getActiveEditor() == this.multipageEditor.getSourceViewer()) {
            return this.multipageEditor.getSourceViewer();
        }
        if (required == ModelEnablements.class) {
            return this.getModelEnablements();
        }
        if (required == ToolPaletteDescriptor.class) {
            ModelUtil.Bpmn2DiagramType diagramType = ModelUtil.getDiagramType((BPMNDiagram)this.bpmnDiagram);
            String profile = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime(), diagramType);
            return this.getTargetRuntime().getToolPalette(diagramType, profile);
        }
        if (required == NotificationFilter.class) {
            if (this.saveInProgress) {
                return filterNone;
            }
            return null;
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        File diagramFile;
        IWorkbenchPage[] pages;
        int instances = 0;
        IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] refs;
            IWorkbenchPage p = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = refs = p.findEditors(null, EDITOR_ID, 2);
            int n3 = refs.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference r = iEditorReferenceArray[n4];
                if (r.getEditor(false) instanceof BPMN2MultiPageEditor && ((BPMN2MultiPageEditor)r.getEditor((boolean)false)).designEditor != this) {
                    ++instances;
                }
                ++n4;
            }
            ++n2;
        }
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)this, this.getEditorInput());
        if (otherEditor == null && (diagramFile = new File(this.diagramUri.toFileString())).exists()) {
            try {
                diagramFile.delete();
            }
            catch (Exception exception) {}
        }
        if (this.modelHandler != null) {
            ModelUtil.clearIDs((Resource)this.modelHandler.getResource(), (instances == 0 ? 1 : 0) != 0);
        }
        this.getPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        this.getResourceSet().eAdapters().remove((Object)this.getEditorAdapter());
        this.removeSelectionListener();
        if (instances == 0) {
            this.setActiveEditor(null);
        }
        super.dispose();
        ModelHandlerLocator.remove((URI)this.modelUri);
        if (!this.workbenchShutdown && FileService.isTempFile(this.modelUri)) {
            FileService.deleteTempFile(this.modelUri);
        }
        this.removeWorkbenchListener();
        this.removeMarkerChangeListener();
        this.getPreferences().dispose();
    }

    public IPath getModelPath() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getFullPath();
        }
        return null;
    }

    public IProject getProject() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getProject();
        }
        return null;
    }

    public IFile getModelFile() {
        String uriString;
        if (this.modelUri != null && (uriString = this.modelUri.trimFragment().toPlatformString(true)) != null) {
            Path fullPath = new Path(uriString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
        }
        return null;
    }

    public URI getModelUri() {
        return this.modelUri;
    }

    public URI getDiagramUri() {
        return this.diagramUri;
    }

    public ModelHandler getModelHandler() {
        return this.modelHandler;
    }

    public Resource getResource() {
        return this.bpmnResource;
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public void refresh() {
        if (!this.importInProgress) {
            this.getDiagramBehavior().getRefreshBehavior().refresh();
        }
    }

    public void createPartControl(Composite parent) {
        if (this.getGraphicalViewer() == null) {
            super.createPartControl(parent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpmn2.modeler.help.TOC");
        }
    }

    public BPMNDiagram getBpmnDiagram() {
        Definitions definitions;
        if (this.bpmnDiagram == null && (definitions = ModelUtil.getDefinitions((Resource)this.bpmnResource)) != null && definitions.getDiagrams().size() > 0) {
            this.bpmnDiagram = (BPMNDiagram)definitions.getDiagrams().get(0);
        }
        return this.bpmnDiagram;
    }

    public void setBpmnDiagram(BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
        this.selectPictogramElements(new PictogramElement[0]);
        this.getDiagramTypeProvider().resourceReloaded(diagram);
        this.getDiagramBehavior().getRefreshBehavior().initRefresh();
        this.setPictogramElementsForSelection(null);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)diagram);
        EditPart ep = viewer.getRootEditPart().getContents();
        if (ep instanceof AbstractGraphicalEditPart) {
            IFigure fig = ((AbstractGraphicalEditPart)ep).getFigure();
            fig.setBorder((Border)new MarginBorder(50));
        }
        ConnectionLayerClippingStrategy.applyTo(this.getGraphicalViewer());
        this.getDiagramBehavior().refreshContent();
        this.bpmnDiagram = bpmnDiagram;
        this.modelEnablements = null;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveInProgress = true;
            super.doSave(monitor);
        }
        finally {
            this.saveInProgress = false;
        }
        Resource resource = this.getResourceSet().getResource(this.modelUri, false);
        BPMN2ProjectValidator.validateOnSave((Resource)resource, (IProgressMonitor)monitor);
    }

    public boolean isSaveAsAllowed() {
        return this.getModelFile() != null;
    }

    public void doSaveAs() {
        IFile oldFile = this.getModelFile();
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(oldFile);
        saveAsDialog.create();
        if (saveAsDialog.open() == 1) {
            return;
        }
        IPath newFilePath = saveAsDialog.getResult();
        if (newFilePath == null) {
            return;
        }
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
        IWorkbenchPage page = this.getSite().getPage();
        try {
            if (newFile.exists()) {
                IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)page, (IFile)newFile);
                if (editorPart != null) {
                    page.closeEditor(editorPart, false);
                }
                newFile.delete(true, null);
            }
            oldFile.copy(newFilePath, true, null);
        }
        catch (CoreException e) {
            this.showErrorDialogWithLogging((Exception)((Object)e));
            return;
        }
        URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
        this.handleResourceMoved((Resource)this.bpmnResource, newURI);
        this.doSave(null);
    }

    public void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean closed = BPMN2Editor.this.getSite().getPage().closeEditor((IEditorPart)BPMN2Editor.this, false);
                if (!closed) {
                    IFile oldFile = ResourcesPlugin.getWorkspace().getRoot().getFile(BPMN2Editor.this.getModelPath());
                    IEditorPart editorPart = ResourceUtil.findEditor((IWorkbenchPage)BPMN2Editor.this.getSite().getPage(), (IFile)oldFile);
                    closed = BPMN2Editor.this.getSite().getPage().closeEditor(editorPart, false);
                }
            }
        });
    }

    private void showErrorDialogWithLogging(Exception e) {
        Status status = new Status(4, "org.eclipse.bpmn2.modeler.ui", e.getMessage(), (Throwable)e);
        ErrorUtils.showErrorWithLogging((IStatus)status);
    }

    public boolean handleResourceChanged(Resource resource) {
        URI newURI;
        if (resource == this.bpmnResource && !this.modelUri.equals(newURI = resource.getURI())) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            this.modelUri = newURI;
            if (this.preferences != null) {
                this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                this.preferences.dispose();
                this.preferences = null;
            }
            this.targetRuntime = null;
            this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            input.updateUri(newURI);
            this.multipageEditor.setInput((IEditorInput)input);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BPMN2Editor.this.updateDirtyState();
                BPMN2Editor.this.refreshTitle();
            }
        });
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        this.closeEditor();
        return true;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        URI oldURI = resource.getURI();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            for (EReference r : o.eClass().getEAllReferences()) {
                o.eGet((EStructuralFeature)r);
            }
        }
        resource.setURI(newURI);
        if (resource == this.bpmnResource) {
            ModelHandlerLocator.remove((URI)this.modelUri);
            this.modelUri = newURI;
            if (this.preferences != null) {
                this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                this.preferences.dispose();
                this.preferences = null;
            }
            this.targetRuntime = null;
            this.modelHandler = ModelHandlerLocator.createModelHandler((URI)this.modelUri, (Bpmn2ResourceImpl)((Bpmn2ResourceImpl)resource));
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            input.updateUri(newURI);
            this.multipageEditor.setInput((IEditorInput)input);
            this.handleResourceChanged(resource);
        } else if (this.diagramUri.equals(oldURI)) {
            ModelHandlerLocator.remove((URI)this.diagramUri);
            this.diagramUri = newURI;
            ModelHandlerLocator.put((URI)this.diagramUri, (ModelHandler)this.modelHandler);
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
        final ArrayList<ContainerShape> moved = new ArrayList<ContainerShape>();
        PictogramElement[] pictogramElementArray = this.getSelectedPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseElement baseElement;
            int size;
            ContainerShape shape;
            ContainerShape container;
            PictogramElement pe = pictogramElementArray[n2];
            if (pe instanceof ContainerShape && !(pe instanceof Diagram) && (container = (shape = (ContainerShape)pe).getContainer()) != null && (size = container.getChildren().size()) > 1 && !((baseElement = BusinessObjectUtil.getFirstBaseElement((PictogramElement)shape)) instanceof Participant) && !(baseElement instanceof Lane)) {
                boolean obscured = false;
                int index = container.getChildren().indexOf((Object)shape);
                int i = index + 1;
                while (i < container.getChildren().size()) {
                    PictogramElement sibling = (PictogramElement)container.getChildren().get(i);
                    if (sibling instanceof ContainerShape && !FeatureSupport.isLabelShape((Shape)((ContainerShape)sibling)) && GraphicsUtil.intersects((Shape)shape, (Shape)((ContainerShape)sibling))) {
                        boolean siblingIsBoundaryEvent = false;
                        if (baseElement instanceof Activity) {
                            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)sibling);
                            for (BoundaryEvent boundaryEvent : ((Activity)baseElement).getBoundaryEventRefs()) {
                                if (be != boundaryEvent) continue;
                                siblingIsBoundaryEvent = true;
                                break;
                            }
                        }
                        if (!siblingIsBoundaryEvent) {
                            obscured = true;
                        }
                    }
                    ++i;
                }
                if (baseElement instanceof Activity) {
                    for (BoundaryEvent be : ((Activity)baseElement).getBoundaryEventRefs()) {
                        for (PictogramElement child : container.getChildren()) {
                            if (!(child instanceof ContainerShape) || BusinessObjectUtil.getFirstBaseElement((PictogramElement)child) != be) continue;
                            index = container.getChildren().indexOf((Object)child);
                            int i2 = index + 1;
                            while (i2 < container.getChildren().size()) {
                                PictogramElement sibling = (PictogramElement)container.getChildren().get(i2);
                                if (sibling != shape && sibling instanceof ContainerShape && GraphicsUtil.intersects((Shape)((ContainerShape)child), (Shape)((ContainerShape)sibling))) {
                                    obscured = true;
                                    moved.add((ContainerShape)child);
                                }
                                ++i2;
                            }
                        }
                    }
                }
                if (obscured) {
                    moved.add(0, shape);
                }
            }
            ++n2;
        }
        if (!moved.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BPMN2Editor.this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(BPMN2Editor.this.getEditingDomain()){

                        protected void doExecute() {
                            for (ContainerShape child : moved) {
                                GraphicsUtil.sendToFront((Shape)child);
                            }
                        }
                    });
                }
            });
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.getPreferences().reload();
        if (event.getKey().contains("/model.enablement/")) {
            this.modelEnablements = null;
        }
        if (event.getKey().contains("show.advanced.properties") && tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        if (event.getKey().contains("/shape.style/")) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    IFeatureProvider fp = BPMN2Editor.this.getDiagramTypeProvider().getFeatureProvider();
                    IPeService peService = Graphiti.getPeService();
                    TreeIterator iter = BPMN2Editor.this.getDiagramTypeProvider().getDiagram().eAllContents();
                    while (iter.hasNext()) {
                        UpdateContext context;
                        IUpdateFeature feature;
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof PictogramElement)) continue;
                        PictogramElement pe = (PictogramElement)o;
                        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
                        if (be != null) {
                            TreeIterator childIter = pe.eAllContents();
                            while (childIter.hasNext()) {
                                GraphicsAlgorithm ga;
                                o = (EObject)childIter.next();
                                if (!(o instanceof GraphicsAlgorithm) || peService.getPropertyValue((PropertyContainer)(ga = (GraphicsAlgorithm)o), "shape.style") == null) continue;
                                StyleUtil.applyStyle((GraphicsAlgorithm)ga, (BaseElement)be);
                            }
                        }
                        if (!(pe instanceof Shape) || !FeatureSupport.isLabelShape((Shape)((Shape)pe)) || (feature = fp.getUpdateFeature((IUpdateContext)(context = new UpdateContext(pe)))) == null) continue;
                        feature.update((IUpdateContext)context);
                    }
                }
            });
        }
    }

    public static BPMN2Editor findOpenEditor(IEditorPart newEditor, IEditorInput newInput) {
        if (newEditor != null && newInput != null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference[] otherEditors;
                IWorkbenchPage page = iWorkbenchPageArray[n2];
                IEditorReference[] iEditorReferenceArray = otherEditors = page.findEditors(newInput, null, 1);
                int n3 = otherEditors.length;
                int n4 = 0;
                while (n4 < n3) {
                    BPMN2Editor otherEditor;
                    IEditorReference ref = iEditorReferenceArray[n4];
                    IEditorPart part = ref.getEditor(true);
                    if (part instanceof BPMN2MultiPageEditor ? (otherEditor = ((BPMN2MultiPageEditor)part).getDesignEditor()) != newEditor : part instanceof BPMN2Editor && (otherEditor = (BPMN2Editor)part) != newEditor) {
                        return otherEditor;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IEditorPart openEditor(URI modelURI) {
        IEditorPart part = null;
        try {
            Bpmn2DiagramEditorInput input = BPMN2DiagramCreator.createDiagram(modelURI, ModelUtil.Bpmn2DiagramType.NONE, "");
            part = BPMN2DiagramCreator.openEditor(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return part;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }
}

