/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.commands;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.commands.Messages;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class CreateDiagramCommand
extends AbstractHandler {
    public static final String ID_CREATE_PROCESS = "org.eclipse.bpmn2.modeler.command.createProcess";
    public static final String ID_CREATE_CHOREOGRAPHY = "org.eclipse.bpmn2.modeler.command.createChoreography";
    public static final String ID_CREATE_COLLABORATION = "org.eclipse.bpmn2.modeler.command.createCollaboration";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext ctx = (IEvaluationContext)event.getApplicationContext();
        Object var = ctx.getDefaultVariable();
        BPMN2Editor editor = BPMN2Editor.getActiveEditor();
        if (var instanceof List) {
            for (Object e : (List)var) {
                if (e instanceof EditPart) break;
            }
        }
        NewDiagramNameDialog dlg = null;
        final String id = event.getCommand().getId();
        if (ID_CREATE_PROCESS.equals(id)) {
            dlg = new NewDiagramNameDialog(editor, Messages.CreateDiagramCommand_Process);
        } else if (ID_CREATE_CHOREOGRAPHY.equals(id)) {
            dlg = new NewDiagramNameDialog(editor, Messages.CreateDiagramCommand_Choreography);
        } else if (ID_CREATE_COLLABORATION.equals(id)) {
            dlg = new NewDiagramNameDialog(editor, Messages.CreateDiagramCommand_Collaboration);
        }
        if (dlg != null && dlg.open() == 0) {
            TransactionalEditingDomain domain = editor.getEditingDomain();
            final Definitions definitions = ModelUtil.getDefinitions((EObject)editor.getBpmnDiagram());
            final String name = dlg.getValue();
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    Class<Process> clazz = null;
                    if (CreateDiagramCommand.ID_CREATE_PROCESS.equals(id)) {
                        clazz = Process.class;
                    } else if (CreateDiagramCommand.ID_CREATE_CHOREOGRAPHY.equals(id)) {
                        clazz = Choreography.class;
                    } else if (CreateDiagramCommand.ID_CREATE_COLLABORATION.equals(id)) {
                        clazz = Collaboration.class;
                    }
                    RootElement bpmnElement = (RootElement)Bpmn2ModelerFactory.create(clazz);
                    EStructuralFeature f = bpmnElement.eClass().getEStructuralFeature("name");
                    bpmnElement.eSet(f, (Object)name);
                    definitions.getRootElements().add(bpmnElement);
                    BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                    plane.setBpmnElement((BaseElement)bpmnElement);
                    BPMNDiagram diagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
                    diagram.setPlane(plane);
                    diagram.setName(name);
                    definitions.getDiagrams().add(diagram);
                    ModelUtil.setID((EObject)bpmnElement);
                    ModelUtil.setID((EObject)plane);
                    ModelUtil.setID((EObject)diagram);
                }
            });
        }
        return null;
    }

    private static class NewDiagramNameDialog
    extends InputDialog {
        public NewDiagramNameDialog(final BPMN2Editor editor, final String type) {
            super(editor.getSite().getShell(), NLS.bind((String)Messages.CreateDiagramCommand_Title, (Object)type), NLS.bind((String)Messages.CreateDiagramCommand_Message, (Object)type), "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.CreateDiagramCommand_Invalid_Empty;
                    }
                    for (RootElement re : NewDiagramNameDialog.getDefinitions(editor).getRootElements()) {
                        String name = null;
                        if (re instanceof Process) {
                            name = ((Process)re).getName();
                        } else if (re instanceof Collaboration) {
                            name = ((Collaboration)re).getName();
                        } else if (re instanceof Choreography) {
                            name = ((Choreography)re).getName();
                        }
                        if (!newText.equals(name)) continue;
                        return NLS.bind((String)Messages.CreateDiagramCommand_Invalid_Duplicate, (Object)type);
                    }
                    return null;
                }
            });
        }

        public static Definitions getDefinitions(BPMN2Editor editor) {
            return ModelUtil.getDefinitions((EObject)editor.getBpmnDiagram());
        }
    }
}

