/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.MessageRefFeatureDescriptor;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.OperationRefFeatureDescriptor;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.TaskPropertiesAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class SendTaskPropertiesAdapter
extends TaskPropertiesAdapter<SendTask> {
    public SendTaskPropertiesAdapter(AdapterFactory adapterFactory, SendTask object) {
        super(adapterFactory, object);
        EReference feature = Bpmn2Package.eINSTANCE.getSendTask_MessageRef();
        this.setProperty((EStructuralFeature)feature, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.can.edit", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)feature, new MessageRefFeatureDescriptor<SendTask>(adapterFactory, object, (EStructuralFeature)feature){

            public void setValue(Object context, Object value) {
                if (value instanceof Message || value == null) {
                    final SendTask object = (SendTask)this.adopt(context);
                    final Message message = (Message)value;
                    TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
                    if (editingDomain == null) {
                        SendTaskPropertiesAdapter.this.setMessageRef(object, message);
                    } else {
                        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                SendTaskPropertiesAdapter.this.setMessageRef(object, message);
                            }
                        });
                    }
                }
            }
        });
        feature = Bpmn2Package.eINSTANCE.getSendTask_OperationRef();
        this.setProperty((EStructuralFeature)feature, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)feature, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)feature, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)feature, new OperationRefFeatureDescriptor<SendTask>(adapterFactory, object, (EStructuralFeature)feature){

            public void setValue(Object context, Object value) {
                if (value instanceof Operation || value == null) {
                    final SendTask object = (SendTask)this.adopt(context);
                    final Operation operation = (Operation)value;
                    TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
                    if (editingDomain == null) {
                        SendTaskPropertiesAdapter.this.setOperationRef(object, operation);
                    } else {
                        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                SendTaskPropertiesAdapter.this.setOperationRef(object, operation);
                            }
                        });
                    }
                }
            }
        });
    }

    private void setMessageRef(SendTask sendTask, Message message) {
        ResourceSet resourceSet = sendTask.eResource().getResourceSet();
        sendTask.setMessageRef(message);
        List shapes = DIUtils.getContainerShapes((ResourceSet)resourceSet, (BaseElement)sendTask);
        for (ContainerShape shape : shapes) {
            for (Anchor a : shape.getAnchors()) {
                for (Connection c : a.getOutgoingConnections()) {
                    BaseElement o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                    if (o instanceof MessageFlow) {
                        ((MessageFlow)o).setMessageRef(message);
                    }
                    if (!((o = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c.getEnd().getParent())) instanceof ReceiveTask)) continue;
                    ((ReceiveTask)o).setMessageRef(message);
                }
            }
        }
    }

    private void setOperationRef(SendTask sendTask, Operation operation) {
        sendTask.setOperationRef(operation);
        Message message = operation == null ? null : operation.getOutMessageRef();
        this.setMessageRef(sendTask, message);
    }
}

