/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OutputSetPropertiesAdapter
extends ExtendedPropertiesAdapter<OutputSet> {
    public OutputSetPropertiesAdapter(AdapterFactory adapterFactory, OutputSet object) {
        super(adapterFactory, (EObject)object);
        EReference f = Bpmn2Package.eINSTANCE.getOutputSet_DataOutputRefs();
        this.setProperty((EStructuralFeature)f, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)f, new DataOutputFeatureDescriptor(adapterFactory, object, (EStructuralFeature)f));
        f = Bpmn2Package.eINSTANCE.getOutputSet_OptionalOutputRefs();
        this.setProperty((EStructuralFeature)f, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)f, new DataOutputFeatureDescriptor(adapterFactory, object, (EStructuralFeature)f));
        f = Bpmn2Package.eINSTANCE.getOutputSet_WhileExecutingOutputRefs();
        this.setProperty((EStructuralFeature)f, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)f, new DataOutputFeatureDescriptor(adapterFactory, object, (EStructuralFeature)f));
        f = Bpmn2Package.eINSTANCE.getOutputSet_InputSetRefs();
        this.setProperty((EStructuralFeature)f, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)f, new InputSetFeatureDescriptor(adapterFactory, object, (EStructuralFeature)f));
    }

    protected class DataOutputFeatureDescriptor
    extends FeatureDescriptor<OutputSet> {
        public DataOutputFeatureDescriptor(AdapterFactory adapterFactory, OutputSet object, EStructuralFeature feature) {
            super(adapterFactory, (EObject)object, feature);
        }

        public Hashtable<String, Object> getChoiceOfValues(Object context) {
            OutputSet outputSet = (OutputSet)this.adopt(context);
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            ArrayList<DataOutput> valid = new ArrayList<DataOutput>();
            if (this.feature == Bpmn2Package.eINSTANCE.getOutputSet_DataOutputRefs()) {
                EObject container = outputSet.eContainer();
                while (container != null) {
                    InputOutputSpecification ioSpec;
                    if (container instanceof CatchEvent) {
                        valid.addAll(((CatchEvent)container).getDataOutputs());
                    } else if (container instanceof SubProcess) {
                        DataOutput o;
                        LoopCharacteristics lc = ((SubProcess)container).getLoopCharacteristics();
                        if (lc instanceof MultiInstanceLoopCharacteristics && (o = ((MultiInstanceLoopCharacteristics)lc).getOutputDataItem()) != null) {
                            valid.add(o);
                        }
                    } else if (container instanceof Activity) {
                        ioSpec = ((Activity)container).getIoSpecification();
                        if (ioSpec != null) {
                            valid.addAll(ioSpec.getDataOutputs());
                        }
                    } else if (container instanceof CallableElement && (ioSpec = ((CallableElement)container).getIoSpecification()) != null) {
                        valid.addAll(ioSpec.getDataOutputs());
                    }
                    container = container.eContainer();
                }
            } else {
                valid.addAll(outputSet.getDataOutputRefs());
            }
            for (DataOutput data : valid) {
                values.put(ModelUtil.getDisplayName((Object)data), data);
            }
            return values;
        }
    }

    protected class InputSetFeatureDescriptor
    extends FeatureDescriptor<OutputSet> {
        public InputSetFeatureDescriptor(AdapterFactory adapterFactory, OutputSet object, EStructuralFeature feature) {
            super(adapterFactory, (EObject)object, feature);
        }

        public Hashtable<String, Object> getChoiceOfValues(Object context) {
            OutputSet outputSet = (OutputSet)this.adopt(context);
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            EObject container = outputSet.eContainer();
            if (container instanceof InputOutputSpecification) {
                InputOutputSpecification ioSpec = (InputOutputSpecification)container;
                for (InputSet is : ioSpec.getInputSets()) {
                    values.put(ModelUtil.getDisplayName((Object)is), is);
                }
            }
            return values;
        }
    }
}

