/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Hashtable;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemDefinitionPropertiesAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ItemDefinitionRefFeatureDescriptor<T extends BaseElement>
extends FeatureDescriptor<T> {
    public ItemDefinitionRefFeatureDescriptor(AdapterFactory adapterFactory, T object, EStructuralFeature feature) {
        super(adapterFactory, object, feature);
        Assert.isTrue((boolean)RootElement.class.isAssignableFrom(feature.getEType().getInstanceClass()));
    }

    public String getLabel(Object context) {
        return ItemDefinitionPropertiesAdapter.getLabel();
    }

    public String getDisplayName(Object context) {
        BaseElement object = (BaseElement)this.adopt(context);
        ItemDefinition itemDefinition = (ItemDefinition)object.eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getDisplayName(itemDefinition);
    }

    public EObject createFeature(Resource resource, Object context, EClass eClass) {
        BaseElement object = (BaseElement)this.adopt(context);
        ItemDefinition itemDefinition = ItemDefinitionPropertiesAdapter.createItemDefinition(object.eResource());
        return itemDefinition;
    }

    public Object getValue(Object context) {
        BaseElement object = (BaseElement)this.adopt(context);
        ItemDefinition itemDefinition = (ItemDefinition)object.eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getStructureRef(itemDefinition);
    }

    public void setValue(final Object context, final Object value) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(this.object);
        if (editingDomain == null) {
            this.internalSetValue(context, value);
        } else {
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    ItemDefinitionRefFeatureDescriptor.this.internalSetValue(context, value);
                }
            });
        }
    }

    private void internalSetValue(Object context, Object value) {
        BaseElement object = (BaseElement)this.adopt(context);
        ItemDefinition itemDefinition = null;
        if (value instanceof ItemDefinition) {
            Definitions defs;
            itemDefinition = (ItemDefinition)value;
            if (itemDefinition.eResource() == null && (defs = ModelUtil.getDefinitions((EObject)object)) != null) {
                itemDefinition = (ItemDefinition)value;
                TransactionalEditingDomain editingDomain = this.getEditingDomain(itemDefinition);
                if (editingDomain == null) {
                    defs.getRootElements().add(itemDefinition);
                } else {
                    final ItemDefinition id = itemDefinition;
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            defs.getRootElements().add(id);
                        }
                    });
                }
            }
            super.setValue((Object)object, (Object)itemDefinition);
        } else if (value == null) {
            super.setValue((Object)object, null);
        }
        Definitions definitions = ModelUtil.getDefinitions((EObject)object);
        if (definitions != null) {
            TreeIterator iter = definitions.eAllContents();
            while (iter.hasNext()) {
                ThrowEvent event;
                Activity activity;
                InputOutputSpecification ioSpec;
                EObject o = (EObject)iter.next();
                if (o instanceof DataInput) {
                    DataInputAssociation dia2;
                    DataInput input = (DataInput)o;
                    if (input.eContainer() instanceof InputOutputSpecification) {
                        ioSpec = (InputOutputSpecification)input.eContainer();
                        if (!(ioSpec.eContainer() instanceof Activity)) continue;
                        activity = (Activity)ioSpec.eContainer();
                        for (DataInputAssociation dia2 : activity.getDataInputAssociations()) {
                            if (dia2.getSourceRef().isEmpty() || dia2.getSourceRef().get(0) != object) continue;
                            input.setItemSubjectRef(itemDefinition);
                        }
                        continue;
                    }
                    if (!(input.eContainer() instanceof ThrowEvent)) continue;
                    event = (ThrowEvent)input.eContainer();
                    dia2 = event.getDataInputAssociation().iterator();
                    while (dia2.hasNext()) {
                        DataInputAssociation dia3 = (DataInputAssociation)dia2.next();
                        if (dia3.getSourceRef().isEmpty() || dia3.getSourceRef().get(0) != object) continue;
                        input.setItemSubjectRef(itemDefinition);
                    }
                    continue;
                }
                if (!(o instanceof DataOutput)) continue;
                DataOutput output = (DataOutput)o;
                if (output.eContainer() instanceof InputOutputSpecification) {
                    ioSpec = (InputOutputSpecification)output.eContainer();
                    if (!(ioSpec.eContainer() instanceof Activity)) continue;
                    activity = (Activity)ioSpec.eContainer();
                    for (DataOutputAssociation doa : activity.getDataOutputAssociations()) {
                        if (doa.getTargetRef() != object) continue;
                        output.setItemSubjectRef(itemDefinition);
                    }
                    continue;
                }
                if (!(output.eContainer() instanceof CatchEvent)) continue;
                event = (CatchEvent)output.eContainer();
                for (DataOutputAssociation doa : event.getDataOutputAssociation()) {
                    if (doa.getTargetRef() != object) continue;
                    output.setItemSubjectRef(itemDefinition);
                }
            }
        }
    }

    public Hashtable<String, Object> getChoiceOfValues(Object context) {
        BaseElement object = (BaseElement)this.adopt(context);
        return ItemDefinitionPropertiesAdapter.getChoiceOfValues((EObject)object);
    }
}

