/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.xsd.XSDElementDeclaration;

public class ItemDefinitionPropertiesAdapter
extends ExtendedPropertiesAdapter<ItemDefinition> {
    public ItemDefinitionPropertiesAdapter(AdapterFactory adapterFactory, ItemDefinition object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef();
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.TRUE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
        this.setFeatureDescriptor((EStructuralFeature)ref, (FeatureDescriptor)new FeatureDescriptor<ItemDefinition>(adapterFactory, object, (EStructuralFeature)ref){

            public String getLabel(Object context) {
                return Messages.ItemDefinitionPropertiesAdapter_Structure;
            }

            public String getDisplayName(Object context) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                String value = ItemDefinitionPropertiesAdapter.getStructureName(itemDefinition);
                value = SyntaxCheckerUtils.fromXMLString((String)value);
                return value;
            }

            public EObject createFeature(Resource resource, Object context, EClass eClass) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                EObject structureRef = ModelUtil.createStringWrapper((String)"");
                itemDefinition.setStructureRef((Object)structureRef);
                return structureRef;
            }

            public Object getValue(Object context) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                Object value = ItemDefinitionPropertiesAdapter.getStructureRef(itemDefinition);
                if (value == null || ModelUtil.isStringWrapper((Object)value) && ModelUtil.getStringWrapperValue((Object)value).isEmpty()) {
                    value = itemDefinition.getId();
                }
                return value;
            }

            public void setValue(Object context, Object value) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                if (value instanceof String) {
                    if (itemDefinition.getStructureRef() == null) {
                        String oldValue = ItemDefinitionPropertiesAdapter.getStructureName(itemDefinition);
                        value = ((String)value).replace(oldValue, "");
                    }
                    value = SyntaxCheckerUtils.toXMLString((String)((String)value));
                    value = ModelUtil.createStringWrapper((String)((String)value));
                }
                super.setValue(context, value);
            }

            public Hashtable<String, Object> getChoiceOfValues(Object context) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                return ItemDefinitionPropertiesAdapter.getChoiceOfValues((EObject)itemDefinition);
            }
        });
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<ItemDefinition>(adapterFactory, object){

            public String getDisplayName(Object context) {
                ItemDefinition itemDefinition = (ItemDefinition)this.adopt(context);
                return ItemDefinitionPropertiesAdapter.getDisplayName(itemDefinition);
            }

            public String getLabel(Object context) {
                return ItemDefinitionPropertiesAdapter.getLabel();
            }

            public ItemDefinition createObject(Resource resource, Object context) {
                ItemDefinition itemDefinition = ItemDefinitionPropertiesAdapter.createItemDefinition(resource);
                return itemDefinition;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemDefinition) {
                    return super.equals(obj);
                }
                if (obj instanceof String) {
                    String otherWrapper = (String)obj;
                    Object thisStructure = ((ItemDefinition)this.object).getStructureRef();
                    if (thisStructure == null) {
                        return otherWrapper.isEmpty();
                    }
                    if (ModelUtil.isStringWrapper((Object)thisStructure)) {
                        String thisWrapper = ModelUtil.getStringWrapperValue((Object)((ItemDefinition)this.object).getStructureRef());
                        return thisWrapper.equals(otherWrapper);
                    }
                }
                return true;
            }
        });
    }

    public static String getLabel() {
        return Messages.ItemDefinitionPropertiesAdapter_Data_Type;
    }

    public static ItemDefinition createItemDefinition(Resource resource) {
        ItemDefinition itemDefinition = Bpmn2ModelerFactory.eINSTANCE.createItemDefinition();
        ModelUtil.setID((EObject)itemDefinition, (Resource)resource);
        Definitions defs = ModelUtil.getDefinitions((Resource)resource);
        if (defs != null) {
            defs.getRootElements().add(itemDefinition);
        }
        return itemDefinition;
    }

    public static String getDisplayName(ItemDefinition itemDefinition) {
        String name = "";
        if (itemDefinition != null) {
            name = ItemDefinitionPropertiesAdapter.getStructureName(itemDefinition);
            if (itemDefinition.isIsCollection()) {
                name = String.valueOf(name) + "[]";
            }
        }
        return name;
    }

    public static String getStructureName(ItemDefinition itemDefinition) {
        Resource resource = ModelUtil.getResource((EObject)itemDefinition);
        String name = "";
        if (itemDefinition != null) {
            Object value = itemDefinition.getStructureRef();
            if (value != null) {
                if (value instanceof XSDElementDeclaration) {
                    XSDElementDeclaration elem = (XSDElementDeclaration)value;
                    name = elem.getQName();
                } else if (value instanceof Message) {
                    Message message = (Message)value;
                    name = NamespaceUtil.normalizeQName((Resource)resource, (QName)message.getQName());
                } else if (ModelUtil.isStringWrapper((Object)value)) {
                    name = ModelUtil.getStringWrapperValue((Object)value);
                }
            }
            if (name == null || name.isEmpty()) {
                name = ModelUtil.generateUndefinedID((String)itemDefinition.getId());
            }
        }
        return name;
    }

    public static Object getStructureRef(ItemDefinition itemDefinition) {
        Object value = null;
        if (itemDefinition != null) {
            value = itemDefinition.getStructureRef();
        }
        if (ModelUtil.isStringWrapper(value) && ModelUtil.getStringWrapperValue((Object)value).isEmpty()) {
            value = null;
        }
        return value;
    }

    public static Hashtable<String, Object> getChoiceOfValues(EObject context) {
        Hashtable<String, Object> choices = new Hashtable<String, Object>();
        if (context != null) {
            Definitions defs = ModelUtil.getDefinitions((EObject)context);
            List itemDefs = ModelUtil.getAllRootElements((Definitions)defs, ItemDefinition.class);
            for (ItemDefinition id : itemDefs) {
                String s = ItemDefinitionPropertiesAdapter.getDisplayName(id);
                if (s == null || s.isEmpty()) {
                    s = id.getId();
                }
                choices.put(s, id);
            }
        }
        return choices;
    }
}

