/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemAwareElementPropertiesAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class DataOutputPropertiesAdapter
extends ItemAwareElementPropertiesAdapter<DataOutput> {
    public DataOutputPropertiesAdapter(AdapterFactory adapterFactory, DataOutput object) {
        super(adapterFactory, object);
        EAttribute f = Bpmn2Package.eINSTANCE.getDataOutput_Name();
        FeatureDescriptor<DataOutput> fd = new FeatureDescriptor<DataOutput>(adapterFactory, object, (EStructuralFeature)f){

            public void setDisplayName(String text) {
                int i = text.lastIndexOf("/");
                if (i >= 0) {
                    text = text.substring(i + 1);
                }
                text = text.trim();
                ((DataOutput)this.object).setName(text);
            }

            public String getChoiceString(Object context) {
                DataOutput dataOutput = (DataOutput)this.adopt(context);
                String text = dataOutput.getName();
                if (text == null || text.isEmpty()) {
                    text = dataOutput.getId();
                }
                if (text != null) {
                    String type;
                    if (dataOutput.isIsCollection()) {
                        text = String.valueOf(text) + "[]";
                    }
                    if ((type = ModelUtil.getDisplayName((Object)dataOutput.getItemSubjectRef())) != null) {
                        text = String.valueOf(text) + " (" + type + ")";
                    }
                }
                return text;
            }
        };
        this.setFeatureDescriptor((EStructuralFeature)f, (FeatureDescriptor)fd);
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<DataOutput>(adapterFactory, object, (FeatureDescriptor)fd){
            private final /* synthetic */ FeatureDescriptor val$fd;
            {
                this.val$fd = featureDescriptor;
                super($anonymous0, (EObject)$anonymous1);
            }

            public void setDisplayName(String text) {
                this.val$fd.setDisplayName(text);
                ModelUtil.setID((EObject)this.object);
            }

            public String getDisplayName(Object context) {
                return this.val$fd.getChoiceString(context);
            }
        });
    }

    public static DataOutput createDataOutput(Resource resource, List<DataOutput> dataOutputs) {
        String base = "output";
        int suffix = 1;
        String name = String.valueOf(base) + suffix;
        while (true) {
            boolean found = false;
            for (DataOutput p : dataOutputs) {
                if (!name.equals(p.getName())) continue;
                found = true;
                break;
            }
            if (!found) break;
            name = String.valueOf(base) + ++suffix;
        }
        DataOutput dataOutput = (DataOutput)Bpmn2ModelerFactory.create((Resource)resource, DataOutput.class);
        dataOutput.setName(name);
        dataOutputs.add(dataOutput);
        return dataOutput;
    }
}

