/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.bpmn2.modeler.ui.features.flow.DataAssociationFeatureContainer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class DataAssociationPropertiesAdapter
extends ExtendedPropertiesAdapter<DataAssociation> {
    public DataAssociationPropertiesAdapter(AdapterFactory adapterFactory, DataAssociation object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(adapterFactory, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
        ref = Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(adapterFactory, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
    }

    public class SourceTargetFeatureDescriptor
    extends FeatureDescriptor<DataAssociation> {
        public SourceTargetFeatureDescriptor(AdapterFactory adapterFactory, DataAssociation object, EStructuralFeature feature) {
            super(adapterFactory, (EObject)object, feature);
        }

        public String getLabel(Object context) {
            EObject object = this.adopt(context);
            if (object instanceof DataInputAssociation) {
                return Messages.DataAssociationPropertiesAdapter_Source;
            }
            return Messages.DataAssociationPropertiesAdapter_Target;
        }

        public Hashtable<String, Object> getChoiceOfValues(Object context) {
            InputOutputSpecification ioSpec;
            CallableElement callable;
            InputOutputSpecification ioSpec2;
            ArrayList values = new ArrayList();
            DataAssociation association = (DataAssociation)this.adopt(context);
            EObject container = ModelUtil.getContainer((EObject)association);
            values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Activity.class}));
            values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Process.class}));
            values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Event.class}));
            values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"dataStore", (Class[])new Class[]{DocumentRoot.class}));
            values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"flowElements", (Class[])new Class[]{FlowElementsContainer.class}, (Class[])new Class[]{ItemAwareElement.class}));
            Activity activity = (Activity)ModelUtil.findNearestAncestor((EObject)container, (Class[])new Class[]{Activity.class});
            if (activity != null && (ioSpec2 = activity.getIoSpecification()) != null) {
                if (association instanceof DataInputAssociation) {
                    values.addAll(ioSpec2.getDataInputs());
                } else {
                    values.addAll(ioSpec2.getDataOutputs());
                }
            }
            if ((callable = (CallableElement)ModelUtil.findNearestAncestor((EObject)container, (Class[])new Class[]{CallableElement.class})) != null && (ioSpec = callable.getIoSpecification()) != null) {
                if (association instanceof DataInputAssociation) {
                    values.addAll(ioSpec.getDataInputs());
                } else {
                    values.addAll(ioSpec.getDataOutputs());
                }
            }
            super.setChoiceOfValues(values);
            return super.getChoiceOfValues(context);
        }

        public EObject createFeature(Resource resource, Object context, EClass eClass) {
            DataAssociation association = (DataAssociation)this.adopt(context);
            if (eClass == null) {
                if (ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Process.class, Event.class}) != null) {
                    eClass = Bpmn2Package.eINSTANCE.getProperty();
                } else if (ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{DocumentRoot.class}) != null) {
                    eClass = Bpmn2Package.eINSTANCE.getDataStore();
                }
            }
            if (eClass != null) {
                return Bpmn2ModelerFactory.create((Resource)resource, (EClass)eClass);
            }
            return null;
        }

        public void setValue(Object context, Object value) {
            final DataAssociation association = (DataAssociation)this.adopt(context);
            EObject container = null;
            EStructuralFeature containerFeature = null;
            if (value instanceof Property) {
                if (((Property)value).eContainer() == null) {
                    container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Activity.class});
                    if (container == null) {
                        container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Event.class});
                    }
                    if (container == null) {
                        container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Process.class});
                    }
                    containerFeature = container.eClass().getEStructuralFeature("properties");
                }
            } else if (value instanceof DataStore) {
                if (((DataStore)value).eContainer() == null) {
                    container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{DocumentRoot.class});
                    containerFeature = container.eClass().getEStructuralFeature("dataStore");
                }
            } else if (value instanceof String) {
                Hashtable<String, Object> choices = this.getChoiceOfValues(this.object);
                Property property = (Property)choices.get(value);
                if (property == null) {
                    DiagramEditor editor = ModelUtil.getEditor((EObject)this.object);
                    ModelEnablements modelEnablement = (ModelEnablements)editor.getAdapter(ModelEnablements.class);
                    container = association;
                    do {
                        if ((container = ModelUtil.findNearestAncestor((EObject)container, (Class[])new Class[]{Activity.class, Event.class, Process.class})) == null) {
                            return;
                        }
                        containerFeature = container.eClass().getEStructuralFeature("properties");
                    } while (!modelEnablement.isEnabled(container.eClass(), containerFeature));
                    containerFeature = container.eClass().getEStructuralFeature("properties");
                    property = (Property)Bpmn2ModelerFactory.create(Property.class);
                    ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((Object)property);
                    adapter.getObjectDescriptor().setDisplayName((String)value);
                }
                value = property;
            }
            final EObject c = container;
            final EStructuralFeature cf = containerFeature;
            final ItemAwareElement v = (ItemAwareElement)value;
            TransactionalEditingDomain editingDomain = this.getEditingDomain(association);
            if (this.feature == Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef()) {
                if (editingDomain == null) {
                    this.setSourceRef(association, v, c, cf);
                } else {
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            SourceTargetFeatureDescriptor.this.setSourceRef(association, v, c, cf);
                        }
                    });
                }
            } else if (editingDomain == null) {
                this.setTargetRef(association, v, c, cf);
            } else {
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        SourceTargetFeatureDescriptor.this.setTargetRef(association, v, c, cf);
                    }
                });
            }
        }

        private void setSourceRef(DataAssociation association, ItemAwareElement value, EObject container, EStructuralFeature containerFeature) {
            if (association.getSourceRef().size() == 0) {
                if (container != null) {
                    if (containerFeature.isMany()) {
                        ((List)container.eGet(containerFeature)).add(value);
                    } else {
                        container.eSet(containerFeature, (Object)value);
                    }
                }
                if (value == null) {
                    association.getSourceRef().clear();
                } else {
                    association.getSourceRef().add(value);
                }
            } else {
                if (container != null) {
                    if (containerFeature.isMany()) {
                        ((List)container.eGet(containerFeature)).add(value);
                    } else {
                        container.eSet(containerFeature, (Object)value);
                    }
                }
                this.updateConnectionIfNeeded(association, value);
                if (value == null) {
                    association.getSourceRef().clear();
                } else {
                    association.getSourceRef().set(0, value);
                }
            }
            if (association.getTargetRef() != null) {
                ItemAwareElement targetRef = association.getTargetRef();
                if (value != null) {
                    targetRef.setItemSubjectRef(value.getItemSubjectRef());
                } else {
                    targetRef.setItemSubjectRef(null);
                }
            }
        }

        private void setTargetRef(DataAssociation association, ItemAwareElement value, EObject container, EStructuralFeature containerFeature) {
            if (container != null) {
                if (containerFeature.isMany()) {
                    ((List)container.eGet(containerFeature)).add(value);
                } else {
                    container.eSet(containerFeature, (Object)value);
                }
            }
            this.updateConnectionIfNeeded(association, value);
            association.setTargetRef(value);
            if (!association.getSourceRef().isEmpty()) {
                ItemAwareElement sourceRef = (ItemAwareElement)association.getSourceRef().get(0);
                if (value != null) {
                    sourceRef.setItemSubjectRef(value.getItemSubjectRef());
                } else {
                    sourceRef.setItemSubjectRef(null);
                }
            }
        }

        private void updateConnectionIfNeeded(DataAssociation association, ItemAwareElement value) {
            Connection connection;
            PictogramElement pe2;
            DiagramEditor diagramEditor = ModelUtil.getDiagramEditor((EObject)association);
            Diagram diagram = diagramEditor.getDiagramTypeProvider().getDiagram();
            IFeatureProvider fp = diagramEditor.getDiagramTypeProvider().getFeatureProvider();
            Shape owner = null;
            EObject container = association.eContainer();
            if (container instanceof Activity || container instanceof Event) {
                for (PictogramElement pe2 : Graphiti.getLinkService().getPictogramElements(diagram, container)) {
                    if (!(pe2 instanceof Shape) || BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe2, BPMNShape.class) == null) continue;
                    owner = (Shape)pe2;
                }
            }
            pe2 = null;
            if (value instanceof DataObject || value instanceof DataObjectReference || value instanceof DataStore || value instanceof DataStoreReference || value instanceof DataInput || value instanceof DataOutput) {
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)value);
                for (PictogramElement p : pes) {
                    if (BusinessObjectUtil.getFirstElementOfType((PictogramElement)p, BPMNShape.class) == null) continue;
                    pe2 = p;
                    break;
                }
            }
            if ((connection = DataAssociationFeatureContainer.findDataAssociation(diagram, association)) != null) {
                if (pe2 != null) {
                    Point p;
                    ReconnectionContext rc = null;
                    if (association instanceof DataOutputAssociation) {
                        p = GraphicsUtil.createPoint((Anchor)connection.getStart());
                        FixPointAnchor a = AnchorUtil.findNearestAnchor((AnchorContainer)((AnchorContainer)pe2), (Point)p);
                        rc = new ReconnectionContext(connection, connection.getStart(), (Anchor)a, null);
                        rc.setTargetPictogramElement(pe2);
                        rc.setTargetLocation(Graphiti.getPeService().getLocationRelativeToDiagram((Anchor)a));
                        rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                    } else {
                        p = GraphicsUtil.createPoint((Anchor)connection.getEnd());
                        FixPointAnchor a = AnchorUtil.findNearestAnchor((AnchorContainer)owner, (Point)p);
                        rc = new ReconnectionContext(connection, (Anchor)a, connection.getEnd(), null);
                        rc.setTargetPictogramElement(pe2);
                        rc.setTargetLocation(Graphiti.getPeService().getLocationRelativeToDiagram((Anchor)a));
                        rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                    }
                    IReconnectionFeature rf = fp.getReconnectionFeature((IReconnectionContext)rc);
                    if (rf.canReconnect((IReconnectionContext)rc)) {
                        rf.reconnect((IReconnectionContext)rc);
                    }
                } else {
                    DeleteContext dc = new DeleteContext((PictogramElement)connection);
                    connection.getLink().getBusinessObjects().remove(0);
                    IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
                    df.delete((IDeleteContext)dc);
                }
            } else if (pe2 != null) {
                PictogramElement p;
                p = GraphicsUtil.createPoint((AnchorContainer)((AnchorContainer)pe2));
                FixPointAnchor ownerAnchor = AnchorUtil.findNearestAnchor((AnchorContainer)owner, (Point)p);
                p = GraphicsUtil.createPoint((AnchorContainer)owner);
                FixPointAnchor peAnchor = AnchorUtil.findNearestAnchor((AnchorContainer)((AnchorContainer)pe2), (Point)p);
                AddConnectionContext ac = null;
                ac = association instanceof DataOutputAssociation ? new AddConnectionContext((Anchor)ownerAnchor, (Anchor)peAnchor) : new AddConnectionContext((Anchor)peAnchor, (Anchor)ownerAnchor);
                ac.putProperty((Object)"businessObject", (Object)association);
                ac.setNewObject((Object)association);
                IAddFeature af = fp.getAddFeature((IAddContext)ac);
                if (af.canAdd((IAddContext)ac)) {
                    af.add((IAddContext)ac);
                }
            }
        }
    }
}

