/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.sourcelookup.DebugLaunchConfigurationListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class RemoteDebugActivator
implements BundleActivator,
Preferences.IPropertyChangeListener {
    public static final String UNKNOWN = "<Unknown>";
    public static final String LOCALHOST = "localhost";
    public static final String LAUNCH_CONFIGURATION_ID = "org.jboss.tools.common.jdt.debug.launching.JBossRemoteJavaApplication";
    public static final String REMOTE_JAVA_APPLICATION_ID = IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION;
    public static final String JBOSS_REMOTE_JAVA_APPLICATION = "JBossRemoteJavaApplication";
    public static final String JBOSS_SOURCE_PATH_COMPUTER_ID = "org.jboss.tools.common.jdt.debug.sourceLookup.remoteDebugSourcePathComputer";
    public static final String LAUNCH_CATEGORY = "org.eclipse.debug.ui.launchGroup.debug";
    public static final String DEFAULT_REMOTE_JBOSS_APP = "Remote myapp";
    public static final String JBOSS_TEMP_JAVA_APPLICATION = "jbossTempJavaApplication";
    public static final String DT_SOCKET = "dt_socket";
    public static final String SET_AS_DEFAULT = "setAsDefault";
    public static final String ATTR_SELECTED_PROJECTS = "selectedProjects";
    public static final String MAVEN_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String MAVEN_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    public static final String JDT_JAVA_APPLICATION = "org.eclipse.jdt.launching.localJavaApplication";
    public static final String JDT_JUNIT_TEST = "org.eclipse.jdt.junit.launchconfig";
    private static final String JAVA_HOME = "java.home";
    private static final String TOOLS_JAR = String.valueOf(File.separator) + "lib" + File.separator + "tools.jar";
    private static final String PLUGIN_ID = "org.jboss.tools.common.jdt.debug";
    private static String[] WIN_CMD_ARRAY = new String[]{"netstat", "-ona", "-p", "tcp"};
    private static String[] MAC_CMD_ARRAY = new String[]{"lsof", "-i", "-P"};
    private static String[] LINUX_CMD_ARRAY = new String[]{"netstat", "-nlt", "-p", ""};
    private static final String MAVEN_PLUGIN_ID = "org.eclipse.m2e.core";
    public static final String MAVEN_NATURE = "org.eclipse.m2e.core.maven2Nature";
    private boolean jdk = false;
    private boolean logged = false;
    private ClassLoader toolsLoader;
    private static RemoteDebugActivator plugin;
    private static BundleContext context;
    private DebugLaunchConfigurationListener listener;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        JavaRuntime.getPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.listener = new DebugLaunchConfigurationListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        JavaRuntime.getPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
    }

    public static RemoteDebugActivator getDefault() {
        return plugin;
    }

    private File getToolsJar() {
        int n;
        int n2;
        Object[] objectArray;
        String javaHome = System.getProperty(JAVA_HOME);
        File javaHomeFile = new File(javaHome);
        File tools = this.getFile(javaHomeFile);
        if (tools.exists()) {
            return tools;
        }
        File parentDir = new File(String.valueOf(javaHome) + File.separator + "..");
        tools = this.getFile(parentDir);
        if (tools.exists()) {
            return tools;
        }
        if (parentDir.isDirectory()) {
            objectArray = parentDir.listFiles();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IVMInstallType child = objectArray[n];
                if (child.isDirectory() && (tools = this.getFile((File)child)).exists()) {
                    return tools;
                }
                ++n;
            }
        }
        objectArray = JavaRuntime.getVMInstallTypes();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            IVMInstallType type = objectArray[n];
            IVMInstall[] iVMInstallArray = type.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                File jdkRoot = install.getInstallLocation();
                tools = this.getFile(jdkRoot);
                if (tools.exists()) {
                    return tools;
                }
                ++n4;
            }
            ++n;
        }
        return null;
    }

    private File getFile(File dir) {
        File tools = new File(dir, TOOLS_JAR);
        if (tools.exists()) {
            return tools;
        }
        return tools;
    }

    private ClassLoader getToolsLoader() {
        if (this.toolsLoader == null) {
            this.toolsLoader = Thread.currentThread().getContextClassLoader();
            File toolsJar = this.getToolsJar();
            if (toolsJar == null) {
                return this.toolsLoader;
            }
            try {
                toolsJar = toolsJar.getCanonicalFile();
            }
            catch (IOException iOException) {
                return this.toolsLoader;
            }
            if (toolsJar.exists()) {
                URL toolsUrl;
                try {
                    toolsUrl = toolsJar.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return this.toolsLoader;
                }
                this.toolsLoader = new URLClassLoader(new URL[]{toolsUrl}, this.toolsLoader);
            }
        }
        return this.toolsLoader;
    }

    /*
     * Exception decompiling
     */
    private List<VmModel> getVmModels(String name, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] getOsCommand(String pid) {
        if ("win32".equals(Platform.getOS())) {
            return WIN_CMD_ARRAY;
        }
        if ("macosx".equals(Platform.getOS())) {
            return MAC_CMD_ARRAY;
        }
        if ("linux".equals(Platform.getOS())) {
            String[] cmdarray = LINUX_CMD_ARRAY;
            cmdarray[cmdarray.length - 1] = pid;
            return cmdarray;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private VmModel getVmModelUsingOsCommand(Integer vmPid, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VmModel processLine(String line, String vmPidStr) {
        if ("win32".equals(Platform.getOS())) {
            return this.processWinLine(line, vmPidStr);
        }
        if ("macosx".equals(Platform.getOS())) {
            return this.processMacLine(line, vmPidStr);
        }
        if ("linux".equals(Platform.getOS())) {
            return this.processLinuxLine(line, vmPidStr);
        }
        return null;
    }

    private VmModel processLinuxLine(String line, String vmPidStr) {
        String port;
        String pid;
        String[] pids;
        String[] elements = line.split(" ", 7);
        if (elements.length >= 7 && elements[0] != null && elements[0].equals("tcp") && elements[6] != null && (pids = elements[6].split("/")).length == 2 && (pid = pids[0]) != null && pid.equals(vmPidStr) && elements[3] != null && (port = this.getPort(elements[3])) != null) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass(UNKNOWN);
            model.setPort(port);
            model.setTransport(DT_SOCKET);
            return model;
        }
        return null;
    }

    private VmModel processMacLine(String line, String vmPidStr) {
        String port;
        String[] elements = line.split(" ", 10);
        if (elements.length >= 10 && elements[1] != null && elements[1].equals(vmPidStr) && elements[7] != null && elements[7].equals("TCP") && elements[8] != null && (port = this.getPort(elements[8])) != null && !port.isEmpty()) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass(UNKNOWN);
            model.setPort(port);
            model.setTransport(DT_SOCKET);
            return model;
        }
        return null;
    }

    private String getPort(String element) {
        String[] ports = element.split(":");
        String port = ports.length == 2 ? ports[1] : ports[0];
        return port;
    }

    private VmModel processWinLine(String line, String vmPidStr) {
        String port;
        String[] elements = line.split(" ", 5);
        if (elements.length == 5 && elements[4] != null && elements[4].equals(vmPidStr) && elements[1] != null && (port = this.getPort(elements[1])) != null && !port.isEmpty()) {
            VmModel model = new VmModel();
            model.setPid(vmPidStr);
            model.setMainClass(UNKNOWN);
            model.setPort(port);
            model.setTransport(DT_SOCKET);
            return model;
        }
        return null;
    }

    private String clearWhiteSpace(String line) {
        line = line.trim();
        while (line.contains("\t")) {
            line = line.replace(" ", "\t");
        }
        while (line.contains("  ")) {
            line = line.replace("  ", " ");
        }
        return line;
    }

    private VmModel getVmModelsUsingTools(Class<?> hostClazz, Object host, Integer vmPid, IProgressMonitor monitor) {
        Class<?> monitoredVm;
        Class<?> vmUtil;
        Object vm;
        String vmPidStr;
        block8: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (monitor.isCanceled()) {
                return null;
            }
            vmPidStr = String.valueOf(vmPid);
            try {
                Class<?> vmIdentifier = this.toolsLoader.loadClass("sun.jvmstat.monitor.VmIdentifier");
                Constructor<?> vmIdentifierConstructor = vmIdentifier.getConstructor(String.class);
                Object vmIdentifierObject = vmIdentifierConstructor.newInstance(vmPidStr);
                Method getMonitoredVm = hostClazz.getDeclaredMethod("getMonitoredVm", vmIdentifier);
                vm = getMonitoredVm.invoke(host, vmIdentifierObject);
                vmUtil = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVmUtil");
                monitoredVm = this.toolsLoader.loadClass("sun.jvmstat.monitor.MonitoredVm");
                if (!monitor.isCanceled()) break block8;
                return null;
            }
            catch (Exception e) {
                this.logWarning(e);
                return null;
            }
        }
        VmModel model = new VmModel();
        model.setPid(vmPidStr);
        Method jvmArgs = vmUtil.getDeclaredMethod("jvmArgs", monitoredVm);
        Object jvmArgsObj = jvmArgs.invoke(null, vm);
        if (jvmArgsObj instanceof String) {
            model.setJvmArgs((String)jvmArgsObj);
        }
        Method mainClass = vmUtil.getDeclaredMethod("mainClass", monitoredVm, Boolean.TYPE);
        Object mainClassObj = mainClass.invoke(null, vm, true);
        if (mainClassObj instanceof String) {
            model.setMainClass((String)mainClassObj);
        }
        Method mainArgs = vmUtil.getDeclaredMethod("mainArgs", monitoredVm);
        Object mainArgsObj = mainArgs.invoke(null, vm);
        if (mainArgsObj instanceof String) {
            model.setMainArgs((String)mainArgsObj);
        }
        return model;
    }

    private void logWarning(Exception e) {
        if (!this.logged) {
            Status status = new Status(2, context.getBundle().getSymbolicName(), e.getLocalizedMessage(), (Throwable)e);
            this.getLog().log((IStatus)status);
            this.logged = true;
        }
    }

    public ILog getLog() {
        Bundle bundle = context.getBundle();
        return InternalPlatform.getDefault().getLog(bundle);
    }

    public VmModel[] getDebugModels(String name, IProgressMonitor monitor) {
        ArrayList<VmModel> debugModels = new ArrayList<VmModel>();
        List<VmModel> models = this.getVmModels(name, monitor);
        if (models == null) {
            return null;
        }
        for (VmModel model : models) {
            if (model.getPort() == null || !DT_SOCKET.equals(model.getTransport())) continue;
            debugModels.add(model);
        }
        return debugModels.toArray(new VmModel[0]);
    }

    public boolean isJdk() {
        if (!this.jdk && this.toolsLoader == null) {
            this.getVmModels(LOCALHOST, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.jdk;
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static IVMConnector getDefaultVMConnector() {
        IVMConnector[] connectors;
        IVMConnector[] iVMConnectorArray = connectors = JavaRuntime.getVMConnectors();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IVMConnector connector = iVMConnectorArray[n2];
            if (connector instanceof SocketAttachConnector) {
                return connector;
            }
            ++n2;
        }
        return null;
    }

    public VmModel[] getDebugModels(IProgressMonitor monitor) {
        return this.getDebugModels(LOCALHOST, monitor);
    }

    public ILaunchConfiguration getDefaultLaunchConfiguration() {
        ILaunchConfiguration[] configs = this.getLaunchConfigurations();
        if (configs != null && configs.length > 0) {
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                boolean isDefault = false;
                try {
                    isDefault = config.getAttribute(SET_AS_DEFAULT, false);
                }
                catch (CoreException coreException) {}
                if (isDefault) {
                    return config;
                }
                ++n2;
            }
            if (configs.length == 1) {
                try {
                    ILaunchConfigurationWorkingCopy wc = configs[0].getWorkingCopy();
                    wc.setAttribute(SET_AS_DEFAULT, true);
                    wc.doSave();
                }
                catch (CoreException e) {
                    RemoteDebugActivator.log(e);
                }
            }
            return configs[0];
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(REMOTE_JAVA_APPLICATION_ID);
        try {
            ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
            ArrayList<ILaunchConfiguration> jbossConfigurations = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute(JBOSS_REMOTE_JAVA_APPLICATION, false)) {
                    jbossConfigurations.add(config);
                }
                ++n2;
            }
            return jbossConfigurations.toArray(new ILaunchConfiguration[0]);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (JavaRuntime.PREF_VM_XML.equals(property)) {
            this.toolsLoader = null;
            this.logged = false;
        }
    }

    public static boolean m2eExists() {
        Bundle bundle = Platform.getBundle((String)MAVEN_PLUGIN_ID);
        return bundle != null;
    }

    public static ILaunchConfiguration createTemporaryLaunchConfiguration(String projectName, String typeId) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateLaunchConfigurationName(JBOSS_TEMP_JAVA_APPLICATION));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        ILaunchConfiguration config = wc.doSave();
        return config;
    }

    public static ILaunchConfigurationWorkingCopy createNewLaunchConfiguration(ILaunchConfigurationType type) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateLaunchConfigurationName(DEFAULT_REMOTE_JBOSS_APP));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, RemoteDebugActivator.getDefaultVMConnector().getIdentifier());
        wc.setAttribute(JBOSS_REMOTE_JAVA_APPLICATION, true);
        return wc;
    }
}

