/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.web.validation.CheckContextParam;
import org.jboss.tools.jsf.web.validation.JSFCheckFromViewId;
import org.jboss.tools.jsf.web.validation.JSFCheckToViewId;
import org.jboss.tools.jsf.web.validation.JSFSeverityPreferences;
import org.jboss.tools.jsf.web.validation.JSFValidationMessage;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.CheckClass;

public class FacesConfigValidator
extends ValidationErrorManager
implements org.jboss.tools.common.validation.IValidator,
JSFConstants {
    public static final String ID = "org.jboss.tools.esb.validator.ESBCoreValidator";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.jsf.ui.preferences.JSFValidationPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.jsf.ui.propertyPages.JSFValidationPreferencePage";
    public static String SHORT_ID = "jsf-verification";
    static String XML_EXT = ".xml";
    String projectName;
    Map<IProject, IProjectValidationContext> contexts = new HashMap<IProject, IProjectValidationContext>();
    Map<String, Set<Check>> checks = new HashMap<String, Set<Check>>();

    public FacesConfigValidator() {
        this.createChecks();
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JSFSeverityPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return JSFSeverityPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    private void addCheck(Check check, String ... entities) {
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            Set<Check> cs = this.checks.get(entity);
            if (cs == null) {
                cs = new HashSet<Check>();
                this.checks.put(entity, cs);
            }
            cs.add(check);
            ++n2;
        }
    }

    void createChecks() {
        String ENT_APP = "JSFApplication";
        String ENT_APP_12 = String.valueOf(ENT_APP) + "12";
        String ENT_APP_20 = String.valueOf(ENT_APP) + "20";
        String ENT_APP_22 = String.valueOf(ENT_APP) + "22";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_ACTION_LISTENER, "action-listener", false, "javax.faces.event.ActionListener", null), ENT_APP, ENT_APP_12, ENT_APP_20, ENT_APP_22);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_NAVIGATION_HANDLER, "navigation-handler", false, null, "javax.faces.application.NavigationHandler"), ENT_APP, ENT_APP_12, ENT_APP_20, ENT_APP_22);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_PROPERTY_RESOLVER, "class name", false, "javax.faces.el.PropertyResolver", null).setVisualAttribute("property-resolver"), "JSFPropertyResolver");
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_STATE_MANAGER, "state-manager", false, null, "javax.faces.application.StateManager"), ENT_APP, ENT_APP_12, ENT_APP_20, ENT_APP_22);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_VARIABLE_RESOLVER, "class name", false, null, "javax.el.ELResolver").setVisualAttribute("el-resolver"), "JSFELResolver");
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_VARIABLE_RESOLVER, "class name", false, null, "javax.faces.el.VariableResolver").setVisualAttribute("variable-resolver"), "JSFVariableResolver");
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_VIEW_HANDLER, "view-handler", false, null, "javax.faces.application.ViewHandler"), ENT_APP, ENT_APP_12, ENT_APP_20, ENT_APP_22);
        String ENT_COMPONENT = "JSFComponent";
        String ENT_COMPONENT_11 = String.valueOf(ENT_COMPONENT) + "11";
        this.addCheck((Check)new CheckClass((ValidationErrorManager)this, JSFSeverityPreferences.INVALID_COMPONENT_CLASS, "component-class", false, null, "javax.faces.component.UIComponent"), ENT_COMPONENT, ENT_COMPONENT_11);
        String ENT_CONVERTER = "JSFConverter";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_CONVERTER_CLASS, "converter-class", false, "javax.faces.convert.Converter", null), ENT_CONVERTER);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_CONVERTER_FOR_CLASS, "converter-for-class", true, null, null), ENT_CONVERTER);
        String ENT_FACTORY = "JSFFactory";
        String ENT_FACTORY_20 = String.valueOf(ENT_FACTORY) + "20";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_APPLICATION_FACTORY, "application-factory", false, null, "javax.faces.application.ApplicationFactory"), ENT_FACTORY, ENT_FACTORY_20);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_FACES_CONTEXT_FACTORY, "faces-context-factory", false, null, "javax.faces.context.FacesContextFactory"), ENT_FACTORY, ENT_FACTORY_20);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_LIFECYCLE_FACTORY, "lifecycle-factory", false, null, "javax.faces.lifecycle.LifecycleFactory"), ENT_FACTORY, ENT_FACTORY_20);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_RENDER_KIT_FACTORY, "render-kit-factory", false, null, "javax.faces.render.RenderKitFactory"), ENT_FACTORY, ENT_FACTORY_20);
        String ENT_LIST_ENTRIES = "JSFListEntries";
        String ENT_MAP_ENTRIES = "JSFMapEntries";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_KEY_CLASS, "key-class", true, null, null), ENT_MAP_ENTRIES);
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_KEY_CLASS, "value-class", true, null, null), ENT_LIST_ENTRIES, ENT_MAP_ENTRIES);
        String ENT_MANAGED_BEAN = "JSFManagedBean";
        String ENT_MANAGED_BEAN_20 = String.valueOf(ENT_MANAGED_BEAN) + "20";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_BEAN_CLASS, "managed-bean-class", false, null, null), ENT_MANAGED_BEAN, ENT_MANAGED_BEAN_20);
        String ENT_MANAGED_PROPERTY = "JSFManagedProperty";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_PROPERTY_CLASS, "property-class", false, null, null), ENT_MANAGED_PROPERTY);
        String ENT_REFERENCED_BEAN = "JSFReferencedBean";
        this.addCheck((Check)new CheckClass((ValidationErrorManager)this, JSFSeverityPreferences.INVALID_BEAN_CLASS, "referenced-bean-class", false, null, null), ENT_REFERENCED_BEAN);
        String ENT_PHASE_LISTENER = "JSFPhaseListener";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_PHASE_LISTENER, "phase-listener", false, null, "javax.faces.event.PhaseListener"), ENT_PHASE_LISTENER);
        String ENT_RENDER_KIT = "JSFRenderKit";
        String ENT_RENDER_KIT_11 = String.valueOf(ENT_RENDER_KIT) + "11";
        String ENT_RENDER_KIT_12 = String.valueOf(ENT_RENDER_KIT) + "12";
        String ENT_RENDER_KIT_20 = String.valueOf(ENT_RENDER_KIT) + "20";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_RENDER_KIT_CLASS, "render-kit-class", false, null, "javax.faces.render.RenderKit"), ENT_RENDER_KIT, ENT_RENDER_KIT_11, ENT_RENDER_KIT_12, ENT_RENDER_KIT_20);
        String ENT_RENDERER = "JSFRenderer";
        String ENT_RENDERER_11 = String.valueOf(ENT_RENDERER) + "11";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_RENDERER_CLASS, "renderer-class", false, null, "javax.faces.render.Renderer"), ENT_RENDERER, ENT_RENDERER_11);
        String ENT_VALIDATOR = "JSFValidator";
        String ENT_VALIDATOR_12 = String.valueOf(ENT_VALIDATOR) + "12";
        this.addCheck((Check)new JSFCheckClass(this, JSFSeverityPreferences.INVALID_VALIDATOR_CLASS, "validator-class", false, null, "javax.faces.validator.Validator"), ENT_VALIDATOR, ENT_VALIDATOR_12);
        this.addCheck(new JSFCheckFromViewId(this), "JSFNavigationCase", "JSFNavigationCase20", "JSFNavigationRule", "JSFNavigationRule20");
        this.addCheck(new JSFCheckToViewId(this), "JSFNavigationCase", "JSFNavigationCase20", "JSFNavigationRule", "JSFNavigationRule20");
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return null;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        Object rootContext = this.contexts.get(project);
        if (rootContext == null) {
            IKbProject kb = KbProjectFactory.getKbProject((IProject)project, (boolean)true);
            rootContext = kb != null ? kb.getValidationContext() : new ProjectValidationContext();
            this.contexts.put(project, (IProjectValidationContext)rootContext);
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean shouldValidate(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            if (fp != null && f != null && fp.getInstalledVersion(f) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getDefault().logError((Throwable)e);
        }
        return false;
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.projectName = project.getName();
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        HashSet<IPath> resourcesToClean = new HashSet<IPath>();
        for (IFile file : changedFiles) {
            resourcesToClean.add(file.getFullPath());
        }
        changedFiles = this.collectFiles(project, changedFiles, context);
        for (IFile file : changedFiles) {
            this.removeAllMessagesFromResource((IResource)file);
            resourcesToClean.add(file.getFullPath());
        }
        this.getValidationContext().removeLinkedCoreResources(SHORT_ID, resourcesToClean);
        for (IFile file : changedFiles) {
            XModelObject o;
            if (!file.getName().endsWith(XML_EXT) || (o = EclipseResourceUtil.createObjectForResource((IResource)file)) == null) continue;
            String entity = o.getModelEntity().getName();
            if (entity.startsWith("FacesConfig")) {
                this.validateFile(o, file);
                continue;
            }
            if (!entity.startsWith("FileWebApp")) continue;
            new CheckContextParam(this).check(o);
        }
        return this.OK_STATUS;
    }

    private void validateFile(XModelObject object, IFile file) {
        this.validateObject(object);
    }

    private void validateObject(XModelObject object) {
        XModelObject[] cs;
        String entity = object.getModelEntity().getName();
        Set<Check> ch = this.checks.get(entity);
        if (ch != null) {
            for (Check c : ch) {
                c.check(object);
            }
        }
        XModelObject[] xModelObjectArray = cs = object.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            this.validateObject(c);
            ++n2;
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(JSFValidationMessage.VALIDATING_PROJECT, new String[]{this.projectName});
        IPath webContentPath = WebUtils.getFirstWebContentPath((IProject)project);
        if (webContentPath == null) {
            return this.OK_STATUS;
        }
        IFolder webInf = null;
        try {
            webInf = project.getFolder(webContentPath.removeFirstSegments(1).append("WEB-INF"));
            if (webInf.isAccessible()) {
                IResource[] rs;
                IResource[] iResourceArray = rs = webInf.members();
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject o;
                    IFile file;
                    String name;
                    IResource r = iResourceArray[n2];
                    if (r instanceof IFile && (name = (file = (IFile)r).getName()).endsWith(XML_EXT) && (o = EclipseResourceUtil.createObjectForResource((IResource)file)) != null) {
                        String entity = o.getModelEntity().getName();
                        if (entity.startsWith("FacesConfig")) {
                            this.validateFile(o, file);
                        } else if (entity.startsWith("FileWebApp")) {
                            new CheckContextParam(this).check(o);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return new Status(4, "org.jboss.tools.jst.web", MessageFormat.format("Validation error for project {0}", project.getLocation().toString()), (Throwable)e);
        }
        return this.OK_STATUS;
    }

    public boolean isEnabled(IProject project) {
        return JSFSeverityPreferences.isValidationEnabled(project);
    }

    private Set<IFile> collectFiles(IProject project, Set<IFile> changedFiles, IProjectValidationContext context) {
        HashSet<IFile> files = new HashSet<IFile>();
        if (context == null) {
            files.addAll(changedFiles);
            return files;
        }
        HashSet<IFile> direct = new HashSet<IFile>();
        HashSet<IFile> dependent = new HashSet<IFile>();
        for (IFile f : changedFiles) {
            String name;
            Set paths;
            block19: {
                int n;
                if (f == null || f.getProject() != project) continue;
                paths = context.getCoreResourcesByVariableName(SHORT_ID, f.getFullPath().toOSString(), true);
                name = f.getName();
                if (name.endsWith(".java")) {
                    try {
                        IType[] ts;
                        ICompilationUnit unit = EclipseUtil.getCompilationUnit((IFile)f);
                        if (unit == null) break block19;
                        IType[] iTypeArray = ts = unit.getTypes();
                        int n2 = ts.length;
                        n = 0;
                        while (n < n2) {
                            IType t = iTypeArray[n];
                            String type = t.getFullyQualifiedName();
                            Set paths1 = context.getCoreResourcesByVariableName(SHORT_ID, type, true);
                            if (paths1 != null) {
                                if (paths != null) {
                                    paths.addAll(paths1);
                                } else {
                                    paths = paths1;
                                }
                            }
                            ++n;
                        }
                    }
                    catch (CoreException e) {
                        JSFModelPlugin.getDefault().logError(e);
                    }
                } else {
                    IPath[] ps;
                    IPath[] iPathArray = ps = WebUtils.getWebContentPaths((IProject)project);
                    n = ps.length;
                    int t = 0;
                    while (t < n) {
                        IPath rootPath = iPathArray[t];
                        if (rootPath.isPrefixOf(f.getFullPath())) {
                            Set paths1;
                            String s = f.getFullPath().removeFirstSegments(rootPath.segmentCount()).toString();
                            if (!s.startsWith("/")) {
                                s = "/" + s;
                            }
                            if ((paths1 = context.getCoreResourcesByVariableName(SHORT_ID, s, true)) != null) {
                                if (paths != null) {
                                    paths.addAll(paths1);
                                } else {
                                    paths = paths1;
                                }
                            }
                        }
                        ++t;
                    }
                }
            }
            if (name.endsWith(".xml") && f.exists()) {
                if (!direct.contains(f) && !dependent.contains(f)) {
                    files.add(f);
                }
                direct.add(f);
                dependent.remove(f);
            }
            if (paths == null) continue;
            for (IPath path : paths) {
                IFile f1 = project.getParent().getFile(path);
                if (!f1.exists() || direct.contains(f1) || dependent.contains(f1)) continue;
                dependent.add(f1);
                files.add(f1);
            }
        }
        return files;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new JSFPreferenceInfo());
    }

    static class JSFCheckClass
    extends CheckClass {
        public JSFCheckClass(ValidationErrorManager manager, String preference, String attr, boolean allowsPrimitive, String implementsType, String extendsType) {
            super(manager, preference, attr, allowsPrimitive, implementsType, extendsType);
        }

        protected String getShortId() {
            return SHORT_ID;
        }
    }

    class JSFPreferenceInfo
    implements IPreferenceInfo {
        JSFPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return FacesConfigValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return FacesConfigValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.jsf";
        }
    }
}

