/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;

public class PrefixUrlPattern
implements JSFUrlPattern {
    protected String prefix = "/faces/";

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean matches(String path) {
        return path.startsWith(this.prefix);
    }

    @Override
    public boolean isJSFUrl(String path) {
        return path.startsWith(this.prefix) || path.indexOf(".") < 0;
    }

    @Override
    public String getJSFPath(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        return url.startsWith(this.prefix) ? url.substring(this.prefix.length() - 1) : url;
    }

    @Override
    public String getJSFUrl(String path) {
        if (path == null || path.length() == 0 || path.startsWith(this.prefix)) {
            return path;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = String.valueOf(this.prefix) + path;
        return path;
    }

    @Override
    public List<String> getJSFPaths(String url) {
        ArrayList<String> result = new ArrayList<String>();
        String path = this.getJSFPath(url);
        if (path != null && path.length() > 0) {
            result.add(path);
        }
        return result;
    }

    public String toString() {
        return "PrefixUrlPattern:" + this.prefix;
    }
}

