/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jsf.JSFPreference;
import org.jboss.tools.jsf.model.FacesProcessImpl;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.ReferenceObjectImpl;
import org.jboss.tools.jsf.model.helpers.JSFPageUpdateManager;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.model.helpers.autolayout.JSFItems;
import org.jboss.tools.jsf.model.impl.NavigationRuleObjectImpl;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.jst.web.model.helpers.autolayout.AutoLayout;
import org.jboss.tools.jst.web.model.helpers.autolayout.Items;

public class JSFProcessHelper
implements JSFConstants {
    private XModelObject process;
    private static XModelObject TEMPLATE;
    private XModelObject config;
    private Map<String, XModelObject> groups = new HashMap<String, XModelObject>();
    private Map<String, XModelObject> targets = new HashMap<String, XModelObject>();
    private XModelObject[] rules = new XModelObject[0];
    Set<Object> updateLocks = new HashSet<Object>();

    public JSFProcessHelper(XModelObject process) {
        this.process = process;
    }

    private XModelObject getTemplate() {
        if (TEMPLATE == null && this.process != null) {
            TEMPLATE = this.process.getModel().createModelObject("JSFProcessGroup", null);
        }
        return TEMPLATE;
    }

    public static JSFProcessHelper getHelper(XModelObject process) {
        return ((FacesProcessImpl)process).getHelper();
    }

    private synchronized void reset() {
        this.groups.clear();
        this.targets.clear();
        this.config = this.process.getParent();
    }

    public void restoreRefs() {
        ((FacesProcessImpl)this.process).setReference(this.process.getParent());
    }

    public boolean isUpdateLocked() {
        return this.updateLocks.size() > 0;
    }

    public void addUpdateLock(Object lock) {
        this.updateLocks.add(lock);
    }

    public void removeUpdateLock(Object lock) {
        this.updateLocks.remove(lock);
    }

    public void updateProcess() {
        if (this.isUpdateLocked()) {
            return;
        }
        this.addUpdateLock(this);
        try {
            this.updateProcess0();
        }
        finally {
            this.removeUpdateLock(this);
        }
    }

    private void updateProcess0() {
        this.reset();
        this.rules = this.config.getChildByPath("Navigation Rules").getChildren();
        int i = 0;
        while (i < this.rules.length) {
            String fvi = this.rules[i].getAttributeValue("from-view-id");
            if (fvi != null) {
                String pp = this.getRuleIdentity(this.rules[i]);
                XModelObject g = this.findOrCreateGroup(fvi, pp);
                this.groups.put(pp, g);
                XModelObject[] cs = this.rules[i].getChildren();
                int j = 0;
                while (j < cs.length) {
                    String tvi = cs[j].getAttributeValue("to-view-id");
                    if (tvi != null) {
                        String ppt = NavigationRuleObjectImpl.toNavigationRulePathPart(tvi);
                        this.targets.put(ppt, this.getTemplate());
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (String s : this.groups.keySet()) {
            this.targets.remove(s);
        }
        this.removeObsoleteGroups();
        this.createPageGroups();
        this.updateGroups();
        this.updatePages();
    }

    private String getRuleIdentity(XModelObject rule) {
        String fvi = rule.getAttributeValue("from-view-id");
        String pp = NavigationRuleObjectImpl.toNavigationRulePathPart(fvi);
        if (!JSFProcessHelper.isPattern(fvi)) {
            return pp;
        }
        String index = rule.getAttributeValue("index");
        if (index.startsWith("-") || index.equals("0")) {
            return pp;
        }
        return String.valueOf(pp) + ":" + index;
    }

    public XModelObject findOrCreateGroup(String path, String pp) {
        XModelObject g;
        if (pp == null) {
            pp = NavigationRuleObjectImpl.toNavigationRulePathPart(path);
        }
        if ((g = this.process.getChildByPath(pp)) == null) {
            g = this.process.getModel().createModelObject("JSFProcessGroup", null);
            g.setAttributeValue("name", pp);
            g.setAttributeValue("path", path);
            this.process.addChild(g);
        }
        return g;
    }

    private void removeObsoleteGroups() {
        boolean q = "yes".equals(JSFPreference.DO_NOT_CREATE_EMPTY_RULE.getValue());
        XModelObject[] ps = this.process.getChildren("JSFProcessGroup");
        int i = 0;
        while (i < ps.length) {
            String path = ps[i].getPathPart();
            if (!this.groups.containsKey(path) && !this.targets.containsKey(path)) {
                if (q && "true".equals(ps[i].getAttributeValue("persistent"))) {
                    this.groups.put(path, ps[i]);
                } else {
                    ps[i].removeFromParent();
                }
            }
            ++i;
        }
    }

    private void createPageGroups() {
        String[] paths = this.targets.keySet().toArray(new String[0]);
        int i = 0;
        while (i < paths.length) {
            String fvi = NavigationRuleObjectImpl.toFromViewId(paths[i]);
            XModelObject g = this.findOrCreateGroup(fvi, paths[i]);
            this.targets.put(paths[i], g);
            ++i;
        }
    }

    private void updateGroups() {
        ReferenceGroupImpl[] gs = this.groups.values().toArray(new ReferenceGroupImpl[0]);
        int i = 0;
        while (i < gs.length) {
            this.setGroupReferences(this.rules, gs[i]);
            this.updateGroup(gs[i]);
            ++i;
        }
        gs = this.targets.values().toArray(new ReferenceGroupImpl[0]);
        i = 0;
        while (i < gs.length) {
            gs[i].setReference(new XModelObject[0]);
            this.updateGroup(gs[i]);
            ++i;
        }
    }

    private void setGroupReferences(XModelObject[] rules, ReferenceGroupImpl group) {
        String path = group.getPathPart();
        ArrayList<XModelObject> list = null;
        int i = 0;
        while (i < rules.length) {
            String pp = this.getRuleIdentity(rules[i]);
            if (path.equals(pp)) {
                if (list == null) {
                    list = new ArrayList<XModelObject>();
                }
                list.add(rules[i]);
            }
            ++i;
        }
        XModelObject[] rs = list == null ? new XModelObject[]{} : list.toArray(new XModelObject[list.size()]);
        group.setReference(rs);
    }

    private void updateGroup(ReferenceGroupImpl group) {
        if (group.isUpToDate()) {
            return;
        }
        group.notifyUpdate();
        XModelObject[] rs = group.getReferences();
        XModelObject[] is = group.getChildren("JSFProcessItem");
        int i = 0;
        while (i < rs.length) {
            XModelObject item = null;
            item = i < is.length ? is[i] : this.createItem((XModelObject)group, rs[i]);
            ReferenceObjectImpl r = (ReferenceObjectImpl)item;
            r.setReference(rs[i]);
            this.updateItem(r);
            ++i;
        }
        i = rs.length;
        while (i < is.length) {
            is[i].removeFromParent();
            ++i;
        }
    }

    private XModelObject createItem(XModelObject group, XModelObject rule) {
        XModelObject item = group.getModel().createModelObject("JSFProcessItem", null);
        item.setAttributeValue("id", rule.getPathPart());
        item.setAttributeValue("path", rule.getAttributeValue("from-view-id"));
        String name = XModelObjectUtil.createNewChildName((String)"item", (XModelObject)group);
        item.setAttributeValue("name", name);
        group.addChild(item);
        return item;
    }

    private void updateItem(ReferenceObjectImpl item) {
        if (item.isUpToDate()) {
            return;
        }
        item.notifyUpdate();
        XModelObject rule = item.getReference();
        item.setAttributeValue("id", rule.getPathPart());
        item.setAttributeValue("path", rule.getAttributeValue("from-view-id"));
        this.updateOutputs(item);
    }

    private void updateOutputs(ReferenceObjectImpl item) {
        XModelObject[] os;
        XModelObject rule = item.getReference();
        XModelObject[] cs = rule.getChildren();
        if (this.isOutputOrderUpToDate(cs, os = item.getChildren())) {
            this.updateOutputs_1(item, cs, os);
        } else {
            this.updateOutputs_2(item, cs, os);
        }
    }

    private void updateOutputs_1(ReferenceObjectImpl item, XModelObject[] cases, XModelObject[] outputs) {
        int c = 0;
        int i = 0;
        while (i < cases.length) {
            XModelObject output = null;
            output = c < outputs.length ? outputs[c] : this.createOutput((XModelObject)item, cases[i]);
            ReferenceObjectImpl r = (ReferenceObjectImpl)output;
            r.setReference(cases[i]);
            this.updateOutput(r);
            ++c;
            ++i;
        }
        i = c;
        while (i < outputs.length) {
            outputs[i].removeFromParent();
            ++i;
        }
    }

    private void updateOutputs_2(ReferenceObjectImpl item, XModelObject[] cases, XModelObject[] outputs) {
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < outputs.length) {
            outputs[i].removeFromParent();
            map.put(outputs[i].getAttributeValue("id"), outputs[i]);
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            XModelObject output = (XModelObject)map.get(cases[i].getPathPart());
            if (output == null) {
                output = this.createOutput((XModelObject)item, cases[i]);
            } else {
                item.addChild(output);
            }
            ReferenceObjectImpl r = (ReferenceObjectImpl)output;
            r.setReference(cases[i]);
            this.updateOutput(r);
            ++i;
        }
    }

    private boolean isOutputOrderUpToDate(XModelObject[] cases, XModelObject[] outputs) {
        int i = 0;
        while (i < cases.length && i < outputs.length) {
            String id;
            String pp;
            ReferenceObject r = (ReferenceObject)outputs[i];
            if (r.getReference() != cases[i] && !(pp = cases[i].getPathPart()).equals(id = outputs[i].getAttributeValue("id"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private XModelObject createOutput(XModelObject item, XModelObject rulecase) {
        XModelObject output = item.getModel().createModelObject("JSFProcessItemOutput", null);
        output.setAttributeValue("id", rulecase.getPathPart());
        output.setAttributeValue("path", rulecase.getAttributeValue("to-view-id"));
        String name = XModelObjectUtil.createNewChildName((String)"output", (XModelObject)item);
        output.setAttributeValue("name", name);
        item.addChild(output);
        return output;
    }

    private void updateOutput(ReferenceObjectImpl output) {
        if (output.isUpToDate()) {
            return;
        }
        output.notifyUpdate();
        XModelObject rulecase = output.getReference();
        output.setAttributeValue("id", rulecase.getPathPart());
        String path = rulecase.getAttributeValue("to-view-id");
        output.setAttributeValue("path", path);
        String title = JSFProcessStructureHelper.createItemOutputPresentation(rulecase);
        output.setAttributeValue("title", title);
        XModelObject g = this.findGroupByPath(path);
        String target = g == null ? "" : g.getPathPart();
        output.setAttributeValue("target", target);
    }

    private XModelObject findGroupByPath(String path) {
        return this.getPage(path);
    }

    public void autolayout() {
        AutoLayout auto = new AutoLayout();
        auto.setItems((Items)new JSFItems());
        auto.setProcess(this.process);
    }

    public XModelObject getPage(String path) {
        XModelObject g = this.groups.get(path = NavigationRuleObjectImpl.toNavigationRulePathPart(path));
        if (g == null) {
            g = this.targets.get(path);
        }
        return g;
    }

    public void updatePages() {
        JSFPageUpdateManager pu = JSFPageUpdateManager.getInstance(this.process.getModel());
        pu.lock();
        XModelObject[] items = this.process.getChildren();
        int i = 0;
        while (i < items.length) {
            pu.updatePage(this, items[i]);
            ++i;
        }
        pu.unlock();
    }

    public static boolean isPattern(String path) {
        return path != null && (path.length() == 0 || path.indexOf(42) >= 0);
    }
}

