/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.bean;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.PositionSearcher;
import org.jboss.tools.jsf.messages.JSFUIMessages;

public class JSFRenameManagedPropertyChange
extends TextFileChange {
    private XModelObject beanProperty;
    private String newName;
    XModel model;
    boolean ok = false;

    public static JSFRenameManagedPropertyChange createChange(XModelObject beanProperty, String newName) {
        String name = beanProperty.getPresentationString();
        IFile f = JSFRenameManagedPropertyChange.getFile(beanProperty);
        if (f == null) {
            return null;
        }
        return new JSFRenameManagedPropertyChange(name, f, beanProperty, newName);
    }

    private JSFRenameManagedPropertyChange(String name, IFile file, XModelObject beanProperty, String newName) {
        super(name, file);
        this.beanProperty = beanProperty;
        this.newName = newName;
        this.model = beanProperty.getModel();
        this.addEdits();
    }

    void addEdits() {
        PositionSearcher searcher = new PositionSearcher();
        XModelObject o = ((XModelObjectImpl)this.beanProperty).getResourceAncestor();
        String text = ((FileAnyImpl)o).getAsText();
        searcher.init(text, this.beanProperty, "property-name");
        searcher.execute();
        int bp = searcher.getStartPosition();
        int ep = searcher.getEndPosition();
        this.ok = false;
        if (bp >= 0 && ep >= ep) {
            ReplaceEdit edit = new ReplaceEdit(bp, ep - bp, this.newName);
            TextChangeCompatibility.addTextEdit((TextChange)this, (String)JSFUIMessages.UPDATE_FIELD_REFERENCE, (TextEdit)edit);
            this.ok = true;
        }
    }

    private static IFile getFile(XModelObject beanProperty) {
        XModelObject o = ((XModelObjectImpl)beanProperty).getResourceAncestor();
        return o == null ? null : (IFile)EclipseResourceUtil.getResource((XModelObject)o);
    }

    public String getName() {
        return JSFUIMessages.MANAGED_PROPERTY_RENAME;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.ok) {
            return super.perform(pm);
        }
        if (this.beanProperty != null) {
            this.beanProperty.getModel().changeObjectAttribute(this.beanProperty, "property-name", this.newName);
        }
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }
}

