/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SFUtil
extends XModelObjectLoaderUtil {
    static String[] folders = new String[]{"Behaviors", "Components", "Converters", "Managed Beans", "Navigation Rules", "Orderings", "Referenced Beans", "Render Kits", "Validators", "Protected Views", "Flow Definitions", "Extensions"};

    SFUtil() {
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        Set children = super.getAllowedChildren(entity);
        if ("JSFManagedProperty".equals(entity.getName()) || "JSFListEntries".equals(entity.getName()) || "JSFMapEntry".equals(entity.getName())) {
            children.add("value");
            children.add("null-value");
        } else if ("JSFNavigationCase".equals(entity.getName())) {
            children.add("redirect");
        }
        if (entity.getAttribute("others") != null) {
            children.add("others");
        }
        return children;
    }

    protected Set<String> getAllowedAttributes(XModelEntity entity) {
        Set attributes = super.getAllowedAttributes(entity);
        return attributes;
    }

    public void loadChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (o.getFileType() == 1) {
            super.loadChildren(element, o);
            int i = 0;
            while (i < folders.length) {
                XModelObject c = o.getChildByPath(folders[i]);
                if (c != null) {
                    super.loadChildren(element, c);
                }
                ++i;
            }
        } else if ("JSFManagedBean".equals(entity) || "JSFManagedBean20".equals(entity)) {
            this.loadManagedBeanChildren(element, o);
        } else if ("JSFManagedProperty".equals(entity)) {
            this.loadManagedPropertyChildren(element, o);
        } else if ("JSFListEntries".equals(entity)) {
            this.loadListEntriesChildren(element, o);
        } else {
            super.loadChildren(element, o);
            if ("JSFProtectedViews22".equals(entity)) {
                XModelObject[] cs = o.getChildren();
                if (cs.length > 0) {
                    o.removeChild(cs[0]);
                }
            } else if ("JSFContractMapping22".equals(entity)) {
                XModelObject[] cs = o.getChildren("JSFURLPattern22");
                if (cs.length > 0) {
                    o.removeChild(cs[0]);
                }
                if ((cs = o.getChildren("JSFContracts22")).length > 0) {
                    o.removeChild(cs[0]);
                }
            }
        }
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    boolean needToSave(XModelObject o) {
        if (o == null) {
            return false;
        }
        String s = o.getModelEntity().getProperty("saveDefault");
        if (!"false".equals(s)) {
            return true;
        }
        if (this.hasSetAttributes(o)) {
            return true;
        }
        XModelObject[] cs = o.getChildren();
        if (cs.length > 2) {
            return true;
        }
        int i = 0;
        while (i < cs.length) {
            if (this.needToSave(cs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            String v = o.getAttributeValue(as[i].getName());
            if (("others".equals(as[i].getName()) || "redirect".equals(as[i].getName())) && "true".equals(v)) {
                return true;
            }
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && v != null && v.length() > 0) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }

    public boolean saveChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (o.getFileType() == 1) {
            int i = 0;
            while (i < folders.length) {
                XModelObject c = o.getChildByPath(folders[i]);
                if (c != null) {
                    super.saveChildren(element, c);
                }
                ++i;
            }
            super.saveChildren(element, o);
            return true;
        }
        if ("JSFManagedBean".equals(entity) || "JSFManagedBean20".equals(entity)) {
            this.saveManagedBeanChildren(element, o);
            return true;
        }
        if ("JSFManagedProperty".equals(entity)) {
            this.saveManagedPropertyChildren(element, o);
            return true;
        }
        if ("JSFListEntries".equals(entity)) {
            this.saveListEntriesChildren(element, o);
            return true;
        }
        boolean b = super.saveChildren(element, o);
        if ("true".equals(o.getAttributeValue("others"))) {
            XMLUtilities.createElement((Element)element, (String)"others");
        }
        if ("JSFContractMapping22".equals(entity)) {
            NodeList list = element.getChildNodes();
            boolean isWrong = false;
            Node firstContract = null;
            Node secondContract = null;
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n.getNodeType() == 1) {
                    if ("contracts".equals(n.getNodeName())) {
                        if (firstContract == null) {
                            firstContract = n;
                        } else if (secondContract == null) {
                            secondContract = n;
                        }
                    } else if ("url-pattern".equals(n.getNodeName()) && firstContract != null) {
                        isWrong = true;
                    }
                }
                ++i;
            }
            if (isWrong) {
                element.insertBefore(firstContract, secondContract);
            }
        } else if ("JSFFlowDefinition22".equals(entity)) {
            NodeList list = element.getChildNodes();
            boolean isWrong = false;
            Node initializer = null;
            Node finalizer = null;
            Node firstInboundParameter = null;
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n.getNodeType() == 1) {
                    if ("initializer".equals(n.getNodeName())) {
                        initializer = n;
                    } else if ("finalizer".equals(n.getNodeName())) {
                        finalizer = n;
                    } else if ("inbound-parameter".equals(n.getNodeName())) {
                        if (firstInboundParameter != null) {
                            firstInboundParameter = n;
                        }
                    } else if (initializer != null || finalizer != null) {
                        isWrong = true;
                    }
                }
                ++i;
            }
            if (isWrong) {
                if (initializer != null) {
                    element.insertBefore(initializer, firstInboundParameter);
                }
                if (finalizer != null) {
                    element.insertBefore(finalizer, firstInboundParameter);
                }
            }
        } else if ("JSFSwitch22".equals(entity)) {
            NodeList list = element.getChildNodes();
            boolean isWrong = false;
            Node defaultOutcome = null;
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n.getNodeType() == 1) {
                    if ("default-outcome".equals(n.getNodeName())) {
                        defaultOutcome = n;
                    } else if ("case".equals(n.getNodeName())) {
                        isWrong = true;
                    }
                }
                ++i;
            }
            if (isWrong) {
                element.insertBefore(defaultOutcome, null);
            }
        }
        return b;
    }

    public void loadAttributes(Element element, XModelObject o) {
        super.loadAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("JSFListEntry".equals(entity) || "JSFMapEntry".equals(entity)) {
            Element ce = XMLUtil.getUniqueChild((Element)element, (String)"null-value");
            if (ce != null) {
                o.setAttributeValue("null-value", "true");
                o.setAttributeValue("value", "");
            } else {
                o.setAttributeValue("null-value", "false");
                o.setAttributeValue("value", super.getAttribute(element, "value.#text"));
            }
        }
        if (XMLUtilities.getUniqueChild((Element)element, (String)"others") != null) {
            o.setAttributeValue("others", "true");
        }
        if (element.getNodeName().equals("redirect")) {
            o.setAttributeValue("redirect", "true");
        }
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if ("attribute-names".equals(xmlname)) {
            return this.loadArray(element, "attribute-name");
        }
        if ("redirect".equals(xmlname)) {
            return XMLUtil.getUniqueChild((Element)element, (String)"redirect") != null ? "yes" : "no";
        }
        if ("value.#text".equals(xmlname) && XMLUtil.getUniqueChild((Element)element, (String)"null-value") != null) {
            return "null-value";
        }
        return super.getAttribute(element, xmlname, attr);
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if ("redirect".equals(xmlname)) {
            if ("yes".equals(value)) {
                XMLUtil.createElement((Element)element, (String)"redirect");
            }
        } else if ("value.#text".equals(xmlname) && "null-value".equals(value)) {
            XMLUtil.createElement((Element)element, (String)"null-value");
        } else if ("attribute-names".equals(xmlname)) {
            this.saveArray(element, "attribute-name", value);
        } else {
            super.saveAttribute(element, xmlname, value);
        }
    }

    public void saveAttributes(Element element, XModelObject o) {
        super.saveAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("JSFConverter".equals(entity)) {
            this.eitherOr(element, "converter-for-class", "converter-id");
        } else if ("JSFListEntry".equals(entity) || "JSFMapEntry".equals(entity)) {
            if ("true".equals(o.getAttributeValue("null-value"))) {
                XMLUtil.createElement((Element)element, (String)"null-value");
            } else {
                super.saveAttribute(element, "value.#text", o.getAttributeValue("value"));
            }
        }
    }

    void loadManagedBeanChildren(Element element, XModelObject o) {
        Element ce = XMLUtil.getUniqueChild((Element)element, (String)"list-entries");
        if (ce != null) {
            o.setAttributeValue("content-kind", "list-entries");
            XModelObject c = o.getChildByPath("Entries");
            if (c != null) {
                this.load(ce, c);
            }
            return;
        }
        ce = XMLUtil.getUniqueChild((Element)element, (String)"map-entries");
        if (ce != null) {
            o.setAttributeValue("content-kind", "map-entries");
            XModelObject c = o.getChildByPath("Entries");
            if (c != null) {
                this.load(ce, c);
            }
            return;
        }
        o.setAttributeValue("content-kind", "properties");
        super.loadChildren(element, o);
    }

    void loadManagedPropertyChildren(Element element, XModelObject o) {
        Element ce = XMLUtil.getUniqueChild((Element)element, (String)"null-value");
        if (ce != null) {
            o.setAttributeValue("value-kind", "null-value");
            o.setAttributeValue("value", "");
            return;
        }
        ce = XMLUtil.getUniqueChild((Element)element, (String)"list-entries");
        if (ce != null) {
            o.setAttributeValue("value-kind", "list-entries");
            o.setAttributeValue("value", "");
            XModelObject c = o.getChildByPath("Entries");
            if (c != null) {
                this.load(ce, c);
            }
            return;
        }
        ce = XMLUtil.getUniqueChild((Element)element, (String)"map-entries");
        if (ce != null) {
            o.setAttributeValue("value-kind", "map-entries");
            o.setAttributeValue("value", "");
            XModelObject c = o.getChildByPath("Entries");
            if (c != null) {
                this.load(ce, c);
            }
            return;
        }
        String v = this.getAttribute(element, "value.#text");
        o.setAttributeValue("value-kind", "value");
        o.setAttributeValue("value", v);
    }

    void loadListEntriesChildren(Element element, XModelObject o) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String name;
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && ("null-value".equals(name = n.getNodeName()) || "value".equals(name))) {
                XModelObject c = o.getModel().createModelObject("JSFListEntry", null);
                if ("null-value".equals(name)) {
                    c.setAttributeValue("null-value", "true");
                } else {
                    c.setAttributeValue("null-value", "false");
                    c.setAttributeValue("value", this.getAttribute((Element)n, "#text"));
                }
                o.addChild(c);
            }
            ++i;
        }
    }

    void saveManagedBeanChildren(Element element, XModelObject o) {
        super.saveChildren(element, o);
    }

    void saveManagedPropertyChildren(Element element, XModelObject o) {
        String kind = o.getAttributeValue("value-kind");
        if ("null-value".equals(kind)) {
            XMLUtil.createElement((Element)element, (String)"null-value");
        } else if ("value".equals(kind)) {
            super.saveAttribute(element, "value.#text", o.getAttributeValue("value"));
        } else {
            XModelObject c = o.getChildByPath("Entries");
            if (c != null) {
                super.saveChildren(element, o);
            } else {
                XMLUtil.createElement((Element)element, (String)"null-value");
            }
        }
    }

    void saveListEntriesChildren(Element element, XModelObject o) {
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            boolean isNullValue = "true".equals(cs[i].getAttributeValue("null-value"));
            if (isNullValue) {
                XMLUtil.createElement((Element)element, (String)"null-value");
            } else {
                Element ce = XMLUtil.createElement((Element)element, (String)"value");
                this.saveAttribute(ce, "#text", cs[i].getAttributeValue("value"));
            }
            ++i;
        }
    }
}

