/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompositeComponentNamespaces {
    private static Map<String, CompositeComponentNamespaces> map = new HashMap<String, CompositeComponentNamespaces>();
    String versionSuffix = null;
    private Map<String, String> uriToNamespace = new HashMap<String, String>();
    static String XMLNS_PREFIX = "xmlns:";

    public static CompositeComponentNamespaces getInstance(XModelMetaData meta, String version) {
        CompositeComponentNamespaces instance = map.get(version);
        if (instance == null) {
            instance = new CompositeComponentNamespaces(meta, version);
        }
        return instance;
    }

    private CompositeComponentNamespaces(XModelMetaData meta, String versionSuffix) {
        String mappingName = "22".equals(versionSuffix) ? "JSF22CompositeNamespaces" : "JSF2CompositeNamespaces";
        XMapping m = meta.getMapping(mappingName);
        if (m == null) {
            return;
        }
        this.versionSuffix = versionSuffix;
        String[] keys = m.getKeys();
        int i = 0;
        while (i < keys.length) {
            String v = m.getValue(keys[i]);
            this.uriToNamespace.put(v, keys[i]);
            ++i;
        }
    }

    public NamespaceMapping getNamespaceMapping(Element element) {
        NamespaceMapping mapping = new NamespaceMapping();
        NamedNodeMap as = element.getAttributes();
        int i = 0;
        while (i < as.getLength()) {
            Node n = as.item(i);
            String name = n.getNodeName();
            if (name.startsWith(XMLNS_PREFIX)) {
                String actualNamespace = name.substring(XMLNS_PREFIX.length());
                String uri = n.getNodeValue();
                String defaultNamespace = this.getDefaultNamespace(uri);
                if (defaultNamespace == null) {
                    defaultNamespace = name.substring(XMLNS_PREFIX.length());
                }
                mapping.addNamespace(defaultNamespace, actualNamespace, uri);
            }
            ++i;
        }
        return mapping;
    }

    public String getDefaultNamespace(String uri) {
        return this.uriToNamespace.get(uri);
    }

    public void validateNamespaces(XModelObject object, Element element) {
        NamespaceMapping namespaceMapping = NamespaceMapping.load((XModelObject)object);
        if (namespaceMapping == null) {
            namespaceMapping = new NamespaceMapping();
        }
        XModelObject[] cs = object.getChildren();
        HashSet<String> ns = new HashSet<String>();
        int i = 0;
        while (i < cs.length) {
            String n = cs[i].getModelEntity().getXMLSubPath();
            int k = n.indexOf(58);
            if (k >= 0) {
                String defaultNamespace = n.substring(0, k);
                CompositeComponentNamespaces.validateNamespace(element, namespaceMapping, defaultNamespace, ns);
            }
            ++i;
        }
        XModelObject im = object.getChildByPath("Implementation");
        if (im != null) {
            XModelObject[] cs2 = im.getChildren();
            int i2 = 0;
            while (i2 < cs2.length) {
                String n = cs2[i2].getAttributeValue("tag");
                int k = n.indexOf(58);
                if (k >= 0) {
                    String defaultNamespace = n.substring(0, k);
                    CompositeComponentNamespaces.validateNamespace(element, namespaceMapping, defaultNamespace, ns);
                }
                ++i2;
            }
        }
        if (!ns.contains("composite")) {
            CompositeComponentNamespaces.validateNamespace(element, namespaceMapping, "composite", ns);
        }
    }

    static void validateNamespace(Element element, NamespaceMapping namespaceMapping, String defaultNamespace, Set<String> ns) {
        if (ns.contains(defaultNamespace)) {
            return;
        }
        ns.add(defaultNamespace);
        String uri = namespaceMapping.getURIForDefaultNamespace(defaultNamespace);
        if (uri == null) {
            return;
        }
        String actualNamespace = namespaceMapping.getActualNamespace(defaultNamespace);
        if (actualNamespace == null) {
            actualNamespace = defaultNamespace;
        }
        element.setAttribute(String.valueOf(XMLNS_PREFIX) + actualNamespace, uri);
    }
}

