/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.EclipseJavaUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.build.JSF2ProjectBuilder;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2ManagedBean;
import org.jboss.tools.jsf.jsf2.bean.model.IJSF2Project;
import org.jboss.tools.jsf.jsf2.bean.model.JSF2ProjectFactory;
import org.jboss.tools.jsf.jsf2.bean.model.impl.DefinitionContext;
import org.jboss.tools.jsf.jsf2.bean.model.impl.FacesConfigDefinition;
import org.jboss.tools.jsf.jsf2.bean.model.impl.JSF2ManagedBean;
import org.jboss.tools.jsf.jsf2.bean.model.impl.TypeDefinition;
import org.jboss.tools.jsf.jsf2.bean.scanner.lib.ClassPathMonitor;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.w3c.dom.Element;

public class JSF2Project
implements IJSF2Project {
    IProject project = null;
    ClassPathMonitor classPath = new ClassPathMonitor(this);
    DefinitionContext definitions = new DefinitionContext();
    boolean isBuilt = false;
    private boolean isStorageResolved = false;
    Set<JSF2Project> dependsOn = new HashSet<JSF2Project>();
    Set<JSF2Project> usedBy = new HashSet<JSF2Project>();
    private Set<IJSF2ManagedBean> allBeans = new HashSet<IJSF2ManagedBean>();
    private Map<IPath, Set<IJSF2ManagedBean>> beansByPath = new HashMap<IPath, Set<IJSF2ManagedBean>>();
    private Map<String, Set<IJSF2ManagedBean>> beansByName = new HashMap<String, Set<IJSF2ManagedBean>>();
    private Set<IJSF2ManagedBean> namedBeans = new HashSet<IJSF2ManagedBean>();
    private boolean isMetadataComplete = false;

    public JSF2Project() {
        this.definitions.setProject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IJSF2ManagedBean> getManagedBeans() {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            result.addAll(this.namedBeans);
        }
        return result;
    }

    @Override
    public Set<IJSF2ManagedBean> getManagedBeans(IPath path) {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        Set<IJSF2ManagedBean> beans = this.beansByPath.get(path);
        if (beans != null && !beans.isEmpty()) {
            result.addAll(beans);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IJSF2ManagedBean> getManagedBeans(String name) {
        HashSet<IJSF2ManagedBean> result = new HashSet<IJSF2ManagedBean>();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            Set<IJSF2ManagedBean> beans = this.beansByName.get(name);
            if (beans != null) {
                result.addAll(beans);
            }
        }
        return result;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.isMetadataComplete;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IType getType(String qualifiedName) {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.getProject());
        if (jp == null) {
            return null;
        }
        try {
            return EclipseJavaUtil.findType((IJavaProject)jp, (String)qualifiedName);
        }
        catch (JavaModelException e) {
            JSFModelPlugin.getDefault().logError(e);
            return null;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
        this.classPath.init();
    }

    public Set<JSF2Project> getUsedProjects() {
        return this.dependsOn;
    }

    public Set<JSF2Project> getUsedProjects(boolean hierarchy) {
        if (hierarchy) {
            if (this.dependsOn.isEmpty()) {
                return this.dependsOn;
            }
            HashSet<JSF2Project> result = new HashSet<JSF2Project>();
            this.getAllUsedProjects(result);
            return result;
        }
        return this.dependsOn;
    }

    void getAllUsedProjects(Set<JSF2Project> result) {
        for (JSF2Project n : this.dependsOn) {
            if (result.contains(n)) continue;
            result.add(n);
            n.getAllUsedProjects(result);
        }
    }

    public Set<JSF2Project> getDependentProjects() {
        return this.usedBy;
    }

    @Override
    public void addUsedProject(final IJSF2Project project) {
        if (this.dependsOn.contains(project)) {
            return;
        }
        this.addUsedProjectInternal(project);
        project.addDependentProject(this);
        if (!project.isStorageResolved()) {
            XJob.addRunnableWithPriority((XJob.XRunnable)new XJob.XRunnable(){

                public void run() {
                    project.resolve();
                    project.update(true);
                }

                public String getId() {
                    return "Build JSF2 Project " + project.getProject().getName();
                }
            });
        }
    }

    synchronized void addUsedProjectInternal(IJSF2Project project) {
        this.dependsOn.add((JSF2Project)project);
    }

    @Override
    public void addDependentProject(IJSF2Project project) {
        this.usedBy.add((JSF2Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUsedProject(IJSF2Project project) {
        JSF2Project p = (JSF2Project)project;
        if (!this.dependsOn.contains(p)) {
            return;
        }
        p.usedBy.remove(this);
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            this.dependsOn.remove(p);
        }
    }

    public List<TypeDefinition> getAllTypeDefinitions() {
        Set<JSF2Project> ps = this.getUsedProjects(true);
        if (ps == null || ps.isEmpty()) {
            return this.getDefinitions().getTypeDefinitions();
        }
        List<TypeDefinition> ds = this.getDefinitions().getTypeDefinitions();
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        result.addAll(ds);
        HashSet<IType> types = new HashSet<IType>();
        for (TypeDefinition d : ds) {
            IType t = d.getType();
            if (t == null) continue;
            types.add(t);
        }
        for (JSF2Project p : ps) {
            List<TypeDefinition> ds2 = p.getDefinitions().getTypeDefinitions();
            for (TypeDefinition d : ds2) {
                IType t = d.getType();
                if (t == null || types.contains(t)) continue;
                types.add(t);
                result.add(d);
            }
        }
        return result;
    }

    public DefinitionContext getDefinitions() {
        return this.definitions;
    }

    @Override
    public void pathRemoved(IPath path) {
        this.definitions.getWorkingCopy().clean(path);
    }

    public ClassPathMonitor getClassPath() {
        return this.classPath;
    }

    @Override
    public boolean isStorageResolved() {
        return this.isStorageResolved;
    }

    public void resolveStorage(boolean load) {
        if (this.isStorageResolved) {
            return;
        }
        if (load) {
            this.load();
        } else {
            this.isStorageResolved = true;
        }
    }

    @Override
    public void resolve() {
        this.resolveStorage(true);
    }

    public void load() {
        if (this.isStorageResolved) {
            return;
        }
        this.isStorageResolved = true;
        try {
            new JSF2ProjectBuilder(this);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
        this.postponeFiring();
        try {
            this.loadProjectDependenciesFromKBProject();
        }
        finally {
            this.fireChanges();
        }
    }

    public void clean() {
        File file = this.getStorageFile();
        if (file != null && file.isFile()) {
            file.delete();
        }
        this.isBuilt = false;
        this.classPath.clean();
        this.postponeFiring();
        this.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(boolean updateDependent) {
        FacesConfigDefinition fc = this.definitions.getFacesConfig();
        this.isMetadataComplete = fc != null && fc.isMetadataComplete();
        List<TypeDefinition> typeDefinitions = this.getAllTypeDefinitions();
        ArrayList<JSF2ManagedBean> beans = new ArrayList<JSF2ManagedBean>();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!typeDefinition.isManagedBean()) continue;
            JSF2ManagedBean bean = new JSF2ManagedBean();
            bean.setDefinition(typeDefinition);
            beans.add(bean);
        }
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            this.beansByPath.clear();
            this.beansByName.clear();
            this.namedBeans.clear();
            this.allBeans.clear();
        }
        if (!this.isMetadataComplete) {
            for (IJSF2ManagedBean iJSF2ManagedBean : beans) {
                this.addBean(iJSF2ManagedBean);
            }
        }
        if (updateDependent) {
            ArrayList<JSF2Project> arrayList = new ArrayList<JSF2Project>(this.usedBy);
            for (JSF2Project p : arrayList) {
                p.update(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBean(IJSF2ManagedBean bean) {
        String name = bean.getName();
        if (name != null && name.length() > 0) {
            JSF2Project jSF2Project = this;
            synchronized (jSF2Project) {
                Set<IJSF2ManagedBean> bs = this.beansByName.get(name);
                if (bs == null) {
                    bs = new HashSet<IJSF2ManagedBean>();
                    this.beansByName.put(name, bs);
                }
                bs.add(bean);
                this.namedBeans.add(bean);
            }
        }
        IPath path = bean.getSourcePath();
        JSF2Project jSF2Project = this;
        synchronized (jSF2Project) {
            Set<IJSF2ManagedBean> bs = this.beansByPath.get(path);
            if (bs == null) {
                bs = new HashSet<IJSF2ManagedBean>();
                this.beansByPath.put(path, bs);
            }
            bs.add(bean);
            this.allBeans.add(bean);
        }
    }

    public void store() throws IOException {
        this.isBuilt = true;
    }

    private File getStorageFile() {
        IPath path = JSFModelPlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName());
        return file;
    }

    public void clearStorage() {
        File f = this.getStorageFile();
        if (f == null || !f.exists()) {
            return;
        }
        FileUtil.clear((File)f);
        f.delete();
    }

    public boolean hasNoStorage() {
        if (this.isBuilt) {
            return false;
        }
        File f = this.getStorageFile();
        return f == null || !f.exists();
    }

    public void postponeFiring() {
    }

    public void fireChanges() {
    }

    public void reloadProjectDependencies() {
        this.dependsOn.clear();
        this.usedBy.clear();
        this.loadProjectDependenciesFromKBProject();
    }

    private void loadProjectDependenciesFromKBProject() {
        Element root = null;
        File file = this.getKBStorageFile();
        if (file != null && file.isFile() && (root = XMLUtilities.getElement((File)file, null)) != null) {
            this.loadProjectDependencies(root);
        }
    }

    private File getKBStorageFile() {
        IPath path = WebKbPlugin.getDefault().getStateLocation();
        File file = new File(path.toFile(), "projects/" + this.project.getName() + ".xml");
        return file;
    }

    private void loadProjectDependencies(Element root) {
        Element usedElement;
        Element dependsOnElement = XMLUtilities.getUniqueChild((Element)root, (String)"depends-on-projects");
        if (dependsOnElement != null) {
            Element[] paths = XMLUtilities.getChildren((Element)dependsOnElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IJSF2Project sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = JSF2ProjectFactory.getJSF2Project(project, false)) != null) {
                    this.addUsedProjectInternal(sp);
                    sp.addDependentProject(this);
                }
                ++i;
            }
        }
        if ((usedElement = XMLUtilities.getUniqueChild((Element)root, (String)"used-by-projects")) != null) {
            Element[] paths = XMLUtilities.getChildren((Element)usedElement, (String)"project");
            int i = 0;
            while (i < paths.length) {
                IJSF2Project sp;
                IProject project;
                String p = paths[i].getAttribute("name");
                if (p != null && p.trim().length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p)) != null && project.isAccessible() && (sp = JSF2ProjectFactory.getJSF2Project(project, false)) != null) {
                    this.addDependentProject(sp);
                }
                ++i;
            }
        }
    }
}

