/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.refactoring;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.propertieseditor.PropertiesCompoundEditor;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.ui.editors.WebCompoundEditor;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.RenameComponentProcessor;
import org.jboss.tools.seam.internal.core.refactoring.RenameComponentRefactoring;
import org.jboss.tools.seam.internal.core.refactoring.RenameSeamContextVariableProcessor;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.wizard.RenameComponentWizard;
import org.jboss.tools.seam.ui.wizard.RenameSeamContextVariableWizard;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamRefactorContributionFactory
extends AbstractContributionFactory {
    private static final String ANNOTATION_NAME = "org.jboss.seam.annotations.Name";
    private static final String JAVA_EXT = "java";
    private static final String XML_EXT = "xml";
    private static final String XHTML_EXT = "xhtml";
    private static final String JSP_EXT = "jsp";
    private static final String PROPERTIES_EXT = "properties";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";
    private static String selectedText;
    private static IFile editorFile;
    private String fileContent;
    private IEditorPart editor;
    private Shell shell;

    public SeamRefactorContributionFactory() {
        super("", "");
    }

    public SeamRefactorContributionFactory(String location, String namespace) {
        super(location, namespace);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        if (serviceLocator.hasService(IWorkbenchLocationService.class)) {
            ISelection sel;
            ISeamComponent component;
            IWorkbenchLocationService service = (IWorkbenchLocationService)serviceLocator.getService(IWorkbenchLocationService.class);
            this.editor = service.getWorkbenchWindow().getActivePage().getActiveEditor();
            this.shell = service.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (!(this.editor.getEditorInput() instanceof FileEditorInput)) {
                return;
            }
            FileEditorInput input = (FileEditorInput)this.editor.getEditorInput();
            editorFile = input.getFile();
            String ext = editorFile.getFileExtension();
            if (!(JAVA_EXT.equalsIgnoreCase(ext) || XML_EXT.equalsIgnoreCase(ext) || XHTML_EXT.equalsIgnoreCase(ext) || JSP_EXT.equalsIgnoreCase(ext) || PROPERTIES_EXT.equalsIgnoreCase(ext))) {
                return;
            }
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)editorFile.getProject(), (boolean)true);
            if (seamProject == null) {
                return;
            }
            MenuManager mm = new MenuManager(SeamCoreMessages.SEAM_REFACTOR);
            mm.setVisible(true);
            boolean separatorIsAdded = false;
            if (JAVA_EXT.equalsIgnoreCase(ext) && (component = this.getComponent(editorFile)) != null) {
                mm.add((IAction)new RenameSeamComponentAction());
                additions.addContributionItem((IContributionItem)new Separator(), null);
                additions.addContributionItem((IContributionItem)mm, null);
                separatorIsAdded = true;
            }
            if ((sel = this.editor.getEditorSite().getSelectionProvider().getSelection()) == null || sel.isEmpty()) {
                return;
            }
            if (sel instanceof StructuredSelection) {
                if (this.editor instanceof PropertiesCompoundEditor) {
                    sel = ((PropertiesCompoundEditor)this.editor).getActiveEditor().getSite().getSelectionProvider().getSelection();
                } else if (this.editor instanceof EditorPartWrapper) {
                    EditorPartWrapper wrapperEditor = (EditorPartWrapper)this.editor;
                    if (wrapperEditor.getEditor() instanceof WebCompoundEditor) {
                        WebCompoundEditor xmlEditor = (WebCompoundEditor)wrapperEditor.getEditor();
                        sel = xmlEditor.getActiveEditor().getSite().getSelectionProvider().getSelection();
                    }
                } else if (this.editor instanceof WebCompoundEditor) {
                    sel = ((WebCompoundEditor)this.editor).getActiveEditor().getSite().getSelectionProvider().getSelection();
                }
            }
            if (sel instanceof TextSelection) {
                TextSelection selection = (TextSelection)sel;
                selectedText = selection.getText();
                try {
                    this.fileContent = FileUtil.readStream((IFile)editorFile);
                }
                catch (CoreException e) {
                    SeamGuiPlugin.getDefault().logError(e);
                }
                boolean status = false;
                if (JAVA_EXT.equalsIgnoreCase(ext)) {
                    status = this.checkContextVariableInJava(editorFile, this.fileContent, selection);
                } else if (XML_EXT.equalsIgnoreCase(ext) || XHTML_EXT.equalsIgnoreCase(ext) || JSP_EXT.equalsIgnoreCase(ext)) {
                    status = this.checkContextVariableInDOM(editorFile, this.fileContent, selection);
                } else if (PROPERTIES_EXT.equalsIgnoreCase(ext)) {
                    status = this.checkContextVariableInProperties(editorFile, this.fileContent, selection);
                }
                if (status) {
                    mm.add((IAction)new RenameSeamContextVariableAction());
                    if (!separatorIsAdded) {
                        additions.addContributionItem((IContributionItem)new Separator(), null);
                    }
                    additions.addContributionItem((IContributionItem)mm, null);
                }
            }
        }
    }

    private boolean checkContextVariableInJava(IFile file, String content, TextSelection selection) {
        try {
            FastJavaPartitionScanner scaner = new FastJavaPartitionScanner();
            Document document = new Document(content);
            scaner.setRange((IDocument)document, 0, document.getLength());
            IToken token = scaner.nextToken();
            while (token != null && token != Token.EOF) {
                if ("__java_string".equals(token.getData())) {
                    String value;
                    int length = scaner.getTokenLength();
                    int offset = scaner.getTokenOffset();
                    if (offset <= selection.getOffset() && offset + length >= selection.getOffset() + selection.getLength() && (value = document.get(offset, length)).indexOf(123) > -1) {
                        return this.scanString(file, value, offset, selection);
                    }
                }
                token = scaner.nextToken();
            }
        }
        catch (BadLocationException e) {
            SeamCorePlugin.getDefault().logError((Throwable)e);
        }
        return false;
    }

    private boolean scanString(IFile file, String string, int offset, TextSelection selection) {
        int startEl = string.indexOf("#{");
        if (startEl > -1) {
            ELParser parser = ELParserUtil.getJbossFactory().createParser();
            ELModel model = parser.parse(string);
            for (ELInstance instance : model.getInstances()) {
                for (ELInvocationExpression ie : instance.getExpression().getInvocations()) {
                    ELPropertyInvocation pi = this.findSeamContextVariable(ie);
                    if (pi == null || offset + pi.getStartPosition() != selection.getOffset() || pi.getLength() != selection.getLength()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private ELPropertyInvocation findSeamContextVariable(ELInvocationExpression invocationExpression) {
        ELInvocationExpression invExp = invocationExpression;
        while (invExp != null) {
            if (invExp instanceof ELPropertyInvocation) {
                if (((ELPropertyInvocation)invExp).getQualifiedName() != null && ((ELPropertyInvocation)invExp).getQualifiedName().equals(selectedText)) {
                    return (ELPropertyInvocation)invExp;
                }
                invExp = invExp.getLeft();
                continue;
            }
            invExp = invExp.getLeft();
        }
        return null;
    }

    private boolean checkContextVariableInDOM(IFile file, String content, TextSelection selection) {
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return false;
        }
        IStructuredModel model = null;
        try {
            model = manager.getModelForRead(file);
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                boolean bl = this.scanChildNodes(file, (Node)document, selection);
                return bl;
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError((Throwable)e);
        }
        catch (IOException e) {
            SeamCorePlugin.getDefault().logError((Throwable)e);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private boolean scanChildNodes(IFile file, Node parent, TextSelection selection) {
        boolean status = false;
        if (parent == null) {
            return false;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curentValidatedNode = children.item(i);
            if (1 == curentValidatedNode.getNodeType() ? (status = this.scanNodeContent(file, ((IDOMNode)curentValidatedNode).getFirstStructuredDocumentRegion(), "XML_TAG_ATTRIBUTE_VALUE", selection)) : 3 == curentValidatedNode.getNodeType() && (status = this.scanNodeContent(file, ((IDOMNode)curentValidatedNode).getFirstStructuredDocumentRegion(), "XML_CONTENT", selection))) {
                return status;
            }
            status = this.scanChildNodes(file, curentValidatedNode, selection);
            if (status) {
                return status;
            }
            ++i;
        }
        return false;
    }

    private boolean scanNodeContent(IFile file, IStructuredDocumentRegion node, String regionType, TextSelection selection) {
        boolean status = false;
        if (node == null) {
            return false;
        }
        ITextRegionList regions = node.getRegions();
        int i = 0;
        while (i < regions.size()) {
            int offset;
            String text;
            ITextRegion region = regions.get(i);
            if (region.getType() == regionType && (text = node.getFullText(region)).indexOf("{") > -1 && (status = this.scanString(file, text, offset = node.getStartOffset() + region.getStart(), selection))) {
                return status;
            }
            ++i;
        }
        return false;
    }

    private boolean checkContextVariableInProperties(IFile file, String content, TextSelection selection) {
        return this.scanString(file, content, 0, selection);
    }

    private ISeamComponent getComponent(IFile file) {
        IProject project = file.getProject();
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject != null) {
            Set components = seamProject.getComponentsByPath(editorFile.getFullPath());
            for (ISeamComponent component : components) {
                IResource resource;
                ISeamJavaComponentDeclaration declaration = component.getJavaDeclaration();
                if (declaration == null || (resource = declaration.getResource()) == null || !resource.getFullPath().equals((Object)editorFile.getFullPath()) || !declaration.getName().equals(component.getName())) continue;
                return component;
            }
        }
        return null;
    }

    private IAnnotation getNameAnnotation(IFile file) {
        try {
            ICompilationUnit unit = this.getCompilationUnit(file);
            IType[] iTypeArray = unit.getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                IAnnotation[] iAnnotationArray = type.getAnnotations();
                int n3 = iAnnotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation annotation = iAnnotationArray[n4];
                    if (EclipseJavaUtil.resolveType((IType)type, (String)annotation.getElementName()).equals(ANNOTATION_NAME)) {
                        return annotation;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            SeamCorePlugin.getDefault().logError((Throwable)ex);
        }
        return null;
    }

    private ICompilationUnit getCompilationUnit(IFile file) throws CoreException {
        IProject project = file.getProject();
        IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        IResource[] iResourceArray = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            IJavaElement element;
            IResource resource = iResourceArray[n2];
            if (resource.getFullPath().isPrefixOf(file.getFullPath()) && (element = javaProject.findElement(path = file.getFullPath().removeFirstSegments(resource.getFullPath().segmentCount()))) instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            ++n2;
        }
        return null;
    }

    private String getPropertyName(IMethod method) {
        String name = method.getElementName();
        if (name.startsWith(GET) || name.startsWith(SET)) {
            return name.substring(3).toLowerCase();
        }
        if (name.startsWith(IS)) {
            return name.substring(2).toLowerCase();
        }
        return name.toLowerCase();
    }

    private static void saveAndBuild() {
        if (!SeamGuiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true)) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void invokeRenameComponentWizard(ISeamComponent component, Shell activeShell) {
        SeamRefactorContributionFactory.saveAndBuild();
        RenameComponentProcessor processor = new RenameComponentProcessor(component);
        RenameComponentRefactoring refactoring = new RenameComponentRefactoring((RenameProcessor)processor);
        RenameComponentWizard wizard = new RenameComponentWizard((Refactoring)refactoring, component);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = SeamCoreMessages.SEAM_COMPONENT_RENAME_HANDLER_ERROR;
            op.run(activeShell, titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void invokeRenameSeamContextVariableWizard(String oldName, Shell activeShell) {
        SeamRefactorContributionFactory.saveAndBuild();
        RenameSeamContextVariableProcessor processor = new RenameSeamContextVariableProcessor(editorFile, selectedText);
        RenameComponentRefactoring refactoring = new RenameComponentRefactoring((RenameProcessor)processor);
        RenameSeamContextVariableWizard wizard = new RenameSeamContextVariableWizard((Refactoring)refactoring, editorFile);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = SeamCoreMessages.SEAM_COMPONENT_RENAME_HANDLER_ERROR;
            op.run(activeShell, titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    class RenameSeamComponentAction
    extends Action {
        public RenameSeamComponentAction() {
            super(SeamCoreMessages.RENAME_SEAM_COMPONENT);
        }

        public void run() {
            SeamRefactorContributionFactory.saveAndBuild();
            ISeamComponent component = SeamRefactorContributionFactory.this.getComponent(editorFile);
            SeamRefactorContributionFactory.invokeRenameComponentWizard(component, SeamRefactorContributionFactory.this.shell);
        }
    }

    class RenameSeamContextVariableAction
    extends Action {
        public RenameSeamContextVariableAction() {
            super(SeamCoreMessages.RENAME_SEAM_CONTEXT_VARIABLE);
        }

        public void run() {
            SeamRefactorContributionFactory.saveAndBuild();
            SeamRefactorContributionFactory.invokeRenameSeamContextVariableWizard(selectedText, SeamRefactorContributionFactory.this.shell);
        }
    }
}

