/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.marker;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.preferences.SeamPreferencesMessages;
import org.jboss.tools.seam.ui.widget.editor.SeamRuntimeListFieldEditor;

public class AddNewSeamRuntimeMarkerResolution
implements IMarkerResolution2 {
    private IProject project;
    private String runtimeName;
    private String label;

    public AddNewSeamRuntimeMarkerResolution(IMarker marker) {
        this.project = (IProject)marker.getResource();
        IEclipsePreferences preferences = SeamCorePlugin.getSeamPreferences((IProject)this.project);
        this.runtimeName = preferences.get("seam.runtime.name", "");
        this.label = MessageFormat.format(SeamCoreMessages.ADD_NEW_SEAM_RUNTIME_MARKER_RESOLUTION_TITLE, this.runtimeName);
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IProject) {
            String runtimeVersion = "";
            try {
                IProjectFacetVersion facetVersion;
                IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
                if (facetedProject != null && (facetVersion = facetedProject.getInstalledVersion(facet)) != null) {
                    runtimeVersion = SeamVersion.parseFromString((String)facetVersion.getVersionString()).toString();
                }
            }
            catch (CoreException ex) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
            }
            SeamRuntimeListFieldEditor seamRuntimes = new SeamRuntimeListFieldEditor("rtlist", SeamPreferencesMessages.SEAM_PREFERENCE_PAGE_SEAM_RUNTIMES, new ArrayList<SeamRuntime>(Arrays.asList(SeamRuntimeManager.getInstance().getRuntimes())));
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Composite root = new Composite((Composite)shell, 0);
            root.setVisible(false);
            seamRuntimes.getEditorControls(root);
            seamRuntimes.getAddAction().run(this.runtimeName, runtimeVersion);
            for (SeamRuntime rt : seamRuntimes.getAddedSeamRuntimes()) {
                SeamRuntimeManager.getInstance().addRuntime(rt);
            }
            SeamRuntimeManager.getInstance().save();
            seamRuntimes.dispose();
        }
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return null;
    }
}

