/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.persistence.details;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.persistence.JptJpaUiPersistenceMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.jboss.tools.hibernate.jpt.core.internal.context.persistence.PackageInfoRef;
import org.jboss.tools.hibernate.jpt.ui.HibernateJptUIPlugin;
import org.jboss.tools.hibernate.jpt.ui.internal.persistence.details.AddMappingListPane;
import org.jboss.tools.hibernate.jpt.ui.internal.persistence.details.ExtendedAdapter;
import org.jboss.tools.hibernate.jpt.ui.internal.persistence.details.Messages;

public class HibernatePersistenceUnitClassesComposite
extends Pane<PersistenceUnit> {
    public HibernatePersistenceUnitClassesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private ClassRef addMappedClass() {
        String className;
        IType type = this.chooseType();
        ClassRef result = null;
        if (type != null && (result = this.getClassRef(className = type.getFullyQualifiedName('$'))) == null) {
            result = ((PersistenceUnit)this.getSubject()).addSpecifiedClassRef(className);
        }
        return result;
    }

    private ClassRef addMappedPackage() {
        IPackageFragment pack = this.choosePackage();
        ClassRef result = null;
        if (pack != null && (result = this.getClassRef(pack.getElementName())) == null) {
            result = ((PersistenceUnit)this.getSubject()).addSpecifiedClassRef(pack.getElementName());
        }
        return result;
    }

    private ClassRef getClassRef(String className) {
        for (ClassRef classRef : ((PersistenceUnit)this.getSubject()).getSpecifiedClassRefs()) {
            if (!classRef.getClassName().equals(className)) continue;
            return classRef;
        }
        return null;
    }

    private ExtendedAdapter buildAdapter() {
        return new ExtendedAdapter(){

            public void optionOnSelection(CollectionValueModel<ClassRef> selectedItemsModel) {
                Iterator iterator = selectedItemsModel.iterator();
                if (iterator.hasNext()) {
                    HibernatePersistenceUnitClassesComposite.this.openMappedClass((ClassRef)iterator.next());
                }
            }

            public ClassRef addNewItem() {
                return HibernatePersistenceUnitClassesComposite.this.addMappedClass();
            }

            public void removeSelectedItems(CollectionValueModel<ClassRef> selectedItemsModel) {
                Iterator iterator = selectedItemsModel.iterator();
                while (iterator.hasNext()) {
                    ((PersistenceUnit)HibernatePersistenceUnitClassesComposite.this.getSubject()).removeSpecifiedClassRef((ClassRef)iterator.next());
                }
            }

            @Override
            public ClassRef addPackage(ModifiableCollectionValueModel<ClassRef> listSelectionModel) {
                return HibernatePersistenceUnitClassesComposite.this.addMappedPackage();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildExcludeUnlistedMappedClassesHolder() {
        return new PropertyAspectAdapter<PersistenceUnit, Boolean>(this.getSubjectHolder(), new String[]{"specifiedExcludeUnlistedClasses"}){

            protected Boolean buildValue_() {
                return ((PersistenceUnit)this.subject).getSpecifiedExcludeUnlistedClasses();
            }

            protected void setValue_(Boolean value) {
                if (value != null && !value.booleanValue()) {
                    value = null;
                }
                ((PersistenceUnit)this.subject).setSpecifiedExcludeUnlistedClasses(value);
            }
        };
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                Image image = null;
                if (element instanceof ClassRef) {
                    PackageInfoRef packageInfoRef;
                    ClassRef classRef = (ClassRef)element;
                    JavaPersistentType persistentType = classRef.getJavaPersistentType();
                    if (persistentType != null) {
                        image = this.getImage(persistentType);
                    } else if (classRef instanceof PackageInfoRef && (packageInfoRef = (PackageInfoRef)classRef).getJavaPackageInfo() != null) {
                        image = JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_OBJS_PACKAGE);
                    }
                }
                if (image != null) {
                    return image;
                }
                return HibernateJptUIPlugin.getDefault().getImage("warning");
            }

            public String getText(Object element) {
                ClassRef classRef = (ClassRef)element;
                String name = classRef.getClassName();
                if (name == null) {
                    name = JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_CLASS_REF_NO_NAME;
                }
                return name;
            }
        };
    }

    private ListValueModel<ClassRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"javaManagedType", "className"});
    }

    private ListValueModel<ClassRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, ClassRef>(this.getSubjectHolder(), new String[]{"specifiedClassRefs"}){

            protected ListIterator<ClassRef> listIterator_() {
                return ((PersistenceUnit)this.subject).getSpecifiedClassRefs().iterator();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getSpecifiedClassRefsSize();
            }
        };
    }

    private ModifiableCollectionValueModel<ClassRef> buildSelectedItemHolder() {
        return new SimpleCollectionValueModel();
    }

    private IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            HibernateJptUIPlugin.logException(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_TITLE);
        typeSelectionDialog.setMessage(JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_MESSAGE);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IType findType(ClassRef classRef) {
        String className = classRef.getClassName();
        if (className != null) {
            try {
                return ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject().findType(className.replace('$', '.'));
            }
            catch (JavaModelException e) {
                HibernateJptUIPlugin.logException(e);
            }
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        return DialogSelectionHelper.choosePackage((Shell)this.getShell(), (IJavaElement[])new IJavaProject[]{this.getJavaProject()}, (IFilter)this.createPackageFilter(), (String)Messages.HibernatePersistenceUnitClassesComposite_PackageSelectionDialog_title, (String)JptCommonUiMessages.CLASS_CHOOSER_PANE__DIALOG_MESSAGE);
    }

    protected IFilter createPackageFilter() {
        return new IFilter(){

            public boolean select(Object element) {
                if (element instanceof PackageFragment) {
                    PackageFragment pf = (PackageFragment)element;
                    return pf.getCompilationUnit("package-info.java").exists();
                }
                return false;
            }
        };
    }

    protected void initializeLayout(Composite container) {
        new AddMappingListPane<ClassRef>((Pane)this, container, (AddRemovePane.Adapter)this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL){

            protected void initializeTable(Table table) {
                super.initializeTable(table);
                Composite container = table.getParent();
                GridData gridData = (GridData)container.getLayoutData();
                gridData.heightHint = 75;
            }
        };
        this.addCheckBox(container, JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_CLASSES_COMPOSITE_EXCLUDE_UNLISTED_CLASSES, this.buildExcludeUnlistedMappedClassesHolder(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL);
    }

    private void openMappedClass(ClassRef classRef) {
        IType type = this.findType(classRef);
        if (type != null) {
            try {
                IJavaElement javaElement = type.getParent();
                JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
            }
            catch (PartInitException e) {
                HibernateJptUIPlugin.logException(e);
            }
            catch (JavaModelException e) {
                HibernateJptUIPlugin.logException(e);
            }
        }
    }

    private IJavaProject getJavaProject() {
        return ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject();
    }
}

