/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.GeneratorContainer;
import org.eclipse.jpt.jpa.ui.internal.details.GenerationComposite;
import org.eclipse.jpt.jpa.ui.internal.details.GeneratorComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateGenericGeneratorContainer;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaDbGenericGenerator;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.GenericGeneratorComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.GenericGeneratorsComposite;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;

public class HibernateGenerationComposite
extends GenerationComposite {
    private ModifiablePropertyValueModel<Boolean> genericGeneratorExpansionStateHolder;
    private ModifiablePropertyValueModel<JavaDbGenericGenerator> generatorHolder;

    public HibernateGenerationComposite(Pane<?> parentPane, PropertyValueModel<? extends GeneratorContainer> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initialize() {
        super.initialize();
        this.genericGeneratorExpansionStateHolder = new SimplePropertyValueModel((Object)Boolean.FALSE);
        this.generatorHolder = this.buildGeneratorHolder();
    }

    private ModifiablePropertyValueModel<JavaDbGenericGenerator> buildGeneratorHolder() {
        return new SimplePropertyValueModel();
    }

    public HibernateGenericGeneratorContainer getSubject() {
        return (HibernateGenericGeneratorContainer)super.getSubject();
    }

    protected void doPopulate() {
        super.doPopulate();
        this.genericGeneratorExpansionStateHolder.setValue((Object)(this.getSubject() != null && this.getSubject().getGenericGeneratorsSize() > 0 ? 1 : 0));
        this.generatorHolder.setValue(this.getSubject() != null && this.getSubject().getGenericGeneratorsSize() > 0 ? (JavaDbGenericGenerator)this.getSubject().getGenericGenerators().iterator().next() : null);
    }

    protected void initializeLayout(Composite container) {
        super.initializeLayout(container);
        this.initializeGenericGeneratorPane(container);
    }

    private void initializeGenericGeneratorPane(Composite container) {
        container = this.addSection(this.addSubPane(container, 10), HibernateUIMappingMessages.HibernateGeneratorsComposite_SectionLabel, "");
        Button genericGeneratorCheckBox = this.addCheckBox(this.addSubPane(container, 5), HibernateUIMappingMessages.HibernateGeneratorsComposite_CheckBoxLabel, this.buildGenericGeneratorBooleanHolder(), null);
        if (((GeneratorContainer)this.getSubjectHolder().getValue()).getParent() instanceof AttributeMapping) {
            if (this.getSubject().getGenericGeneratorsSize() > 0) {
                this.generatorHolder.setValue((Object)((JavaDbGenericGenerator)this.getSubject().getGenericGenerators().iterator().next()));
            }
            this.addGenericGeneratorComposite(container, 0, genericGeneratorCheckBox.getBorderWidth() + 16);
        } else {
            this.addGenericGeneratorsComposite(container, 0, genericGeneratorCheckBox.getBorderWidth() + 16);
        }
    }

    protected void addGenericGeneratorsComposite(Composite container, int topMargin, int leftMargin) {
        new GenericGeneratorsComposite((Pane<?>)this, (PropertyValueModel<? extends HibernateGenericGeneratorContainer>)this.getSubjectHolder(), this.addSubPane(container, topMargin, leftMargin));
    }

    protected void addGenericGeneratorComposite(Composite container, int topMargin, int leftMargin) {
        new GenericGeneratorComposite((Pane<?>)this, (PropertyValueModel<JavaDbGenericGenerator>)this.generatorHolder, this.addSubPane(container, topMargin, leftMargin), this.buildGenericGeneratorBuilder());
    }

    protected GeneratorComposite.GeneratorBuilder<JavaDbGenericGenerator> buildGenericGeneratorBuilder() {
        return new GeneratorComposite.GeneratorBuilder<JavaDbGenericGenerator>(){

            public JavaDbGenericGenerator addGenerator() {
                HibernateGenericGeneratorContainer container = HibernateGenerationComposite.this.getSubject();
                JavaDbGenericGenerator generator = container.addGenericGenerator(container.getGenericGeneratorsSize());
                HibernateGenerationComposite.this.generatorHolder.setValue((Object)generator);
                return generator;
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildGenericGeneratorBooleanHolder() {
        return new PropertyAspectAdapter<GeneratorContainer, Boolean>(this.getSubjectHolder(), new String[]{"genericGenerators"}){

            protected Boolean buildValue_() {
                return ((HibernateGenericGeneratorContainer)this.subject).getGenericGeneratorsSize() > 0;
            }

            protected void setValue_(Boolean value) {
                HibernateGenericGeneratorContainer container = (HibernateGenericGeneratorContainer)this.subject;
                if (value.booleanValue()) {
                    JavaDbGenericGenerator gc = container.addGenericGenerator(container.getGenericGeneratorsSize());
                    HibernateGenerationComposite.this.generatorHolder.setValue((Object)gc);
                } else if (!value.booleanValue()) {
                    int i = 0;
                    while (i < container.getGenericGeneratorsSize()) {
                        container.removeGenericGenerator(0);
                        ++i;
                    }
                    HibernateGenerationComposite.this.generatorHolder.setValue(null);
                }
            }
        };
    }
}

